package jp.ac.dendai.cdl.mori.wikie.mapper;

import java.io.*;
import java.util.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

public class VariationMapper extends WikipediaMapper 
        implements Mapper<LongWritable, Text, Text, Text> {
    @Override
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            String page = WikipediaNormalizer.removeNonPrintingCharacter(value.toString());
            String title = normalizer.normalize(WikipediaMapper.getValueFromElementName(WikIE.TITLE_ELEMENT, page, 0, 1));
            String text = WikipediaMapper.getValueFromElementName(WikIE.TEXT_ELEMENT, page, 0, 1);
            String kind = linkChecker.getKind(title, text);
            if (kind.equals(WikIE.LEAF)) {
                Iterator<WikipediaLink> itr = linkChecker.getPageLink(text).iterator();
                while (itr.hasNext()) {
                    WikipediaLink link = itr.next();
                    if (normalizer.getNamespaceNumber(link.getEntryTitle()) == 0)
                        output.collect(new Text(link.getEntryTitle()), new Text(link.getAnchorText()));
                }
            }
        }

        catch (NullPointerException e) {
            // TODO: handle exception
        }
    }
}
