package jp.ac.dendai.cdl.mori.wikie.mapper;

import java.io.*;

import jp.ac.dendai.cdl.mori.wikie.main.*;
import jp.ac.dendai.cdl.mori.wikie.util.*;

import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * node処理用Mapper
 * @author Mori
 *
 */
public class NodeMapper extends WikipediaMapper
        implements Mapper<LongWritable, Text, Text, Text> {
    @Override
    public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        try {
            String page = WikipediaNormalizer.removeNonPrintingCharacter(value.toString());
            String title = normalizer.normalize(WikipediaMapper.getValueFromElementName(WikIE.TITLE_ELEMENT, page, 0, 1));
            String id  = WikipediaMapper.getValueFromElementName(WikIE.ID_ELEMENT, page, 0, 1);
            String text = WikipediaMapper.getValueFromElementName(WikIE.TEXT_ELEMENT, page, 0, 1);
            String kind = linkChecker.getKind(title, text);
            if (!kind.equals(WikIE.OTHER)) {
                output.collect(new Text(id), new Text(title + "\t" + kind));
            }
        }
        catch (NullPointerException e) {
            // TODO: handle exception
        }
    }

}
