package jp.ac.dendai.cdl.mori.wikie.main;

import jp.ac.dendai.cdl.mori.wikie.io.*;
import jp.ac.dendai.cdl.mori.wikie.mapper.*;
import jp.ac.dendai.cdl.mori.wikie.reducer.*;

import org.apache.hadoop.conf.*;
import org.apache.hadoop.fs.*;
import org.apache.hadoop.io.*;
import org.apache.hadoop.mapred.*;

/**
 * MapReduce処理を始めるクラス
 * @author Mori
 *
 */
public class Driver {
    public static final String PROP_RESOURCE = "wikie.map.sourcefilepath";
    public static final String PROP_SPLIT_ELEMENT = "wikie.map.splitelement";
    public static final String PROP_START_TAG = "wikie.io.startTag";
    public static final String PROP_END_TAG = "wikie.io.endTag";
    public static final String PROP_ISBN_HEADER = "wikie.map.isbnheader";

    /**
     * 基本的なJobConfを生成する
     * @param args
     * @return 基本的な設定を施したJobConfインスタンス
     */
    public static JobConf createJobConf(String[] args) {
        JobConf conf = new JobConf(Driver.class);
        conf.setInputFormat(XMLInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setInputPath(new Path(args[0]));
        conf.setOutputPath(new Path(getNewDirectory(args[1])));
        conf.set(PROP_RESOURCE, args[0]);
        conf.set(PROP_START_TAG, WikIE.PAGE_ELEMENT);
        conf.set(PROP_END_TAG, WikIE.PAGE_ELEMENT);
        return conf;
    }

    /**
     * nodeファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void node (String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.node");
        conf.setMapperClass(NodeMapper.class);
        conf.setReducerClass(NodeReducer.class);
        JobClient.runJob(conf);
    }

    /**
     * edgeファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void edge(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.edge");
        conf.setMapperClass(EdgeMapper.class);
        conf.setReducerClass(EdgeReducer.class);
        JobClient.runJob(conf);
    }

    /**
     * pageLinkファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void pageLink(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.pagelink");
        conf.setMapperClass(PageLinkMapper.class);
        conf.setReducerClass(PageLinkReducer.class);
        JobClient.runJob(conf);
    }
    
    /**
     * pageLinkファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void variation(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.variation");
        conf.setMapperClass(VariationMapper.class);
        conf.setReducerClass(VariationReducer.class);
        JobClient.runJob(conf);
    }

    /**
     * isbnファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void isbn(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.isbn");
        conf.setMapperClass(ISBNMapper.class);
        conf.setReducerClass(ISBNReducer.class);
        conf.set(Driver.PROP_ISBN_HEADER, "978");
        JobClient.runJob(conf);
    }

    /**
     * interWikiファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void interWiki(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.interwiki");
        conf.setMapperClass(InterWikiMapper.class);
        conf.setReducerClass(InterWikiReducer.class);
        JobClient.runJob(conf);
    }
    
    /**
     * historyファイルの生成を開始する
     * @param args
     * @throws Exception
     */
    public static void history(String[] args) throws Exception {
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.interwiki");
        conf.setMapperClass(HistoryMapper.class);
        conf.setReducerClass(HistoryReducer.class);
        JobClient.runJob(conf);
    }

    public static void test(String[] args) throws Exception {
        /*
        JobConf conf = createJobConf(args);
        conf.setJobName("wikie.test");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(TestMapper.class);
        conf.setReducerClass(TestReducer.class);
        JobClient.runJob(conf);
        */
        JobConf conf = createJobConf(args);
        conf.setInputFormat(XMLInputFormat.class);
        conf.setJobName("wikie.node2");
        conf.setMapperClass(NodeMapper.class);
        conf.setReducerClass(NodeReducer.class);
        JobClient.runJob(conf);
    }


    public static String getNewDirectory(String name) {
        try {
            int num = 1;
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get(conf);
            while (true) {
                String newDirectory = name + num;
                if (!fs.exists(new Path(fs.getWorkingDirectory(), newDirectory))) {
                    return newDirectory;
                }
                num++;
            }
        }
        catch (Exception e) {
            return name;
        }
    }
}
