<?php
// 
// WHLX CMS - ping.php
// 
// 20040422 - 0.00 alpha    
// 20040422 - 0.10 alpha    変数 $script_title -> 定数 WHLX_SCRIPT_TITLE
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_node.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_document.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

define( 'WHLX_SCRIPT_TITLE', 'WHLX CMS - Ping送信スクリプト' );    // 

define( 'WHLX_USER_AGENT'  , 'WHLX_CMS/0.10alpha' );    // 

// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data, $debug );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_Main( $error, $message, $others, $whlx, $form );
// // 
function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'ping' ];
	$attribute[ 'action'  ] .= '?'.  'destination='.  $form[ 'destination' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attribute[ 'lang'    ] =  'ja';

	// フォームを使って送信された文字列の中の「HTMLタグ」「改行コード」を変換します. 
	// フォームを使って送信された文字列の文字数を制限します. 
	// 関数 WHLX_DateTimeString は './utility.php' の中で記述されている補助関数です. 
	// 関数 WHLX_ConvertString  は './utility.php' の中で記述されている補助関数です. 
	// この部分はスクリプトの種類によって変化します. 
	$form[ 'date'        ] =  WHLX_DateTimeString();                                       
	$form[ 'title'       ] =  WHLX_ConvertString( $form[ 'title'     ], 0x007F,   64 );    
	$form[ 'excerpt'     ] =  WHLX_ConvertString( $form[ 'excerpt'   ], 0x007F, 4096 );    
	$form[ 'blog_name'   ] =  WHLX_ConvertString( $form[ 'blog_name' ], 0x007F,   64 );    
	$form[ 'url'         ] =  WHLX_ConvertString( $form[ 'url'       ], 0x007F,   64 );    
	$form[ 'pw_crypt'    ] =  $whlx[ 'owner' ][ 'password' ];
	$form[ 'xslt'        ] =  './_default.xsl';                                                                          // 


	while( 1 )
	{
		$error   =  1;
		$message =  "\t\t".  'FAILED    : Ping 送信に失敗しました. '.  "\r\n";
		$others  =  '';

		$result  =  WHLX_PostingXML_PingSend( $e, $m, $o, $form );
		if( !$result ) break;

		$error   =  0;
		$message =  "\t\t".  'SUCCEEDED : Ping 送信に成功しました. '.  "\r\n";
		$others  =  '';

		break;
	}


	$others =  "\r\n";
	$others .= "\t\t".  '<title> '.  WHLX_SCRIPT_TITLE.  ' </title> '.  "\r\n";
	$others .= "\t\t".  '<form password=""> '.  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes  ( $attribute );
	$others .= WHLX_PostingXML_FormDataEntered ( $form      );
	$others .= "\t\t".  '</form> '           .  "\r\n";    
	$others .= "\t\t".  '<!-- '.  "\r\n";    
	$others .= $o;
	$others .= "\t\t".  '--> ' .  "\r\n";    

	return true;
}




?>
