<?php
// 
// WHLX CMS - crypt.php
// 
// 20040410 - 0.00 alpha
// 20040413 - 0.06 alpha    whlx.ini の仕様変更に伴う少々の変更. 
// 20040422 - 0.10 alpha    変数 $script_title -> 定数 WHLX_SCRIPT_TITLE
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
// include_once  $whlx[ 'directory' ][ 'library' ].  './datacheck.php';
// include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

define( 'WHLX_SCRIPT_TITLE', 'WHLX CMS - パスワード生成スクリプト' );    // 

// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_Main( $error, $message, $others, $whlx, $form );
// // 
function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'crypt' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attribute[ 'lang'    ] =  'ja';

	$seed  =  'pw'; //    $header[ '_POST' ][ 'seed' ];
	$key   =  $form[ 'password' ];
	$crypt =  crypt( $key, $seed );
	
	$error   =  0;    

	$message =  "\n".    
		"\t\t".  '<label> <input type="text" readonly="" value="'.  $seed.   '" /> Seed  </label> <br /> '.                                        "\r\n".    
		"\t\t".  '<label> <input type="text" readonly="" value="'.  $key.    '" /> Key   </label> <br /> '.                                        "\r\n".    
		"\t\t".  '<label> <input type="text" readonly="" value="'.  $crypt.  '" /> Crypt </label> <br /> '.                                        "\r\n".    
		"\t\t".  '<br /> '.                                                                                                                        "\r\n".    
		"\t\t".  '生成された Crypt はパスワードとして使用可能です. <br /> '.                                                                       "\r\n".    
		"\t\t".  '<br /> '.                                                                                                                        "\r\n".    
		"\t\t".  'オーナー・パスワードの場合は, 設定ファイル                 whlx.ini         の [owner]   password と置き換えて下さい. <br /> '.  "\r\n".    
		"\t\t".  '設定例 <br /> '.                                                                                                                 "\r\n".    
		"\t\t".  '[owner]   <br /> '.                                                                                                              "\r\n".    
		"\t\t".  'password =  "'.  $crypt.  '" <br /> '.                                                                                           "\r\n".    
		"\t\t".  '<br /> '.                                                                                                                        "\r\n".    
		"\t\t".  'ユーザー・パスワードの場合は, 各々のプロファイル・ファイル profile.????.ini の [profile] password と置き換えて下さい. <br /> '.  "\r\n".    
		"\t\t".  '設定例 <br /> '.                                                                                                                 "\r\n".    
		"\t\t".  '[profile] <br /> '.                                                                                                              "\r\n".    
		"\t\t".  'password =  "'.  $crypt.  '" <br /> '.                                                                                           "\r\n".    
		"\t\t".  '<br /> '.                                                                                                                        "\r\n";    

	$others =  "\r\n";
	$others .= "\t\t".  '<title> '.  WHLX_SCRIPT_TITLE.  ' </title> '.  "\r\n";
	$others .= "\t\t".  '<form password=""> '.  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes  ( $attribute );
	$others .= WHLX_PostingXML_FormDataEntered ( $form      );
	$others .= "\t\t".  '</form> '           .  "\r\n";    

	return  true;
}




?>
