<?xml            version="1.0" encoding="UTF-8" ?> 

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> 
	<xsl:output method="xml" indent="yes" encoding="UTF-8" media-type="application/xhtml+xml" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" /> 

	<xsl:template match="/"> 
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" dir="ltr"> 
			<head> 
				<title> <xsl:value-of select="/response/others/title" /> </title> 
				<meta http-equiv="Content-Type"        content="application/xhtml+xml; charset=UTF-8" /> 
				<meta http-equiv="Content-Language"    content="ja"                                   /> 
				<meta http-equiv="Content-Script-Type" content="text/javascript;       charset=UTF-8" /> 
				<meta http-equiv="Content-Style-Type"  content="text/css;              charset=UTF-8" /> 
				<link rel="stylesheet" type="text/css" href="./_script.css" /> 
			</head> 

			<body class="whlx_base"> 
				<div class="whlx_head"> 
					<h1> <xsl:value-of select="/response/others/title" /> </h1> 
				</div> 
				<div class="whlx_body"> 
					<div class="whlx_main"> 
						<div class="note_head"> 
							<a href="../index.xml"                             class="note_back"> Index    </a> 
							<a href="{/response/others/form/attribute/action}" class="note_fwrd"> Script   </a> 
							<a href="{/response/others/link}"                  class="note_back"> New File </a> 
						</div> 
						<div class="note_body"> 
							<xsl:apply-templates select="/response/others/form"       /> 
							<xsl:apply-templates select="/response/others/result"     /> 
						</div> 
					</div> 
					<div class="whlx_menu"> 
						<xsl:if test="/response/error =  '0'"> <h2> Succeeded </h2> </xsl:if> 
						<xsl:if test="/response/error != '0'"> <h2> Failed    </h2> </xsl:if> 
						<xsl:copy-of select="/response/message" /> 
					</div> 
				</div> 
				<div class="whlx_foot"> 
				</div> 
			</body> 
		</html> 
	</xsl:template> 




	<!-- form XHTML --> 
	<xsl:template match="/response/others/form      "> 
		<form class="post_base" action="{./attribute/action}" method="{./attribute/method}" accept="{./attribute/accept}" accept-charset="{./attribute/charset}" enctype="{./attribute/enctype}" lang="{./attribute/lang}"> 
			<h2> Form </h2> 
			<xsl:apply-templates select="./file      " /> 
			<xsl:apply-templates select="./title     " /> 
			<xsl:apply-templates select="./url       " /> 
			<xsl:apply-templates select="./text      " /> 
			<xsl:apply-templates select="./style_br  " /> 
			<xsl:apply-templates select="./style_tg  " /> 
			<xsl:apply-templates select="./excerpt   " /> 
			<xsl:apply-templates select="./ping      " /> 
			<xsl:apply-templates select="./creator   " /> 
			<xsl:apply-templates select="./blog_name " /> 
			<xsl:apply-templates select="./date      " /> 
			<xsl:apply-templates select="./trackback " /> 
			<xsl:apply-templates select="./category  " /> 
			<xsl:apply-templates select="./profile   " /> 
			<xsl:apply-templates select="./fileselect" /> 
			<xsl:apply-templates select="./@password " /> 
			<label class="post_label"> Submit <input class="post_input" type="submit" value="{./attribute/action}" /> </label> <br /> 
		</form> 
	</xsl:template> 

	<!-- form 項目入力系 --> 
	<xsl:template match="/response/others/form/@password "> <label class="post_label"> Password    <input    class="post_input" type="password"       name="password"   value=""                                          /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/file      "> <label class="post_label"> File        <input    class="post_input" type="file"           name="file"       value=""                                          /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/title     "> <label class="post_label"> Title       <input    class="post_input" type="text"           name="title"      value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/url       "> <label class="post_label"> URL         <input    class="post_input" type="text"           name="url"        value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/text      "> <label class="post_label"> Text        <textarea class="post_input" rows="10" wrap="off"  name="text"       ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/excerpt   "> <label class="post_label"> Excerpt     <textarea class="post_input" rows="10" wrap="off"  name="excerpt"    ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/ping      "> <label class="post_label"> Ping        <textarea class="post_input" rows="4"  wrap="off"  name="ping"       ><xsl:copy-of select="text() | * | @*" /></textarea> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/creator   "> <label class="post_label"> Creator     <input    class="post_input" type="text"           name="creator"    value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/blog_name "> <label class="post_label"> Name        <input    class="post_input" type="text"           name="blog_name"  value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/date      "> <label class="post_label"> Date        <xsl:copy-of select="text() | * | @*" />                                                                                  </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/trackback "> <label class="post_label"> Trackback   <input    class="post_input" type="text"           name="trackback"  value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 

	<!-- form 項目選択系 --> 
	<xsl:template match="/response/others/form/style_br  "> <label class="post_label"> CR/LF       <input    class="post_input" type="checkbox"       name="style_br"   value="true"                                      /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/style_tg  "> <label class="post_label"> XHTML TAG   <input    class="post_input" type="checkbox"       name="style_tg"   value="true"                                      /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/category  "> <label class="post_label"> Category    <input    class="post_input" type="text"           name="category"   value="0001"                                      /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/profile   "> <label class="post_label"> Profile     <input    class="post_input" type="text"           name="profile"    value="{text() | * | @*}"                         /> </label> <br /> </xsl:template> 
	<xsl:template match="/response/others/form/fileselect"> <label class="post_label"> File Select <select   class="post_input"                       name="fileselect" > <xsl:for-each select="./file"> 
			<xsl:if test="./@selected = 'true' "> <option value="{./@fileselect}" selected=""> <xsl:value-of select="./@fileselect" /> </option> </xsl:if> 
			<xsl:if test="./@selected = 'false'"> <option value="{./@fileselect}"            > <xsl:value-of select="./@fileselect" /> </option> </xsl:if> 
		</xsl:for-each> </select> </label> <br /> </xsl:template> 




	<xsl:template match="/response/others/result"> 
		<xsl:variable name="link" select="./item/url/* | ./item/url/@* | ./item/url/text()" /> 
		<div class="resp_base"> 
			<h2> Preview </h2> 
			<h2  class="resp_head"> <a href="{$link}">  <xsl:value-of select="./item/title    /* | ./item/title    /@* | ./item/title    /text()" /> </a> </h2>  
			<xsl:apply-templates select="./file" /> 
			<div class="resp_body">                     <xsl:copy-of  select="./item/text     /* | ./item/text     /@* | ./item/text     /text()" />      </div> 
			<div class="resp_body">                     <xsl:copy-of  select="./item/excerpt  /* | ./item/excerpt  /@* | ./item/excerpt  /text()" />      </div> 
			<ul  class="resp_ping"> <li> PING DESTINATIONS </li> 
				                                    <xsl:for-each select="./item/ping"> 
				           <li> <a href="{./@url}"> <xsl:value-of select="./@url" /> </a> </li> 
				                                    </xsl:for-each> 
			</ul>  
			<h3  class="resp_foot">                     <xsl:value-of select="./item/creator  /* | ./item/creator  /@* | ./item/creator  /text()" />      </h3>  
			<h3  class="resp_foot">                     <xsl:value-of select="./item/blog_name/* | ./item/blog_name/@* | ./item/blog_name/text()" />      </h3>  
			<h3  class="resp_foot">                     <xsl:value-of select="./item/date     /* | ./item/date     /@* | ./item/date     /text()" />      </h3>  
			<h3  class="resp_foot">                     <xsl:value-of select="./item/trackback/* | ./item/trackback/@* | ./item/trackback/text()" />      </h3>  
		</div> 
	</xsl:template> 

	<xsl:template match="/response/others/result/item       /file"> 
		<xsl:if test="./image = 'true' "> 
			<div class="resp_file"> 
				<a href="{./source}"> <img alt="{./alt}" src="{./source}" width="{./width}" height="{./height}" /> </a> <br /> 
				[Type <xsl:value-of select="./type" />] [Size <xsl:value-of select="./size" />Bytes] [Origin <xsl:value-of select="./name" />] <br /> 
			</div> 
		</xsl:if> 
		<xsl:if test="./image = 'false'"> 
			<div class="resp_file"> 
				<a href="{./source}"> <xsl:value-of select="./alt" /> </a> <br /> 
				[Type <xsl:value-of select="./type" />] [Size <xsl:value-of select="./size" />Bytes] [Origin <xsl:value-of select="./name" />] <br /> 
			</div> 
		</xsl:if> 
	</xsl:template> 




</xsl:stylesheet> 

