<?php
// 
// WHLX CMS - postingxml.php
// 
// 20040417 - 0.00 alpha
// 20040425 - 0.01 alpha    Ping (<ping ...> タグ)追加. 
// 20040426 - 0.02 alpha    追加:WHLX_PostingXML_DataConvertor_????
// 20040426 - 0.03 alpha    追加:WHLX_PostingXML_DataChecker_????
// 20040428 - 0.04 alpha    関数 WHLX_PostingXML_Text_to_PingXHTML -> 関数 WHLX_PostingXML_Create_PingNode
// 20040428 - 0.05 alpha    関数 WHLX_PostingXML_FormDataUploaded  -> 関数 WHLX_PostingXML_Create_FileNode
// 20040502 - 0.06 alpha    php4 の domxml の使用を止めて, 独自クラスによる domxml を製作開始. 
// 




// WHLX_PostingXML_Profile( $path, $profile );    
// // 
function  WHLX_PostingXML_Profile( $path, &$profile )
{
	if( ( !is_string( $path    ) ) || ( $path    == '' ) ) $path    =  './';
	if( ( !is_string( $profile ) ) || ( $profile == '' ) ) $profile =  'anonymous';

	$file =  $path.  'profile.'.  $profile.  '.ini';

	if( !is_file( $file ) ){ $profile =  'anonymous';    $file =  $path.  'profile.anonymous.ini'; }
	if( !is_file( $file ) ){ $profile =  '';             return null;                              }

	return parse_ini_file( $file, true );
}

// WHLX_PostingXML_ProfileReflector_Article  ( $form, $ini );    
// // 
function  WHLX_PostingXML_ProfileReflector_Article  ( &$form, $ini )
{
	if( ( !is_string( $form[ 'title'     ] ) ) || ( $form[ 'title'     ] == '' ) ) $form[ 'title'     ] =  $ini[ 'template' ][ 'title'     ];
	if( ( !is_string( $form[ 'creator'   ] ) ) || ( $form[ 'creator'   ] == '' ) ) $form[ 'creator'   ] =  $ini[ 'template' ][ 'creator'   ];
	if( ( !is_string( $form[ 'text'      ] ) ) || ( $form[ 'text'      ] == '' ) ) $form[ 'text'      ] =  $ini[ 'template' ][ 'text'      ];
	if( ( !is_string( $form[ 'ping'      ] ) ) || ( $form[ 'ping'      ] == '' ) ) $form[ 'ping'      ] =  $ini[ 'template' ][ 'ping'      ];
	if( ( !is_string( $form[ 'category'  ] ) ) || ( $form[ 'category'  ] == '' ) ) $form[ 'category'  ] =  $ini[ 'template' ][ 'category'  ];
	return true;    
}

// WHLX_PostingXML_ProfileReflector_CT       ( $form, $data );    
// // 
function  WHLX_PostingXML_ProfileReflector_CT       ( &$form, $ini )
{
	if( ( !is_string( $form[ 'url'       ] ) ) || ( $form[ 'url'       ] == '' ) ) $form[ 'url'       ] =  $ini[ 'template' ][ 'url'       ];
	if( ( !is_string( $form[ 'title'     ] ) ) || ( $form[ 'title'     ] == '' ) ) $form[ 'title'     ] =  $ini[ 'template' ][ 'title'     ];
	if( ( !is_string( $form[ 'blog_name' ] ) ) || ( $form[ 'blog_name' ] == '' ) ) $form[ 'blog_name' ] =  $ini[ 'template' ][ 'blog_name' ];
	if( ( !is_string( $form[ 'excerpt'   ] ) ) || ( $form[ 'excerpt'   ] == '' ) ) $form[ 'excerpt'   ] =  $ini[ 'template' ][ 'excerpt'   ];
	return true;    
}

// WHLX_PostingXML_ProfileReflector_File     ( $form, $data );    
// // 
function  WHLX_PostingXML_ProfileReflector_File     ( &$form, $ini )
{
	return true;    
}





// WHLX_PostingXML_DataConvertor_Article  ( $form, $data );    
// // 
function  WHLX_PostingXML_DataConvertor_Article  ( &$form, $data )
{
	$form[ 'title'       ] =  $data->Get_Title     ();    
	$form[ 'title_short' ] =  $data->Get_TitleShort();    
	$form[ 'text'        ] =  $data->Get_Text      ();    
	$form[ 'creator'     ] =  $data->Get_Creator   ();    
	$form[ 'date'        ] =  WHLX_DateTimeString();    
	$form[ 'ping'        ] =  WHLX_UrlString_Checker( $form[ 'ping' ] );
	$form[ 'category'    ] =  '0001';
	return true;    
}




// WHLX_PostingXML_DataConvertor_CT       ( $form, $data );    
// // 
function  WHLX_PostingXML_DataConvertor_CT       ( &$form, $data )
{
	$form[ 'title'       ] =  $data->Get_Title     ();    
	$form[ 'title_short' ] =  $data->Get_TitleShort();    
	$form[ 'excerpt'     ] =  $data->Get_Excerpt   ();    
	$form[ 'blog_name'   ] =  $data->Get_BlogName  ();    
	$form[ 'url'         ] =  $data->Get_Url       ();    
	$form[ 'date'        ] =  WHLX_DateTimeString();    
	return true;    
}




// WHLX_PostingXML_DataConvertor_Ping     ( $form, $data );    
// // 
function  WHLX_PostingXML_DataConvertor_Ping     ( &$form, $data )
{
	$form[ 'title'       ] =  $data->Get_Title     ();    
	$form[ 'excerpt'     ] =  $data->Get_Excerpt   ();    
	$form[ 'blog_name'   ] =  $data->Get_BlogName  ();    
	$form[ 'url'         ] =  $data->Get_Url       ();    
	$form[ 'date'        ] =  WHLX_DateTimeString();    
	return true;    
}




// WHLX_PostingXML_DataChecker_Article  ( $error, $message, $form, $data );    
// // 
function  WHLX_PostingXML_DataChecker_Article  ( &$error, &$message, &$form, $data )
{
	// Error
	if( !$data->Check_Title      () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題       が未入力です. <br /> '.  "\r\n"; }
	if( !$data->Check_Text       () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文       が未入力です. <br /> '.  "\r\n"; }
	if( !$data->Check_Creator    () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 筆者名     が未入力です. <br /> '.  "\r\n"; }
	if( !$data->Check_Password   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : パスワード が違います.   <br /> '.  "\r\n"; }

	// Warning

	$message .= "\t\t".  '<br /> '.  "\r\n";

	if( $error == 0 ) return true;     
	else              return false;    
}




// WHLX_PostingXML_DataChecker_CT       ( $error, $message, $form, $data );    
// // 
function  WHLX_PostingXML_DataChecker_CT       ( &$error, &$message, &$form, $data )
{
	// Comment
	if( 'true' == $form[ 'comment' ] )
	{
		// Error
		if( !$data->Check_ID         () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 記事 ID   が未入力です. <br /> '.  "\r\n"; }
		if( !$data->Check_Title      () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 表題      が未入力です. <br /> '.  "\r\n"; }
		if( !$data->Check_Excerpt    () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 本文      が未入力です. <br /> '.  "\r\n"; }
		if( !$data->Check_BlogName   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信者名  が未入力です. <br /> '.  "\r\n"; }
	}

	// Trackback
	else
	{
		// Error
		if( !$data->Check_ID         () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 記事 ID   が未入力です. <br /> '.  "\r\n"; }
		if( !$data->Check_Url        () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信元URL が未入力です. <br /> '.  "\r\n"; }

		// Warning
		if( !$data->Check_Title      () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 表題      が未入力です. <br /> '.  "\r\n";    $form[ 'title'     ] =  $form[ 'url' ]; }
		if( !$data->Check_Excerpt    () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 本文      が未入力です. <br /> '.  "\r\n";    $form[ 'excerpt'   ] =  $form[ 'url' ]; }
		if( !$data->Check_BlogName   () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 送信者名  が未入力です. <br /> '.  "\r\n";    $form[ 'blog_name' ] =  $form[ 'url' ]; }
	}

	$message .= "\t\t".  '<br /> '.  "\r\n";

	if( $error == 0 ) return true;     
	else              return false;    
}




// WHLX_PostingXML_DataChecker_Ping( $error, $message, $form, $data );    
// // 
function  WHLX_PostingXML_DataChecker_Ping( &$error, &$message, &$form, $data )
{
	// Error
	if( !$data->Check_Url        () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信元 が未入力です.   <br /> '.  "\r\n"; }
	if( !$data->Check_Destination() ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 送信先 が未入力です.   <br /> '.  "\r\n"; }
	if( !$data->Check_Password   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : パスワード が違います. <br /> '.  "\r\n"; }

	// Warning
	if( !$data->Check_Title      () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 表題   が未入力です.   <br /> '.  "\r\n";    $form[ 'title'       ] =  $form[ 'url' ]; }
	if( !$data->Check_Excerpt    () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 本文   が未入力です.   <br /> '.  "\r\n";    $form[ 'excerpt'     ] =  $form[ 'url' ]; }
	if( !$data->Check_BlogName   () ){ $error |= 0;    $message .= "\t\t".  'WARNING   : 筆者名 が未入力です.   <br /> '.  "\r\n";    $form[ 'blog_name'   ] =  $form[ 'url' ]; }

	$message .= "\t\t".  '<br /> '.  "\r\n";

	if( $error == 0 ) return true;     
	else              return false;    
}




// WHLX_PostingXML_DataChecker_File     ( $error, $message, $form, $data );    
// // 
function  WHLX_PostingXML_DataChecker_File     ( &$error, &$message, &$form, $data )
{
	// Error
	if( !$data->Check_FileName   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイル名 が未入力です.  <br /> '.  "\r\n"; }
	if( !$data->Check_FileType   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルの種類が不正です. <br /> '.  "\r\n"; }
//	if( !$data->Check_FileSize   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルが大き過ぎます.   <br /> '.  "\r\n"; }
	if( !$data->Check_FileTmp    () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 受信側のエラーです.       <br /> '.  "\r\n"; }
//	if( !$data->Check_FileError  () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : エラーが発生しました.     <br /> '.  "\r\n"; }

	// Warning

	$message .= "\t\t".  '<br /> '.  "\r\n";


	// ファイル・アップロード関係の処理はここです. 
	$form[ 'upload'        ] =  ' ';
	$form[ 'upload_name'   ] =  $form[ '_FILES' ][ 'file' ][ 'name'     ];
	$form[ 'upload_type'   ] =  $form[ '_FILES' ][ 'file' ][ 'type'     ];
	$form[ 'upload_size'   ] =  $form[ '_FILES' ][ 'file' ][ 'size'     ];
	$form[ 'upload_tmp'    ] =  $form[ '_FILES' ][ 'file' ][ 'tmp_name' ];
	$form[ 'upload_alt'    ] =  '';
	$form[ 'upload_source' ] =  '';
	$form[ 'upload_width'  ] =  '';
	$form[ 'upload_height' ] =  '';
	$form[ 'upload_image'  ] =  'false';


	if( $error == 0 ) return true;     
	else              return false;    
}




// WHLX_PostingXML_DataChecker_Image    ( $error, $message, $form, $data );    
// // 
function  WHLX_PostingXML_DataChecker_Image    ( &$error, &$message, &$form, $data )
{
	// Error
	if( !$data->Check_FileName   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイル名 が未入力です.  <br /> '.  "\r\n"; }
	if( !$data->Check_FileType   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルの種類が不正です. <br /> '.  "\r\n"; }
//	if( !$data->Check_FileSize   () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : ファイルが大き過ぎます.   <br /> '.  "\r\n"; }
	if( !$data->Check_FileTmp    () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : 受信側のエラーです.       <br /> '.  "\r\n"; }
//	if( !$data->Check_FileError  () ){ $error |= 1;    $message .= "\t\t".  'ERROR     : エラーが発生しました.     <br /> '.  "\r\n"; }

	$image =  getimagesize( $form[ '_FILES' ][ 'file' ][ 'tmp_name' ] );    // 画像ファイルの内容をチェックします. 
	switch( $image[ 2 ] )
	{
	//	case  0: $form[ 'mime' ] =  'image/unknown'; break;
		case  1: $form[ 'mime' ] =  'image/gif';     break;
		case  2: $form[ 'mime' ] =  'image/jpeg';    break;
		case  3: $form[ 'mime' ] =  'image/png';     break;
		case  4: $form[ 'mime' ] =  'image/swf';     break;
		case  5: $form[ 'mime' ] =  'image/psd';     break;
		case  6: $form[ 'mime' ] =  'image/bmp';     break;
		case  7: $form[ 'mime' ] =  'image/tiff';    break;

		default: $form[ 'mime' ] =  'image/unknown'; 
		$error   |= 1;
		$message .= "\t\t".  'ERROR     : ファイルの種類が不正です. <br /> '.  "\r\n";
		break;
	}

	// Warning

	$message .= "\t\t".  '<br /> '.  "\r\n";


	// ファイル・アップロード関係の処理はここです. 
	$form[ 'upload'        ] =  ' ';
	$form[ 'upload_name'   ] =  $form[ '_FILES' ][ 'file' ][ 'name'     ];
	$form[ 'upload_type'   ] =  $form[ '_FILES' ][ 'file' ][ 'type'     ];
	$form[ 'upload_size'   ] =  $form[ '_FILES' ][ 'file' ][ 'size'     ];
	$form[ 'upload_tmp'    ] =  $form[ '_FILES' ][ 'file' ][ 'tmp_name' ];
	$form[ 'upload_alt'    ] =  '';
	$form[ 'upload_source' ] =  '';
	$form[ 'upload_width'  ] =  sprintf( '%d', $image[ 0 ] );
	$form[ 'upload_height' ] =  sprintf( '%d', $image[ 1 ] );
	$form[ 'upload_image'  ] =  'true';


	if( $error == 0 ) return true;     
	else              return false;    
}




// WHLX_PostingXML_NextID( $filename, $listtag, $ascending );
// // 
function  WHLX_PostingXML_NextID( $filename, $listtag, $ascending )
{
	// オリジナル domxml
	$root =  WHLX_DomXML_New_Document( $filename );    
	for( $i =  0;  $i <  $root->Child_Count(); $i ++ ){ $node =& $root->children[ $i ]; if( 'whlx'     == $node->Dump_Element() ) $whlx =& $node; }
if( $whlx == null ){ print "$filename, $listtag, $ascending whlx null"; exit; }
	for( $i =  0;  $i <  $whlx->Child_Count(); $i ++ ){ $node =& $whlx->children[ $i ]; if( $listtag   == $node->Dump_Element() ) $list =& $node; }
if( $list == null ){ print "$filename, $listtag, $ascending list null"; exit; }

	if( $ascending ) $item =  $list->Child_Last ();
	else             $item =  $list->Child_First();

	return  sprintf( '%04d', ( $item->attributes[ 'id' ] + 1 ) );
}




// WHLX_PostingXML_Create_NewArticle( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_Create_NewArticle( $filename, $listtag, $ascending, $form )
{
	// ノードを文字列として生成・取得
	$ping =  WHLX_PostingXML_Create_PingNode( $form );
	$file =  WHLX_PostingXML_Create_FileNode( $form );

	// オリジナル domxml
	$root =  WHLX_DomXML_New_Root    ();                                                 
	$xml  =  WHLX_DomXML_New_XML     (                              '1.0', 'UTF-8'    );    $root->Register( $xml  );
	$xslt =  WHLX_DomXML_New_XSLT    ( $form[ 'xslt' ], 'text/xsl', '1.0', 'UTF-8'    );    $root->Register( $xslt );
	$whlx =  WHLX_DomXML_New_Node    ( 'whlx'         , null, ''                      );    $root->Register( $whlx );
	$list =  WHLX_DomXML_New_Node    ( $listtag       , null, ''                      );    $whlx->Register( $list );
	$item =  WHLX_DomXML_New_Node    ( 'item'         , null, ''                      );    $list->Register( $item );
	$it   =  WHLX_DomXML_New_Node    ( 'title    '    , null, $form[ 'title'        ] );    $item->Register( $it   );
	$iu   =  WHLX_DomXML_New_Node    ( 'url      '    , null, $form[ 'url'          ] );    $item->Register( $iu   );
	$ix   =  WHLX_DomXML_New_Node    ( 'text     '    , null, $form[ 'text'         ] );    $item->Register( $ix   );
	$ic   =  WHLX_DomXML_New_Node    ( 'creator  '    , null, $form[ 'creator'      ] );    $item->Register( $ic   );
	$id   =  WHLX_DomXML_New_Node    ( 'date     '    , null, $form[ 'date'         ] );    $item->Register( $id   );
	$ir   =  WHLX_DomXML_New_Node    ( 'resource '    , null, $form[ 'new_resource' ] );    $item->Register( $ir   );
	$ib   =  WHLX_DomXML_New_Node    ( 'trackback'    , null, $form[ 'trackback'    ] );    $item->Register( $ib   );
	$ip   =  WHLX_DomXML_New_Node    ( ''             , null, $ping                   );    $item->Register( $ip   );
	$if   =  WHLX_DomXML_New_Node    ( ''             , null, $file                   );    $item->Register( $if   );
	$whlx->Attribute( 'series'  , $form[ 'series'      ] );
	$whlx->Attribute( 'category', $form[ 'category'    ] );
	$whlx->Attribute( 'title'   , $form[ 'title_short' ] );
	$item->Attribute( 'id'      , $form[ 'new_id'      ] );

	$output =  $root->Dump();
	return  $output;
}




// WHLX_PostingXML_InsertItem_Into_Article( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_InsertItem_Into_Article( $filename, $listtag, $ascending, $form )
{
	// オリジナル domxml
	$root =  WHLX_DomXML_New_Document( $filename );    
	for( $i =  0;  $i <  $root->Child_Count(); $i ++ ){ $node =& $root->children[ $i ]; if( 'whlx'     == $node->Dump_Element() ) $whlx =& $node; }
	for( $i =  0;  $i <  $whlx->Child_Count(); $i ++ ){ $node =& $whlx->children[ $i ]; if( $listtag   == $node->Dump_Element() ) $list =& $node; }

	$item =  WHLX_DomXML_New_Node    ( 'item'    , null, null                    );    
	$it   =  WHLX_DomXML_New_Node    ( 'title   ', null, $form[ 'title'        ] );    $item->Register( $it   );    
	$iu   =  WHLX_DomXML_New_Node    ( 'url     ', null, $form[ 'url'          ] );    $item->Register( $iu   );    
	$ie   =  WHLX_DomXML_New_Node    ( 'excerpt ', null, $form[ 'excerpt'      ] );    $item->Register( $ie   );    
	$in   =  WHLX_DomXML_New_Node    ( 'name    ', null, $form[ 'blog_name'    ] );    $item->Register( $in   );    
	$id   =  WHLX_DomXML_New_Node    ( 'date    ', null, $form[ 'date'         ] );    $item->Register( $id   );    
	$ir   =  WHLX_DomXML_New_Node    ( 'resource', null, $form[ 'new_resource' ] );    $item->Register( $ir   );    
	$item->Attribute( 'id', $form[ 'new_id' ] );

	if( $ascending ) $list->Register(    $item );    
	else             $list->Insert  ( 0, $item );    

	$output =  $root->Dump();
	return $output;
}




// WHLX_PostingXML_InsertItem_Into_List   ( $filename, $listtag, $ascending, $form );
// // 
function  WHLX_PostingXML_InsertItem_Into_List   ( $filename, $listtag, $ascending, $form )
{
	// オリジナル domxml
	$root =  WHLX_DomXML_New_Document( $filename );    
	for( $i =  0;  $i <  $root->Child_Count(); $i ++ ){ $node =& $root->children[ $i ]; if( 'whlx'     == $node->Dump_Element() ) $whlx =& $node; }
	for( $i =  0;  $i <  $whlx->Child_Count(); $i ++ ){ $node =& $whlx->children[ $i ]; if( $listtag   == $node->Dump_Element() ) $list =& $node; }

	$item =  WHLX_DomXML_New_Node    ( 'item', null, null );
	$item->Attribute( 'id'      , $form[ 'lst_id'       ] );
	$item->Attribute( 'resource', $form[ 'lst_resource' ] );
	$item->Attribute( 'title'   , $form[ 'title_short'  ] );

	if( $ascending ) $list->Register(    $item );    
	else             $list->Insert  ( 0, $item );    

	$output =  $root->Dump();
	return $output;
}




// WHLX_PostingXML_Create_PingNode( $form );
// // XHTML の form タグの子ノードを生成するために使われる XML データを生成します. 
// // このノードはPing送信先を格納しています. 
function  WHLX_PostingXML_Create_PingNode( $form )
{
	$output =  "\r\n";
	$array  =  preg_split( "/[\s]+/", $form[ 'ping' ], -1, PREG_SPLIT_NO_EMPTY );

	reset( $array );
	foreach( $array as $value )
	{
		$ping[ 'url'         ] =  $form[ 'url'     ];
		$ping[ 'title'       ] =  $form[ 'title'   ];
		$ping[ 'blog_name'   ] =  $form[ 'creator' ];
		$ping[ 'excerpt'     ] =  $form[ 'text'    ];
		$ping[ 'destination' ] =  $value;
		$result                =  WHLX_PostingXML_PingSend( $error, $message, $others, $ping );
		if( $result ) $output .= '<ping url="'.  $value.  '" status="'.  'succeeded'.  '" /> '.  "\r\n";
		else          $output .= '<ping url="'.  $value.  '" status="'.  'failed'   .  '" /> '.  "\r\n";
	}

	return $output;
}




// WHLX_PostingXML_Create_FileNode( $form );
// // XHTML の form タグの子ノードを生成するために使われる XML データを生成します. 
// // このノードはアップロードされたファイルを格納しています. 
function  WHLX_PostingXML_Create_FileNode( $form )
{
	$output =  '';
	$output .= "\t\t\t".  '<file> ' .  "\r\n";
	if( ( is_string( $form[ 'upload_name'   ] ) ) && ( $form[ 'upload_name'   ] != '' ) ) $output .= "\t\t\t\t".  '<name  >'.  $form[ 'upload_name'   ].  '</name  >'.  "\r\n";    
	if( ( is_string( $form[ 'upload_type'   ] ) ) && ( $form[ 'upload_type'   ] != '' ) ) $output .= "\t\t\t\t".  '<type  >'.  $form[ 'upload_type'   ].  '</type  >'.  "\r\n";    
//	if( ( is_string( $form[ 'upload_size'   ] ) ) && ( $form[ 'upload_size'   ] != '' ) ) $output .= "\t\t\t\t".  '<size  >'.  $form[ 'upload_size'   ].  '</size  >'.  "\r\n";    
	if( ( is_string( $form[ 'upload_tmp'    ] ) ) && ( $form[ 'upload_tmp'    ] != '' ) ) $output .= "\t\t\t\t".  '<tmp   >'.  $form[ 'upload_tmp'    ].  '</tmp   >'.  "\r\n";    
	if( ( is_string( $form[ 'upload_alt'    ] ) ) && ( $form[ 'upload_alt'    ] != '' ) ) $output .= "\t\t\t\t".  '<alt   >'.  $form[ 'upload_source' ].  '</alt   >'.  "\r\n";    
	if( ( is_string( $form[ 'upload_source' ] ) ) && ( $form[ 'upload_source' ] != '' ) ) $output .= "\t\t\t\t".  '<source>'.  $form[ 'upload_source' ].  '</source>'.  "\r\n";    
//	if( ( is_string( $form[ 'upload_width'  ] ) ) && ( $form[ 'upload_width'  ] != '' ) ) $output .= "\t\t\t\t".  '<width >'.  $form[ 'upload_width'  ].  '</width >'.  "\r\n";    
//	if( ( is_string( $form[ 'upload_height' ] ) ) && ( $form[ 'upload_height' ] != '' ) ) $output .= "\t\t\t\t".  '<height>'.  $form[ 'upload_height' ].  '</height>'.  "\r\n";    
	if( ( is_string( $form[ 'upload_mime'   ] ) ) && ( $form[ 'upload_mime'   ] != '' ) ) $output .= "\t\t\t\t".  '<mime  >'.  $form[ 'upload_mime'   ].  '</mime  >'.  "\r\n";    
	if( ( is_string( $form[ 'upload_image'  ] ) ) && ( $form[ 'upload_image'  ] != '' ) ) $output .= "\t\t\t\t".  '<image >'.  $form[ 'upload_image'  ].  '</image >'.  "\r\n";    
	$output .= "\t\t\t\t".  '<size  >'.  $form[ 'upload_size'   ].  '</size  >'.  "\r\n";    
	$output .= "\t\t\t\t".  '<width >'.  $form[ 'upload_width'  ].  '</width >'.  "\r\n";    
	$output .= "\t\t\t\t".  '<height>'.  $form[ 'upload_height' ].  '</height>'.  "\r\n";    
	$output .= "\t\t\t".  '</file> '.  "\r\n";
	return  $output;
}




// WHLX_PostingXML_PingSend( $error, $message, $others, $form );
// // 
function  WHLX_PostingXML_PingSend( &$error, &$message, &$others, $form )
{
	// 
	$URL =  parse_url( rawurldecode( $form[ 'destination' ] ) );
	if( !isset ( $URL[ 'port' ] ) ) $URL[ 'port' ] =  80;
	if( !is_int( $URL[ 'port' ] ) ) $URL[ 'port' ] =  80;
	if( $URL[ 'port' ] == 0       ) $URL[ 'port' ] =  80;
	if( $URL[ 'port' ] == null    ) $URL[ 'port' ] =  80;

	// 
	$host    =  gethostbyname( $URL[ 'host' ] );

	// 送信内容
	$content =  
		'url='.          $form[ 'url'       ].    '&'.    
		'title='.        $form[ 'title'     ].    '&'.    
		'blog_name='.    $form[ 'blog_name' ].    '&'.    
		'excerpt='.      $form[ 'excerpt'   ];

	if( $URL[ 'query' ] != '' ) $path =  '/'.  $URL[ 'path' ].  '?'.  $URL[ 'query' ]; // .  '&'.  $content;
	else                        $path =  '/'.  $URL[ 'path' ]; // .  '?'.                          $content;

	// HTTP Request Header 
	$request =  
//		'GET  '.  $path.  ' HTTP/1.0'.                     " \r\n".    
		'POST '.  $path.  ' HTTP/1.0'.                     " \r\n".    
		'Host:           '.  $URL[ 'host' ].               " \r\n".    
		'User-Agent:     '.  WHLX_USER_AGENT.              " \r\n".    
		'Content-Type:   '.  'text/plain; charset=UTF-8'.  " \r\n".    
		'Content-Length: '.  strlen( $content ).           " \r\n".    
		"\r\n".    
		$content;

	$socket_error_number  =  0;     
	$socket_error_message =  '';    
	$socket_timeout       =  300;    

	// ソケット作成
	$file =  fsockopen( $URL[ 'host' ], $URL[ 'port' ], $socket_error_number, $socket_error_message, $socket_timeout );

	$error   =  $socket_error_number;
	$message =  $socket_error_message;
	$others  =  '';

	if( !$file ) return false;
	else
	{
		// 送信 ( HTTP Request  Header )
		fputs( $file, $request );
	
		// 受信 ( HTTP Response Header )
		$response = '';
		while( !feof( $file ) ) $response .= fgets( $file, 4096 );
	
		// ソケット削除
		fclose( $file );

		$others  =  $response;
		return true;
	}
}




// WHLX_PostingXML_FormAttributes( $attribute );
// // XHTML の form タグのアトリビュートを生成するために使われる XML データを生成します. 
function  WHLX_PostingXML_FormAttributes( $attribute )
{
	$output =  '';
	$output .= "\t\t\t".  '<attribute> ' .  "\r\n";
	if( is_string( $attribute[ 'action'  ] ) ) $output .= "\t\t\t\t".  '<action >'.  $attribute[ 'action'  ].  '</action > '.  "\r\n";    
	if( is_string( $attribute[ 'method'  ] ) ) $output .= "\t\t\t\t".  '<method >'.  $attribute[ 'method'  ].  '</method > '.  "\r\n";    
	if( is_string( $attribute[ 'accept'  ] ) ) $output .= "\t\t\t\t".  '<accept >'.  $attribute[ 'accept'  ].  '</accept > '.  "\r\n";    
	if( is_string( $attribute[ 'charset' ] ) ) $output .= "\t\t\t\t".  '<charset>'.  $attribute[ 'charset' ].  '</charset> '.  "\r\n";    
	if( is_string( $attribute[ 'enctype' ] ) ) $output .= "\t\t\t\t".  '<enctype>'.  $attribute[ 'enctype' ].  '</enctype> '.  "\r\n";    
	if( is_string( $attribute[ 'lang'    ] ) ) $output .= "\t\t\t\t".  '<lang   >'.  $attribute[ 'lang'    ].  '</lang   > '.  "\r\n";    
	$output .= "\t\t\t".  '</attribute> '.  "\r\n";
	return  $output;
}




// WHLX_PostingXML_FormDataEntered( $form );
// // XHTML の form タグの子ノードを生成するために使われる XML データを生成します. 
function  WHLX_PostingXML_FormDataEntered( $form )
{
	$output =  '';
	if( is_string( $form[ 'title'     ] ) ) $output .= "\t\t\t".  '<title    >'.  $form[ 'title'     ].  '</title    > '.  "\r\n";    
	if( is_string( $form[ 'url'       ] ) ) $output .= "\t\t\t".  '<url      >'.  $form[ 'url'       ].  '</url      > '.  "\r\n";    
	if( is_string( $form[ 'text'      ] ) ) $output .= "\t\t\t".  '<text     >'.  $form[ 'text'      ].  '</text     > '.  "\r\n";    
	if( is_string( $form[ 'style_br'  ] ) ) $output .= "\t\t\t".  '<style_br >'.  $form[ 'style_br'  ].  '</style_br > '.  "\r\n";    
	if( is_string( $form[ 'style_tg'  ] ) ) $output .= "\t\t\t".  '<style_tg >'.  $form[ 'style_tg'  ].  '</style_tg > '.  "\r\n";    
	if( is_string( $form[ 'excerpt'   ] ) ) $output .= "\t\t\t".  '<excerpt  >'.  $form[ 'excerpt'   ].  '</excerpt  > '.  "\r\n";    
	if( is_string( $form[ 'ping'      ] ) ) $output .= "\t\t\t".  '<ping     >'.  $form[ 'ping'      ].  '</ping     > '.  "\r\n";    
	if( is_string( $form[ 'creator'   ] ) ) $output .= "\t\t\t".  '<creator  >'.  $form[ 'creator'   ].  '</creator  > '.  "\r\n";    
	if( is_string( $form[ 'blog_name' ] ) ) $output .= "\t\t\t".  '<blog_name>'.  $form[ 'blog_name' ].  '</blog_name> '.  "\r\n";    
//	if( is_string( $form[ 'date'      ] ) ) $output .= "\t\t\t".  '<date     >'.  $form[ 'date'      ].  '</date     > '.  "\r\n";    
	if( is_string( $form[ 'trackback' ] ) ) $output .= "\t\t\t".  '<trackback>'.  $form[ 'trackback' ].  '</trackback> '.  "\r\n";    
	if( is_string( $form[ 'category'  ] ) ) $output .= "\t\t\t".  '<category >'.  $form[ 'category'  ].  '</category > '.  "\r\n";    
	if( is_string( $form[ 'profile'   ] ) ) $output .= "\t\t\t".  '<profile  >'.  $form[ 'profile'   ].  '</profile  > '.  "\r\n";    
	if( is_string( $form[ 'upload'    ] ) ) $output .= WHLX_PostingXML_Create_FileNode( $form );
	return  $output;
}




// WHLX_PostingXML_ResultPreview( $form );
// // 
function  WHLX_PostingXML_ResultPreview( $form )
{
	$output =  '';
	$output .= "\t\t".  '<result> <item> '  .  "\r\n";
	if( is_string( $form[ 'title'     ] ) ) $output .= "\t\t\t".  '<title    >'.  $form[ 'title'     ].  '</title    > '.  "\r\n";    
	if( is_string( $form[ 'url'       ] ) ) $output .= "\t\t\t".  '<url      >'.  $form[ 'url'       ].  '</url      > '.  "\r\n";    
	if( is_string( $form[ 'text'      ] ) ) $output .= "\t\t\t".  '<text     >'.  $form[ 'text'      ].  '</text     > '.  "\r\n";    
	if( is_string( $form[ 'style_br'  ] ) ) $output .= "\t\t\t".  '<style_br >'.  $form[ 'style_br'  ].  '</style_br > '.  "\r\n";    
	if( is_string( $form[ 'style_tg'  ] ) ) $output .= "\t\t\t".  '<style_tg >'.  $form[ 'style_tg'  ].  '</style_tg > '.  "\r\n";    
	if( is_string( $form[ 'excerpt'   ] ) ) $output .= "\t\t\t".  '<excerpt  >'.  $form[ 'excerpt'   ].  '</excerpt  > '.  "\r\n";    
	if( is_string( $form[ 'ping'      ] ) ) $output .= "\t\t\t".  '<ping     >'.  $form[ 'ping'      ].  '</ping     > '.  "\r\n";    
	if( is_string( $form[ 'creator'   ] ) ) $output .= "\t\t\t".  '<creator  >'.  $form[ 'creator'   ].  '</creator  > '.  "\r\n";    
	if( is_string( $form[ 'blog_name' ] ) ) $output .= "\t\t\t".  '<blog_name>'.  $form[ 'blog_name' ].  '</blog_name> '.  "\r\n";    
	if( is_string( $form[ 'date'      ] ) ) $output .= "\t\t\t".  '<date     >'.  $form[ 'date'      ].  '</date     > '.  "\r\n";    
	if( is_string( $form[ 'trackback' ] ) ) $output .= "\t\t\t".  '<trackback>'.  $form[ 'trackback' ].  '</trackback> '.  "\r\n";    
	if( is_string( $form[ 'category'  ] ) ) $output .= "\t\t\t".  '<category >'.  $form[ 'category'  ].  '</category > '.  "\r\n";    
	if( is_string( $form[ 'profile'   ] ) ) $output .= "\t\t\t".  '<profile  >'.  $form[ 'profile'   ].  '</profile  > '.  "\r\n";    
	if( is_string( $form[ 'upload'    ] ) ) $output .= WHLX_PostingXML_Create_FileNode( $form );
	$output .= "\t\t".  '</item> </result> '.  "\r\n";
	return  $output;
}




?>
