<?php
// 
// WHLX CMS - domxml_document.php
// 
// 20040505 - 0.00 alpha    
// 20040507 - 0.01 alpha    WHLX_DomXML_Document::Parse やや完成. 
// 20040509 - 0.02 alpha    ファイル読み込みを readfile から file, implode に変更. 
// 20040509 - 0.03 alpha    mb_string系関数をstring系関数に変更. 
// 20040510 - 0.04 alpha    WHLX_DomXML_Node を継承元として, WHLX_DomXML_Document を再構成. 
// 20040511 - 0.05 alpha    タグ要素名             のパース・ルーチンを実装. 
// 20040511 - 0.06 alpha    タグ属性名・属性データ のパース・ルーチンを実装. 
// 




class  WHLX_DomXML_Document extends WHLX_DomXML_Node
{
	var $file;
	var $data;

	function  WHLX_DomXML_Document( $file )
	{
		if( is_file( $file ) )
		{
			$this->file =  $file;
			$this->data =  implode( '', file( $this->file ) );
			$this->Parse();
		}
	}

	function  Parse()
	{
		$lines  =  array();
		$buffer =  $this->data;

		reset( $lines );
		while( true )
		{
			if( $buffer == '' ) break;

			$this->Parse_Open ( $buffer, $p, $n );
			if( $p != '' ) $lines[] =  $p;
			$buffer =  $n;

			$this->Parse_Close( $buffer, $p, $n );
			if( $p != '' ) $lines[] =  $p;
			$buffer =  $n;
		}

		$rank       =  0;
		$tags[ 0 ]  =& $this;

		reset( $lines );
		foreach( $lines as $line )
		{
			$this->Tag( $line, $ele, $att, $flg );

//	print sprintf( "[Flag:%1d] [Rank:%1d] [Element:%20s] [%s]\r\n", $flg, $rank, $ele, $line );

			switch( $flg )
			{
				// 非タグ
				case 1:
				if( $ele == '' ) break;
				$node =& WHLX_DomXML_New_Text   ( $ele );
				$tags[ $rank ]->Register( $node );
				break;


				case 2:
				// 開始タグ
				$node =& WHLX_DomXML_New_Node   ( $ele, $att, ''   );
				$tags[ $rank ]->Register( $node );

				$rank ++;
				$tags[ $rank ] =& $node;
				break;


				// 終了タグ
				case 3:
				$rank --;
				break;


				// 単独タグ
				case 4:
				$node =& WHLX_DomXML_New_Node   ( $ele, $att, ''   );
				$tags[ $rank ]->Register( $node );
				break;


				// PIタグ
				case 5:
				$node =& WHLX_DomXML_New_PI     ( $ele, $att );
				$tags[ $rank ]->Register( $node );
				break;


				// コメント
				case 6:
				$node =& WHLX_DomXML_New_Comment( $ele );
				$tags[ $rank ]->Register( $node );
				break;


				default:
				break;
			}
		}


		return true;
	}




	function  Tag( $text, &$element, &$attributes, &$flg )
	{
		// 初期化
		$element    =  '';
		$attributes =  array();
		$flg        =  0;

		// タグの種類を決定し, タグの中身を抽出します. 
		// 
		// タグ or 非タグ の調査
		$head =  substr( trim( $text ), +0, +1 );    // 先頭の１文字を取得します. 
		$foot =  substr( trim( $text ), -1, +1 );    // 後尾の１文字を取得します. 
		if( ( $head != '<'  ) && ( $foot != '>'  ) )        { $flg =  1; }    // 非タグ
		// 
		// タグの種類 の調査
		else
		{
			$head =  substr( trim( $text ), +0, +2 );    // 先頭の２文字を取得します. 
			$foot =  substr( trim( $text ), -2, +2 );    // 後尾の２文字を取得します. 
			if( ( $head == '</' ) && ( $foot == '/>' ) ){ $flg =  0; }    // エラー
			if( ( $head != '</' ) && ( $foot != '/>' ) ){ $flg =  2; }    // 開始タグ
			if( ( $head == '</' ) && ( $foot != '/>' ) ){ $flg =  3; }    // 終了タグ
			if( ( $head != '</' ) && ( $foot == '/>' ) ){ $flg =  4; }    // 単独タグ
			if( ( $head == '<?' ) && ( $foot == '?>' ) ){ $flg =  5; }    // PIタグ
			if( ( $head == '<!' ) && ( $foot == '->' ) ){ $flg =  6; }    // コメント
		}
		// 

		// 特殊な関数終了
		if( $flg == 0 ){ $element =  '';                               return false; }    // エラー
		if( $flg == 1 ){ $element =  trim( $text );                    return true;  }    // テキスト
		if( $flg == 2 ){ $buffer  =  substr( trim( $text ), +1, -1 );                }    // 開始タグ
		if( $flg == 3 ){ $buffer  =  substr( trim( $text ), +2, -1 );                }    // 終了タグ
		if( $flg == 4 ){ $buffer  =  substr( trim( $text ), +1, -2 );                }    // 単独タグ
		if( $flg == 5 ){ $buffer  =  substr( trim( $text ), +2, -2 );                }    // PI
		if( $flg == 6 ){ $element =  substr( trim( $text ), +4, -3 );  return true;  }    // コメント


		$pattern_ele =  '([\+\-\:[:alnum:]]+)';
		$pattern_equ =  '(\s*\=\s*)';
		$pattern_0   =  $pattern_ele.  $pattern_equ.  '(\"[^\"]*\")';    // 属性名 + "(double-quotes)で囲まれた文字列
		$pattern_1   =  $pattern_ele.  $pattern_equ.  '([^\"]+)';        // 属性名 + 文字列
		$pattern_2   =  $pattern_ele.  '';                               // 属性名

		// タグ名が切り分け, 要素名と属性を抽出します. 
		preg_match_all( "/$pattern_0|$pattern_1|$pattern_2/", $buffer, $array_eleatt );

		// 最初の１つ目が要素名になります. 
		$element    =  array_shift( $array_eleatt[0] );

		// 2つ目以降の残りの部分から属性名と属性データを抽出します. 
		$attributes =  array();
		foreach( $array_eleatt[0] as $attval )
		{
			$position     =  strpos( $attval, '=', 0 );
			$length       =  strlen( $attval );

			// データ有り属性
			if( $position !== false )
			{
				$name     =  trim( substr( $attval, 0                        , + $position                           ) );
				$buffer   =  trim( substr( $attval, $position + strlen( '=' ), - $position - strlen( '=' ) + $length ) );
				preg_match_all( '/([^\"]+)/', $buffer, $array_value );
				$value    =  $array_value[0][0];
			}

			// データ無し属性
			else
			{
				$name     =  trim( $attval );
				$value    =  '';
			}

			$attributes[ $name ] =  $value;
		}
/*
		ereg( "(\#)(=)(\#)", $attributes, $array );
/(<a href="\#)([^"]+?)(">▲<\/a>　<a href="\#)([^"]+?)(">▼<\/a>)/$1$4$3$2$5/gi

		for( $i =  0; $i <  $length; $i ++ )
		{
			$c =  substr( $attributes, $i, +1 );
			if( ereg( "[a-zA-Z:]" ) continue;
			if( ereg( "[\s,]+", $c ) ) continue;
		}

		$position =  strpos( $tag, ' ', 0 );
		$textp    =  substr( $buffer, 0,         + $position           ) );
		$textn    =  substr( $buffer, $position, - $position + $length ) );
		$tags =  preg_split( "/[\s,]+/", $buffer, -1, PREG_SPLIT_NO_EMPTY );
		// 配列の１つ目は XMLタグ名 になります. 
		$tag  =  array_shift( $tags );

		// 配列の２つ目以降は XML属性(アトリビュート) が入っています. 
		$name   =  '';
		$data   =  '';
		$buffer =  '';
		foreach( $tags as $tag )
		{
			// '=' の前後で切り分けます。
			$position =  strpos( $tag, '=', 0 );
			$length   =  strlen( $tag         );
			$textp    =  substr( $buffer, 0,         + $position           ) );
			$textn    =  substr( $buffer, $position, - $position + $length ) );
			if( substr( $textn, +0, +1 ) == '' )
			foreach( $array as $equation )
			{
				// '=' の前後で２分割します
				list( $name, $data ) =  preg_split( '/\=/', $equation, 2, PREG_SPLIT_NO_EMPTY );

				// 前半部分は属性名です. 
				// 前後の空白を取り除きます. 
				$name =  trim( $name );

				// 後半部分はデータです. 
				// 前後の空白を取り除きます. 
				$data =  trim( $data );
				// '"' の前後で１分割します
				$quot =  preg_split( '/"/', $data, -1, PREG_SPLIT_NO_EMPTY );

				// 属性名とデータが１つに纏められた連想配列として, 格納します
				$att[ $name ] =  $quot[ 0 ];
			}
		}
*/
	}




	function  Parse_Open ( $buffer, &$textp, &$textn )
	{
		// 初期化
		$textp =  '';
		$textn =  $buffer;

		if( !is_string( $buffer ) ) return false;
		if( '' == $buffer )         return false;

		$position =  strpos( $buffer, '<', 0 );
		$length   =  strlen( $buffer         );

		if( $position === false )
		{
			$textp =  '';
			$textn =  trim( $buffer );
			return false;
		}
		else
		{
			$textp =  trim( substr( $buffer, 0,         + $position           ) );
			$textn =  trim( substr( $buffer, $position, - $position + $length ) );
			return true;
		}
	}




	function  Parse_Close( $buffer, &$textp, &$textn )
	{
		// 初期化
		$textp =  '';
		$textn =  $buffer;

		if( !is_string( $buffer ) ) return false;
		if( '' == $buffer )         return false;

		$position =  strpos( $buffer, '>', 0 );
		$length   =  strlen( $buffer         );

		if( $position === false )
		{
			$textp =  '';
			$textn =  trim( $buffer );
			return false;
		}
		else
		{
			$position += mb_strwidth( '>' );
			$textp =  trim( substr( $buffer, 0,         + $position           ) );
			$textn =  trim( substr( $buffer, $position, - $position + $length ) );
			return true;
		}
	}

}




?>
