<?xml            version="1.0" encoding="UTF-8" ?> 

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> 


	<xsl:output method="xml" indent="yes" encoding="UTF-8" media-type="application/xhtml+xml" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" /> 




	<xsl:variable name="title_main" select="document( './informations.xml' )/whlx/informations/item[ @title = 'title' ]/@value" /> 
	<xsl:variable name="title_sub"  select="/whlx/@title"                                                                       /> 




	<!-- レイアウト --> 

	<xsl:template match="/"> 
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" dir="ltr"> 
			<head> 
				<title> <xsl:value-of select="$title_main" /> - <xsl:value-of select="$title_sub" /> </title> 
				<meta http-equiv="Content-Type"        content="application/xhtml+xml; charset=UTF-8" /> 
				<meta http-equiv="Content-Language"    content="ja"                                   /> 
				<meta http-equiv="Content-Script-Type" content="text/javascript;       charset=UTF-8" /> 
				<meta http-equiv="Content-Style-Type"  content="text/css;              charset=UTF-8" /> 
				<link rel="stylesheet" type="text/css"              href="./_default.css"     /> 
				<link rel="index"      type="application/xhtml+xml" href="./index.xml"        /> 
				<link rel="contents"   type="application/xhtml+xml" href="./contents.xml"     /> 
				<link rel="copyright"  type="application/xhtml+xml" href="./informations.xml" /> 
			</head> 
			<body class="whlx_base"> 
				<div class="whlx_head"> 
<!-- head --> 
<h1> <xsl:value-of select="$title_main" /> - <xsl:value-of select="$title_sub" /> </h1> 
<!-- head --> 
				</div> 
				<div class="whlx_body"> 
					<div class="whlx_main"> 
<!-- main --> 
<xsl:apply-templates select="/whlx/index       " /> 
<xsl:apply-templates select="/whlx/recents     " /> 
<xsl:apply-templates select="/whlx/excerpts    " /> 
<xsl:apply-templates select="/whlx/informations" /> 
<xsl:apply-templates select="/whlx/contents    " /> 
<xsl:apply-templates select="/whlx/categories  " /> 
<xsl:apply-templates select="/whlx/category    " /> 
<xsl:apply-templates select="/whlx/articles    " /> 
<xsl:apply-templates select="/whlx/comments    " /> 
<xsl:apply-templates select="/whlx/trackbacks  " /> 
<xsl:apply-templates select="/whlx/items       " /> 
<!-- main --> 
					</div> 
					<div class="whlx_menu"> 
<!-- menu --> 
<ul class="contents_list    "> <h4> <a href="./contents.xml    "> Contents     </a> </h4> <xsl:apply-templates select="document( './contents.xml'     )/whlx/contents    /item"> <xsl:with-param name="limit" select="0"  /> </xsl:apply-templates> </ul> 
<ul class="categories_list  "> <h4> <a href="./categories.xml  "> Categories   </a> </h4> <xsl:apply-templates select="document( './categories.xml'   )/whlx/categories  /item"> <xsl:with-param name="limit" select="10" /> </xsl:apply-templates> </ul> 
<ul class="articles_list    "> <h4> <a href="./articles.xml    "> Articles     </a> </h4> <xsl:apply-templates select="document( './articles.xml'     )/whlx/articles    /item"> <xsl:with-param name="limit" select="10" /> </xsl:apply-templates> </ul> 
<ul class="comments_list    "> <h4> <a href="./comments.xml    "> Comments     </a> </h4> <xsl:apply-templates select="document( './comments.xml'     )/whlx/comments    /item"> <xsl:with-param name="limit" select="10" /> </xsl:apply-templates> </ul> 
<ul class="trackbacks_list  "> <h4> <a href="./trackbacks.xml  "> Trackbacks   </a> </h4> <xsl:apply-templates select="document( './trackbacks.xml'   )/whlx/trackbacks  /item"> <xsl:with-param name="limit" select="10" /> </xsl:apply-templates> </ul> 
<!-- menu --> 
					</div> 
				</div> 
				<div class="whlx_foot"> 
<!-- foot --> 
<dl class="informations_list"> <h4> <a href="./informations.xml"> Informations </a> </h4> <xsl:apply-templates select="document( './informations.xml' )/whlx/informations/item"> <xsl:with-param name="limit" select="0"  /> </xsl:apply-templates> </dl> 
<!-- foot --> 
				</div> 
			</body> 
		</html> 
	</xsl:template> 




	<xsl:template match="/whlx/index       "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_fwrd"> Index                                            </a> 
		</div> 
		<div class="note_body"> 
			<xsl:for-each select="document( './articles.xml    ' )/whlx/articles    /item"  > 
				<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
					<xsl:variable name="nm" select="substring-after ( @resource, '#' )"                                       /> 
					<xsl:variable name="rs" select="substring-before( @resource, '#' )"                                       /> 
					<xsl:variable name="tm" select="document( $rs )/whlx/items/item[ @id = $nm ]/title    " /> 
					<xsl:variable name="tx" select="document( $rs )/whlx/items/item[ @id = $nm ]/text     " /> 
					<xsl:variable name="cr" select="document( $rs )/whlx/items/item[ @id = $nm ]/creator  " /> 
					<xsl:variable name="dt" select="document( $rs )/whlx/items/item[ @id = $nm ]/date     " /> 
					<xsl:variable name="tb" select="document( $rs )/whlx/items/item[ @id = $nm ]/trackback" /> 
					<xsl:variable name="fs" select="document( $rs )/whlx/items/item[ @id = $nm ]/file/source" /> 
					<xsl:variable name="fa" select="document( $rs )/whlx/items/item[ @id = $nm ]/file/alt   " /> 
					<div class="main_base"> 
						<h2  class="main_head"> <a href="{$rs}"> <xsl:value-of select="$tm" /> </a>                 </h2>  
						<xsl:if test="$fs != ''"> <div class="main_file"> <a href="{$fs}"> <xsl:value-of select="$fa" /> </a> </div> </xsl:if> 
						<div class="main_body">                  <xsl:copy-of  select="$tx" />                      </div> 
						<h3  class="main_foot">                  <xsl:value-of select="$cr" />                      </h3>  
						<h3  class="main_foot">                  <xsl:value-of select="$dt" />                      </h3>  
						<h3  class="main_ping"> <a href="{$tb}"> TRACKBACK URL </a> : <xsl:value-of select="$tb" /> </h3>  
					</div> 
				</xsl:if> 
			</xsl:for-each> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/recents     "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./recents.xml"      class="note_fwrd"> Recents                                          </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./articles.xml    "> Articles     </a> </h2> 
			<ul class="articles_list    "> <xsl:apply-templates select="document( './articles.xml    ' )/whlx/articles    /item" /> </ul> 
			<h2> <a href="./comments.xml    "> Comments     </a> </h2> 
			<ul class="comments_list    "> <xsl:apply-templates select="document( './comments.xml    ' )/whlx/comments    /item" /> </ul> 
			<h2> <a href="./trackbacks.xml  "> Trackbacks   </a> </h2> 
			<ul class="trackbacks_list  "> <xsl:apply-templates select="document( './trackbacks.xml  ' )/whlx/trackbacks  /item" /> </ul> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/excerpts    "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./excerpts.xml"     class="note_fwrd"> Excerpts                                         </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./articles.xml    "> Articles     </a> </h2> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/articles    /excerpts" /> 
			<h2> <a href="./comments.xml    "> Comments     </a> </h2> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/comments    /excerpts" /> 
			<h2> <a href="./trackbacks.xml  "> Trackbacks   </a> </h2> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/trackbacks  /excerpts" /> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/contents    "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./contents.xml"     class="note_fwrd"> Contents                                         </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./contents.xml    "> Contents     </a> </h2> 
			<ul class="contents_list    "> <xsl:apply-templates select="./item" /> </ul> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/informations"> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./informations.xml" class="note_fwrd"> Informations                                     </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./informations.xml"> Informations </a> </h2> 
			<ul class="informations_list"> <xsl:apply-templates select="./item" /> </ul> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/categories  ">
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./categories.xml"   class="note_fwrd"> Categories                                       </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./categories.xml  "> Categories   </a> </h2> 
			<ul class="categories_list  "> <xsl:apply-templates select="./item" /> </ul> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/category    "> 
		<xsl:param    name="limit"      select="10" /> 
		<xsl:variable name="prev_id"    select="substring( string( 19999 + number( /whlx/@series ) ), 2, 4 )"                       /> 
		<xsl:variable name="self_id"    select="substring( string( 20000 + number( /whlx/@series ) ), 2, 4 )"                       /> 
		<xsl:variable name="next_id"    select="substring( string( 20001 + number( /whlx/@series ) ), 2, 4 )"                       /> 
		<xsl:variable name="prev_title" select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $prev_id  ]/@title   " /> 
		<xsl:variable name="self_title" select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $self_id  ]/@title   " /> 
		<xsl:variable name="next_title" select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $next_id  ]/@title   " /> 
		<xsl:variable name="prev_url"   select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $prev_id  ]/@resource" /> 
		<xsl:variable name="self_url"   select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $self_id  ]/@resource" /> 
		<xsl:variable name="next_url"   select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $next_id  ]/@resource" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                        </a>  
			<a href="./categories.xml"   class="note_back"> Categories                                   </a>  
			<a href="./{$prev_url}"      class="note_back"> Prev : <xsl:value-of select="$prev_title" /> </a>  
			<a href="./{$self_url}"      class="note_fwrd"> Self : <xsl:value-of select="$self_title" /> </a>  
			<a href="./{$next_url}"      class="note_back"> Next : <xsl:value-of select="$next_title" /> </a>  
		</div> 
		<div class="note_body"> 
			<h2> <a href="{$self_url}"> Category <xsl:value-of select="/whlx/@category" /> : <xsl:value-of select="$self_title" /> </a> </h2> 
			<ul class="category_list    "> <xsl:apply-templates select="./item" /> </ul> 
			<xsl:for-each select="./item"  > 
				<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
					<xsl:variable name="nm" select="substring-after ( @resource, '#' )"                                       /> 
					<xsl:variable name="rs" select="substring-before( @resource, '#' )"                                       /> 
					<xsl:variable name="tm" select="document( $rs )/whlx/items/item[ @id = $nm ]/title"     /> 
					<xsl:variable name="tx" select="document( $rs )/whlx/items/item[ @id = $nm ]/text"      /> 
					<xsl:variable name="cr" select="document( $rs )/whlx/items/item[ @id = $nm ]/creator"   /> 
					<xsl:variable name="dt" select="document( $rs )/whlx/items/item[ @id = $nm ]/date"      /> 
					<xsl:variable name="tb" select="document( $rs )/whlx/items/item[ @id = $nm ]/trackback" /> 
					<div class="main_base"> 
						<h2  class="main_head"> <a href="{$rs}"> <xsl:value-of select="$tm" /> </a>                     </h2>  
						<div class="main_body">                  <xsl:copy-of  select="$tx/text() | $tx/* | $tx/@* " /> </div> 
						<h3  class="main_foot">                  <xsl:value-of select="$cr" />                          </h3>  
						<h3  class="main_foot">                  <xsl:value-of select="$dt" />                          </h3>  
						<h3  class="main_foot"> <a href="{$tb}"> TRACKBACK URL </a> : <xsl:value-of select="$tb" />     </h3>  
					</div> 
				</xsl:if> 
			</xsl:for-each> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/articles    "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./articles.xml"     class="note_fwrd"> Articles                                         </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./articles.xml    "> Articles     </a> </h2> 
			<ul class="articles_list    "> <xsl:apply-templates select="./item" /> </ul> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/articles    /excerpts" /> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/comments    "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./comments.xml"     class="note_fwrd"> Comments                                         </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./comments.xml    "> Comments     </a> </h2> 
			<ul class="comments_list    "> <xsl:apply-templates select="./item" /> </ul> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/comments    /excerpts" /> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/trackbacks  "> 
		<xsl:param name="limit" select="10" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./trackbacks.xml"   class="note_fwrd"> Trackbacks                                       </a> 
		</div> 
		<div class="note_body"> 
			<h2> <a href="./trackbacks.xml  "> Trackbacks   </a> </h2> 
			<ul class="trackbacks_list  "> <xsl:apply-templates select="./item" /> </ul> 
			<xsl:apply-templates select="document( './_default.xml' )/whlx/trackbacks  /excerpts" /> 
		</div> 
	</xsl:template> 




	<xsl:template match="/whlx/items       "> 
		<xsl:variable name="series"     select="substring( string( 20000 + number( /whlx/@series   ) ), 2, 4 )"                       /> 
		<xsl:variable name="category"   select="substring( string( 20000 + number( /whlx/@category ) ), 2, 4 )"                       /> 
		<xsl:variable name="cate_name"  select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $category ]/@title"    /> 
		<xsl:variable name="cate_list"  select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $category ]/@resource" /> 
		<xsl:variable name="prev_id"    select="substring( string( 19999 + number( $series ) ), 2, 4 )"                               /> 
		<xsl:variable name="self_id"    select="substring( string( 20000 + number( $series ) ), 2, 4 )"                               /> 
		<xsl:variable name="next_id"    select="substring( string( 20001 + number( $series ) ), 2, 4 )"                               /> 
		<xsl:variable name="prev_title" select="                  document( './articles.xml    ' )/whlx/articles    /item[ @id = $prev_id  ]/@title          " /> 
		<xsl:variable name="self_title" select="                  document( './articles.xml    ' )/whlx/articles    /item[ @id = $self_id  ]/@title          " /> 
		<xsl:variable name="next_title" select="                  document( './articles.xml    ' )/whlx/articles    /item[ @id = $next_id  ]/@title          " /> 
		<xsl:variable name="prev_url"   select="substring-before( document( './articles.xml    ' )/whlx/articles    /item[ @id = $prev_id  ]/@resource, '#' )" /> 
		<xsl:variable name="self_url"   select="substring-before( document( './articles.xml    ' )/whlx/articles    /item[ @id = $self_id  ]/@resource, '#' )" /> 
		<xsl:variable name="next_url"   select="substring-before( document( './articles.xml    ' )/whlx/articles    /item[ @id = $next_id  ]/@resource, '#' )" /> 
		<div class="note_head"> 
			<a href="./index.xml"        class="note_back"> Index                                            </a> 
			<a href="./articles.xml"     class="note_back"> Articles                                         </a> 
			<a href="./{$cate_list}"     class="note_back"> Category : <xsl:value-of select="$cate_name"  /> </a> 
			<a href="./{$prev_url}"      class="note_back"> Prev     : <xsl:value-of select="$prev_title" /> </a> 
			<a href="./{$self_url}"      class="note_fwrd"> Self     : <xsl:value-of select="$self_title" /> </a> 
			<a href="./{$next_url}"      class="note_back"> Next     : <xsl:value-of select="$next_title" /> </a> 
		</div> 
		<div class="note_body"> 
			<xsl:for-each select="./item"> 
				<xsl:if test=" position() =  1 "> 
					<div class="main_base"> 
						<h2  class="main_head"> <a href="{./resource}" name="{./@id}"> <xsl:value-of select="./title" /> </a>                                                                    </h2>  
						<xsl:apply-templates select="./file" /> 
						<div class="main_body"> <xsl:copy-of  select="./text     " />                                                                                  </div> 
						<h3  class="main_foot"> <xsl:value-of select="./creator  " /> </h3> 
						<h3  class="main_foot"> <xsl:value-of select="./date     " /> </h3> 
						<h3  class="main_ping"> <xsl:value-of select="./trackback" /> <a href="{./trackback}"> TRACKBACK URL  </a> </h3> 
						<xsl:comment> <xsl:for-each select="./ping     "> 
							<h3  class="main_ping"> <xsl:value-of select="./@url" /> <a href="{./@url}"> PING DESTINATIONS </a> </h3> 
						</xsl:for-each> </xsl:comment> 
					</div> 
				</xsl:if> 
				<xsl:if test=" position() != 1 "> 
					<div class="cmnt_base"> 
						<h2  class="cmnt_head"> <a href="{./resource}" name="{./@id}"> <xsl:value-of select="./title" /> </a> </h2>  
						<div class="cmnt_body"> <xsl:copy-of  select="./excerpt" /> </div> 
						<h3  class="cmnt_foot"> <xsl:value-of select="./name   " /> </h3> 
						<h3  class="cmnt_foot"> <xsl:value-of select="./date   " /> </h3> 
						<xsl:if test="./url != ''"> 
							<h3  class="cmnt_ping"> <xsl:value-of select="./url " /> <a href="{./url }"> TRACKBACK SOURCE </a> </h3> 
						</xsl:if> 
					</div> 
				</xsl:if> 
			</xsl:for-each> 
			<form class="post_base" action="{/whlx/items/item[@id='0001']/trackback}&amp;comment=true" method="post"> 
				<label class="post_label"> Title  <input    class="post_input" type="text"          name="title"     value=""         /> </label> <br /> 
				<label class="post_label"> Text   <textarea class="post_input" rows="5"  wrap="off" name="excerpt"         ></textarea>  </label> <br /> 
				<label class="post_label"> Name   <input    class="post_input" type="text"          name="blog_name" value=""         /> </label> <br /> 
				<label class="post_label"> Submit <input    class="post_input" type="submit"                         value="Comment." /> </label> <br /> 
			</form> 
		</div> 
	</xsl:template> 

	<xsl:template match="/whlx/items/item       /file"> 
		<xsl:if test="./image = 'true' "> 
			<div class="main_file"> 
				<a href="{./source}"> <img alt="{./alt}" src="{./source}" width="{./width}" height="{./height}" /> </a> <br /> 
				[Type <xsl:value-of select="./type" />] [Size <xsl:value-of select="./size" />Bytes] [Origin <xsl:value-of select="./name" />] <br /> 
			</div> 
		</xsl:if> 
		<xsl:if test="./image = 'false'"> 
			<div class="main_file"> 
				<a href="{./source}"> <xsl:value-of select="./alt" /> </a> <br /> 
				[Type <xsl:value-of select="./type" />] [Size <xsl:value-of select="./size" />Bytes] [Origin <xsl:value-of select="./name" />] <br /> 
			</div> 
		</xsl:if> 
	</xsl:template> 








	<!-- 内容 ( リスト類 ) --> 

	<xsl:template match="/whlx/contents    /item"> 
		<xsl:param name="limit" select="0"  /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<li> <a href="{@resource}"> <xsl:value-of select="@title" /> </a> </li> 
		</xsl:if> 
	</xsl:template> 

	<xsl:template match="/whlx/informations/item"> 
		<xsl:param name="limit" select="0"  /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<dt class="informations_left" > <xsl:value-of select="./@title" /> </dt> 
			<dd class="informations_right"> <xsl:value-of select="./@value" /> </dd> 
		</xsl:if> 
	</xsl:template> 

	<xsl:template match="/whlx/categories  /item"> <xsl:param name="limit" select="0"  /> <xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> <li> <a href="{@resource}"> <xsl:value-of select="@title" /> </a> </li> 
		</xsl:if> 
	</xsl:template>

	<xsl:template match="/whlx/category    /item"> 
		<xsl:param    name="limit"   select="10"     /> 
		<xsl:param    name="catid"   select="'0000'" /> 
		<xsl:variable name="catlink" select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $catid ]/@resource" /> 
		<xsl:variable name="catname" select="document( './categories.xml  ' )/whlx/categories  /item[ @id = $catid ]/@title"    /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<xsl:variable name="title"    select="@title"                                                      /> 
			<li> <a href="{@resource}"> <xsl:value-of select="$title" /> </a> </li> 
		</xsl:if> 
	</xsl:template>

	<xsl:template match="/whlx/articles    /item"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<xsl:variable name="resource" select="substring-before( @resource, '#' )"                          /> 
			<xsl:variable name="title"    select="@title"                                                      /> 
			<li> 
				<a href="{$resource}"> <xsl:value-of select="$title" /> </a> 
			</li> 
		</xsl:if> 
	</xsl:template> 

	<xsl:template match="/whlx/comments    /item"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<xsl:variable name="number"     select="substring-after ( @resource, '#' )"                          /> 
			<xsl:variable name="url_root"   select="substring-before( @resource, '#' )"                          /> 
			<xsl:variable name="url_cmnt"   select="@resource"                                                   /> 
			<xsl:variable name="url_name"   select="document( $url_root )/whlx/items/item[ @id = $number ]/url " /> 
			<xsl:variable name="title_root" select="document( $url_root )/whlx/@title"                           /> 
			<xsl:variable name="title_cmnt" select="@title"                                                      /> 
			<xsl:variable name="title_name" select="document( $url_root )/whlx/items/item[ @id = $number ]/name" /> 
			<li> 
				<a href="{$url_root}"> <xsl:value-of select="$title_root" /> </a> 
				<a href="{$url_cmnt}"> <xsl:value-of select="$number"     /> </a> 
				<a href="{$url_name}"> <xsl:value-of select="$title_name" /> </a> 
			</li> 
		</xsl:if> 
	</xsl:template> 

	<xsl:template match="/whlx/trackbacks  /item"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
			<xsl:variable name="number"     select="substring-after ( @resource, '#' )"                          /> 
			<xsl:variable name="url_root"   select="substring-before( @resource, '#' )"                          /> 
			<xsl:variable name="url_cmnt"   select="@resource"                                                   /> 
			<xsl:variable name="url_name"   select="document( $url_root )/whlx/items/item[ @id = $number ]/url " /> 
			<xsl:variable name="title_root" select="document( $url_root )/whlx/@title"                           /> 
			<xsl:variable name="title_cmnt" select="@title"                                                      /> 
			<xsl:variable name="title_name" select="document( $url_root )/whlx/items/item[ @id = $number ]/name" /> 
			<li> 
				<a href="{$url_root}"> <xsl:value-of select="$title_root" /> </a> 
				<a href="{$url_cmnt}"> <xsl:value-of select="$number"     /> </a> 
				<a href="{$url_name}"> <xsl:value-of select="$title_name" /> </a> 
			</li> 
		</xsl:if> 
	</xsl:template> 




	<!-- 内容 ( 要約類 ) --> 

	<xsl:template match="/whlx/articles    /excerpts"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:for-each select="document( './articles.xml    ' )/whlx/articles    /item"  > 
			<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
				<xsl:variable name="nm" select="substring-after ( @resource, '#' )"                                       /> 
				<xsl:variable name="rs" select="substring-before( @resource, '#' )"                                       /> 
				<xsl:variable name="tm" select="document( $rs )/whlx/items/item[ @id = $nm ]/title      " /> 
				<xsl:variable name="tx" select="document( $rs )/whlx/items/item[ @id = $nm ]/text       " /> 
				<xsl:variable name="cr" select="document( $rs )/whlx/items/item[ @id = $nm ]/creator    " /> 
				<xsl:variable name="dt" select="document( $rs )/whlx/items/item[ @id = $nm ]/date       " /> 
				<xsl:variable name="tb" select="document( $rs )/whlx/items/item[ @id = $nm ]/trackback  " /> 
				<xsl:variable name="fs" select="document( $rs )/whlx/items/item[ @id = $nm ]/file/source" /> 
				<xsl:variable name="fa" select="document( $rs )/whlx/items/item[ @id = $nm ]/file/alt   " /> 
				<div class="main_base"> 
					<h2  class="main_head"> <a href="{$rs}"> <xsl:value-of select="$tm" /> </a>                </h2>  
					<xsl:if test="$fs != ''"> <div class="main_file"> <a href="{$fs}"> <xsl:value-of select="$fa" /> </a> </div> </xsl:if> 
					<div class="main_body"> <xsl:copy-of  select="$tx" />                                      </div> 
					<h3  class="main_foot"> <xsl:value-of select="$cr" />                                      </h3> 
					<h3  class="main_foot"> <xsl:value-of select="$dt" />                                      </h3> 
					<h3  class="main_ping"> <xsl:value-of select="$tb" /> <a href="{$tb}"> TRACKBACK URL  </a> </h3> 
				</div> 
			</xsl:if> 
		</xsl:for-each> 
	</xsl:template> 


	<xsl:template match="/whlx/comments    /excerpts"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:for-each select="document( './comments.xml    ' )/whlx/comments    /item"  > 
			<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
				<xsl:variable name="nm" select="substring-after ( @resource, '#' )"                                       /> 
				<xsl:variable name="rs" select="substring-before( @resource, '#' )"                                       /> 
				<xsl:variable name="tm" select="document( $rs )/whlx/items/item[ @id = '0001' ]/title"   /> 
				<xsl:variable name="ts" select="document( $rs )/whlx/items/item[ @id = $nm    ]/title"   /> 
				<xsl:variable name="ur" select="document( $rs )/whlx/items/item[ @id = $nm    ]/url"     /> 
				<xsl:variable name="tx" select="document( $rs )/whlx/items/item[ @id = $nm    ]/excerpt" /> 
				<xsl:variable name="cr" select="document( $rs )/whlx/items/item[ @id = $nm    ]/name   " /> 
				<xsl:variable name="dt" select="document( $rs )/whlx/items/item[ @id = $nm    ]/date   " /> 
				<div class="cmnt_base"> 
					<h3  class="cmnt_head"> <a href="{$rs}"> <xsl:value-of select="$tm" /> </a> - <a href="{@resource}"> <xsl:value-of select="$ts" /> </a> </h3>  
					<div class="cmnt_body">                  <xsl:copy-of  select="$tx" />                                                                  </div> 
					<h4  class="cmnt_foot"> <a href="{$ur}"> <xsl:value-of select="$cr" /> </a>                                                             </h4>  
					<h4  class="cmnt_foot">                  <xsl:value-of select="$dt" />                                                                  </h4>  
				</div> 
			</xsl:if> 
		</xsl:for-each> 
	</xsl:template> 

	<xsl:template match="/whlx/trackbacks  /excerpts"> 
		<xsl:param name="limit" select="10" /> 
		<xsl:for-each select="document( './trackbacks.xml  ' )/whlx/trackbacks  /item"  > 
			<xsl:if test=" ( position() &lt;= $limit ) or ( $limit = 0 ) "> 
				<xsl:variable name="nm" select="substring-after ( @resource, '#' )"                                       /> 
				<xsl:variable name="rs" select="substring-before( @resource, '#' )"                                       /> 
				<xsl:variable name="tm" select="document( $rs )/whlx/items/item[ @id = '0001' ]/title"   /> 
				<xsl:variable name="ts" select="document( $rs )/whlx/items/item[ @id = $nm    ]/title"   /> 
				<xsl:variable name="ur" select="document( $rs )/whlx/items/item[ @id = $nm    ]/url"     /> 
				<xsl:variable name="tx" select="document( $rs )/whlx/items/item[ @id = $nm    ]/excerpt" /> 
				<xsl:variable name="cr" select="document( $rs )/whlx/items/item[ @id = $nm    ]/name   " /> 
				<xsl:variable name="dt" select="document( $rs )/whlx/items/item[ @id = $nm    ]/date   " /> 
				<div class="cmnt_base"> 
					<h3  class="cmnt_head"> <a href="{$rs}"> <xsl:value-of select="$tm" /> </a> - <a href="{@resource}"> <xsl:value-of select="$ts" /> </a> </h3>  
					<div class="cmnt_body">                  <xsl:copy-of  select="$tx" />                                                                  </div> 
					<h4  class="cmnt_foot"> <a href="{$ur}"> <xsl:value-of select="$cr" /> </a>                                                             </h4>  
					<h4  class="cmnt_foot">                  <xsl:value-of select="$dt" />                                                                  </h4>  
					<xsl:if test="$ur != ''"> <h3  class="cmnt_ping"> <xsl:value-of select="$ur" /> <a href="{$ur}"> TRACKBACK SOURCE </a> </h3> </xsl:if> 
				</div> 
			</xsl:if> 
		</xsl:for-each> 
	</xsl:template> 





</xsl:stylesheet> 

