<?php
// 
// WHLX CMS - new.php 
// 
// 20040403 - 0.00 alpha
// 20040411 - 0.04 alpha    外部ファイルの整理. ディレクトリ類は 'path.ini', へ移動. 設定類は 'whlx.ini' へ移動. 
// 




error_reporting( E_ERROR | E_PARSE );


$error   =  1;
$message =  'FAILED    : 新規投稿に失敗しました. ';
$others  =  '';


// './path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// './path.ini' はスクリプトと同じディレクトリに置く必要があります. 
$whlx =  parse_ini_file( './path.ini',      true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 


$result =  WHLX_NewArticle     ( $error, $message, $others, $whlx           );
$output =  WHLX_PostingResponse( $error, $message, $others, './_script.xsl' );


WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_NewArticle( $error, $message, $others );
function  WHLX_NewArticle( &$error, &$message, &$others, $whlx )
{
	$formdata =  new WHLX_Formdata();              // 
	$header   =  $formdata->header();              // 
	$form     =  $formdata->form  ();              // 
	$data     =  array_merge( $form, $header );    // 
	$output   =  array();                          // 
	$result   =  false;                            // 

	$data[ 'pw_crypt'     ] =  $whlx[ 'owner' ][ 'password' ];
//	$data[ 'creator'      ] =  'WHLX';    
	$data[ 'category'     ] =  '0001';    
//	$data[ 'ping'         ] =  '';    
//	$data[ 'ping'         ] =  'http://whlx.sourceforge.jp/whlx/script/tb.php/0001/'.  "\r\n";    
//	$data[ 'ping'         ] =  'http://whlx.sourceforge.jp/whlx/script/tb.php/0002/'.  "\r\n";    
	$data[ 'art_filedata' ] =  '';
	$data[ 'cat_filedata' ] =  '';
	$data[ 'new_filedata' ] =  '';

	$data[ 'xslt'         ] =  './_default.xsl';                                                                          // 
	$data[ 'id'           ] =  '0001';                                                                                    // 新規投稿の記事なので, 必ず '0001' になります. 
	$data[ 'action'       ] =  $whlx[ 'script' ][ 'new_article' ];                                                        // 
	$data[ 'art_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './articles.xml';                                         // 記事リストのファイル名を解決し, 記入します. 

	$others                 =  WHLX_New_Formdata               ( $data );                                                 // 

	$result                 =  WHLX_New_DataChecker            ( $data, $error, $message );                               // フォーム・データが空でないかどうか, パスワードを間違えてないかどうか, 調べます. 
	if( true != $result ) return false;

	$result                 =  WHLX_New_DataConverter          ( $data );                                                 // 制限文字数に切り詰め, HTMLタグや改行コードを変換します. 
	if( true != $result ) return false;

	// 記事の通し番号文字列 'series' が不明のままでは生成できない文字列などを生成します. 
	// まず 'series' 文字列を生成しますが, 之の生成には記事リスト・ファイル名が必要です. 
	$data[ 'series'       ] =  WHLX_New_Number_In_ListArticles ( $data );                                                 // 現在の記事リストを読み込んで、次に加える記事の通し番号を生成します. 
	$data[ 'resource'     ] =  './art_'.  $data[ 'series'   ].  '.xml#0001';                                              // 記事リスト及びカテゴリ別・記事リストに於いて使われるハイパー・リンク先を文字列 'resource' に記入します. 
	$data[ 'trackback'    ] =  $whlx[ 'script' ][ 'trackback'   ].  '/'.  $data[ 'series' ].  '/';                        // 記事に対するPing受け入れURLを文字列 'trackback' に記入します. 
	$data[ 'art_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './articles.xml';                                         // 記事リストのファイル名を解決し, 記入します. しかしながら, この操作は既に解決済みであり, プログラムを読み易くする為だけに挿入された行です. 
	$data[ 'cat_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './cat_'.  $data[ 'category' ].  '.xml';                  // カテゴリ別・記事リストのファイル名を解決し, 記入します. 
	$data[ 'new_filename' ] =  $whlx[ 'directory' ][ 'data' ].  './art_'.  $data[ 'series'   ].  '.xml';                  // 新規投稿された記事のファイル名を解決し, 記入します. 

	$data[ 'art_filedata' ] =  WHLX_New_InsertItem_ArticlesList( $data );                                                 // 記事アイテムを追加する事を以って, 記事リスト・データを再生成します. 
	$data[ 'cat_filedata' ] =  WHLX_New_InsertItem_CategoryList( $data );                                                 // 記事アイテムを追加する事を以って, カテゴリ別・記事リスト・データを再生成します. 
	$data[ 'new_filedata' ] =  WHLX_New_Create_NewArticle      ( $data );                                                 // 新規投稿された記事データを新規生成します. 

	$result                 =  WHLX_FileOutput( $data[ 'new_filedata' ], $data[ 'new_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	$result                 =  WHLX_FileOutput( $data[ 'art_filedata' ], $data[ 'art_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	$result                 =  WHLX_FileOutput( $data[ 'cat_filedata' ], $data[ 'cat_filename' ], WHLX_XML_FILEMODE );    // 
	if( true != $result ) return false;

	/*
	$message .= 
		'<pre>'.                    "\r\n".    
		$data[ 'action'       ].    "\r\n".    
		$data[ 'title'        ].    "\r\n".    
		$data[ 'title_short'  ].    "\r\n".    
		$data[ 'text'         ].    "\r\n".    
		$data[ 'ping'         ].    "\r\n".    
		$data[ 'creator'      ].    "\r\n".    
		$data[ 'category'     ].    "\r\n".    
		$data[ 'pw_crypt'     ].    "\r\n".    
		"\r\n".                                
		WHLX_ConvertString( $data[ 'new_filedata' ], 0x007F,  4096 ).    "\r\n".    "\r\n".    
		WHLX_ConvertString( $data[ 'art_filedata' ], 0x007F,  4096 ).    "\r\n".    "\r\n".    
		WHLX_ConvertString( $data[ 'cat_filedata' ], 0x007F,  4096 ).    "\r\n".    "\r\n".    
		'</pre>'.                      "\r\n";    
	*/

	return true;
}




// WHLX_New_DataChecker( $output, $_error, $message );
// // フォームに入力されたデータが空でないかどうか, パスワードを間違えてないかどうか, 調べます. 
function  WHLX_New_DataChecker( &$data, &$error, &$message )
{
	$error   =  0;
	$message =  '';

	if( $data[ 'title'    ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 表題       が未入力です. <br /> \n"; }
	if( $data[ 'text'     ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 本文       が未入力です. <br /> \n"; }
	if( $data[ 'creator'  ] == ''                                         ){ $error |= 1;  $message .= "\t\tERROR     : 筆者名     が未入力です. <br /> \n"; }
	if( !WHLX_PasswordChecker( $data[ 'password' ], $data[ 'pw_crypt' ] ) ){ $error |= 1;  $message .= "\t\tERROR     : パスワード が違います.   <br /> \n"; }
	if( $error == 0 ){ $message .= "\t\tSUCCEEDED : 書き込みに成功しました.  <br /> \r\n";  return true;  }
	else             { $message .= "\t\tFAILED    : 書き込みに失敗しました.  <br /> \r\n";  return false; }
}




// WHLX_New_DataConverter( $data );
// // HTMLタグや改行コードを変換します. 
// // 文字数を制限します. 
function  WHLX_New_DataConverter( &$data )
{
	// 'function WHLX_DateTimeString' は './utility.php' の中で記述されている補助関数です. 
	// 'function WHLX_ConvertString'  は './utility.php' の中で記述されている補助関数です. 
	$data[ 'date'        ] =  WHLX_DateTimeString();                                          
	$data[ 'title'       ] =  WHLX_ConvertString( $data[ 'title'   ], 0x007F,   128 );    
	$data[ 'text'        ] =  WHLX_ConvertString( $data[ 'text'    ], 0x007F,  4096 );    
	$data[ 'ping'        ] =  $data[ 'ping'     ];    
	$data[ 'creator'     ] =  WHLX_ConvertString( $data[ 'creator' ], 0x007F,   128 );    
	$data[ 'date'        ] =  WHLX_ConvertString( $data[ 'date'    ], 0x007F,   128 );    
	$data[ 'title_short' ] =  WHLX_ConvertString( $data[ 'title'   ], 0x007F,    24 );    
	$data[ 'category'    ] =  $data[ 'category' ];    
	$data[ 'pw_crypt'    ] =  $data[ 'pw_crypt' ];    
	return true;
}




// WHLX_New_Number_In_ListArticles ( $data );
// // 新規生成する記事ファイルの中に記入される記事番号を判定します. 
// // 記事リスト・ファイルのアイテム通し番号に +1 した物を新しい記事番号と決定します. 
// // 出力形式は文字列であり, フォーマットは %04d の形になります. 
function WHLX_New_Number_In_ListArticles ( $data )
{
	$dom    =  xmldocfile( $data[ 'art_filename' ] );    
	$whlx   =  $dom    ->child_nodes();
	$arts   =  $whlx[1]->child_nodes();
	$item   =  $arts[1]->child_nodes();
	$atts   =  $item[1]->attributes ();
	foreach( $atts as $att ) if( $att->name() == 'id' ) $id_last =  $att->value();
	$series =  substr( ( '1'.  $id_last ) + 1, 1, 4 );

	return  $series;
}




// WHLX_New_Create_NewArticle( $data );
// // 記事ファイルを新規生成します. 
function  WHLX_New_Create_NewArticle( $data )
{
	$dom                 =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$txt_pi_xslt         =  WHLX_DomXML_RegisterXSLT ( $dom, $data[ 'xslt' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$dom_whlx            =  WHLX_DomXML_CreateChild  ( $dom, $dom           , 'whlx'        , ''                    );    
	$dom_items           =  WHLX_DomXML_CreateChild  ( $dom, $dom_whlx      , 'items'       , ''                    );    
	$dom_item1           =  WHLX_DomXML_CreateChild  ( $dom, $dom_items     , 'item'        , ''                    );    
	$dom_item1_title     =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'title    '   , $data[ 'title'     ]  );    
	$dom_item1_url       =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'url      '   , $data[ 'url'       ]  );    
	$dom_item1_text      =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'text     '   , $data[ 'text'      ]  );    
	$dom_item1_creator   =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'creator  '   , $data[ 'creator'   ]  );    
	$dom_item1_date      =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'date     '   , WHLX_DateTimeString() );    
	$dom_item1_trackback =  WHLX_DomXML_CreateChild  ( $dom, $dom_item1     , 'trackback'   , $data[ 'trackback' ]  );    

	$dom_whlx ->set_attribute( 'series'  , $data[ 'series'      ] );    
	$dom_whlx ->set_attribute( 'category', $data[ 'category'    ] );    
	$dom_whlx ->set_attribute( 'title'   , $data[ 'title_short' ] );    
	$dom_item1->set_attribute( 'id'      , $data[ 'id'          ] );    // ここは必ず '0001' が入力される筈になっております. 

	return  str_replace( '><', ">\r\n<", $dom->dumpmem() );
//	return  $dom->dumpmem();
}




// WHLX_New_InsertItem_ArticlesList( $data );
// // 記事アイテムを追加する事を以って, 記事リスト・ファイルを再生成します. 
function  WHLX_New_InsertItem_ArticlesList( $data )
{
	$dom  =  xmldocfile( $data[ 'art_filename' ] );    
	$whlx =  $dom    ->child_nodes();
	$list =  $whlx[1]->child_nodes();
	$item =  $dom->create_element( 'item' );
	$list[1]->insert_before( $item, $list[1]->first_child() );
	$item->set_attribute( 'id'      , $data[ 'series'      ] );    
	$item->set_attribute( 'resource', $data[ 'resource'    ] );    
	$item->set_attribute( 'title'   , $data[ 'title_short' ] );    

	return  str_replace( '><', ">\r\n<", $dom->dumpmem() );
//	return  $dom->dumpmem();
}




// WHLX_New_InsertItem_CategoryList( $data );
// // 記事アイテムを追加する事を以って, カテゴリ別・記事リスト・ファイルを再生成します. 
function  WHLX_New_InsertItem_CategoryList( $data )
{
	$dom  =  xmldocfile( $data[ 'cat_filename' ] );    
	$whlx =  $dom    ->child_nodes();
	$list =  $whlx[1]->child_nodes();
	$item =  $dom->create_element( 'item' );
	$list[1]->insert_before( $item, $list[1]->first_child() );
	$item->set_attribute( 'id'      , $data[ 'series'      ] );    
	$item->set_attribute( 'resource', $data[ 'resource'    ] );    
	$item->set_attribute( 'title'   , $data[ 'title_short' ] );    

	return  str_replace( '><', ">\r\n<", $dom->dumpmem() );
//	return  $dom->dumpmem();
}




// WHLX_New_PingCreate( $ping );
function  WHLX_New_PingCreate( $ping )
{
	$output =  '';
	$array  =  preg_split( "/[\s]+/", $ping, -1, PREG_SPLIT_NO_EMPTY );

	reset( $array );
	while( list( , $value ) = each( $array ) ) 
		$output .= '			<ping url="'.    $value.   '" /> '.    "\r\n";

	return $output;
}




function  WHLX_New_Formdata( $data )
{
	if( $data[ 'style_br'  ] == 'true' ) $br =  'checked';    else $br =  '';    // 
	if( $data[ 'style_tg'  ] == 'true' ) $tg =  'checked';    else $tg =  '';    // 
//	$action =  WHLX_URI_NEW.  '?profile='.  $_form[ 'profile'   ];
	$action =  $data[ 'action' ];

	return 
		"\r\n".  
		'		<title> WHLX CMS - 新規投稿スクリプト </title> '.             "\r\n".    
		'		<form password="yes"> '.                                      "\r\n".    
		'			<action>'  .  $action             .  '</action>   '.  "\r\n".    
//		'			<profile>' .  $data[ 'profile'   ].  '</profile>  '.  "\r\n".    
		'			<title>'   .  $data[ 'title'     ].  '</title>    '.  "\r\n".    
		'			<text>'    .  $data[ 'text'      ].  '</text>     '.  "\r\n".    
//		'			<style_br>'.  $br                 .  '</style_br> '.  "\r\n".    
//		'			<style_tg>'.  $tg                 .  '</style_tg> '.  "\r\n".    
//		'			<ping>'    .  $data[ 'ping'      ].  '</ping>     '.  "\r\n".    
		'			<creator>' .  $data[ 'creator'   ].  '</creator>  '.  "\r\n".    
		'			<category>'.  $data[ 'category'  ].  '</category> '.  "\r\n".    
		'		</form> '.                                                    "\r\n";    
}




?>
