﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using WhereTrainBuild.MapUtil.Data;

namespace WhereTrainBuild.Script
{
    /// <summary>
    /// OuDiaインポート
    /// </summary>
    /// <remarks>
    /// 使い方
    /// 読み込みたい OuDiaファイルの駅と経路を先に構築します。
    /// 方面は、全て削除した方が良いです。
    /// 組織->プロパティで、日またぎ時刻を指定して下さい。　この時刻より前の時刻(例えば 1時0分に設定した場合、0時59分)は、前日として処理するようになります。
    /// 
    /// エラーが表示され、もう一度チャレンジする場合、平日、土日祝日の方面を全て削除してから行って下さい。
    /// </remarks>
    public class TransitBuildLogic
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TransitBuildLogic()
        {
        }

        /// <summary>
        /// 構築
        /// </summary>
        /// <param name="factory">対象ファクトリ</param>
        /// <param name="basefolder">ベースフォルダ</param>
        /// <param name="cnt">コントロール</param>
        /// <returns>戻値</returns>
        public object Build(BaseFactory factory, string basefolder, Control cnt)
        {
            try
            {
                using (var dlg = new OpenFileDialog())
                {
                    dlg.Title = "Load OuDia";
                    dlg.Filter = "OUD(*.oud)|*.oud|すべてのファイル(*.*)|*.*";
                    dlg.DefaultExt = "oud";
                    if (dlg.ShowDialog(cnt) != DialogResult.OK)
                        return "NG";

                    var tool = new OuDiaTool();

                    tool.Load(dlg.FileName, factory);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(cnt, ex.Message);
            }

            return "OK";
        }
    }
}
