/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.LocalString;
import weka.gui.TaskLogger;

public class WekaTaskMonitor
extends JPanel
implements TaskLogger {
    private int m_ActiveTasks = 0;
    private JLabel m_MonitorLabel;
    private ImageIcon m_iconStationary;
    private ImageIcon m_iconAnimated;
    private boolean m_animating = false;

    public WekaTaskMonitor() {
        Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_stationary.gif"));
        Image image2 = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_animated.gif"));
        this.m_iconStationary = new ImageIcon(image);
        this.m_iconAnimated = new ImageIcon(image2);
        this.m_MonitorLabel = new JLabel(" x " + this.m_ActiveTasks, this.m_iconStationary, 0);
        this.setLayout(new BorderLayout());
        Dimension dimension = this.m_MonitorLabel.getPreferredSize();
        this.m_MonitorLabel.setPreferredSize(new Dimension(dimension.width + 15, dimension.height));
        this.m_MonitorLabel.setMinimumSize(new Dimension(dimension.width + 15, dimension.height));
        this.add((Component)this.m_MonitorLabel, "Center");
    }

    public void taskStarted() {
        ++this.m_ActiveTasks;
        this.updateMonitor();
    }

    public void taskFinished() {
        --this.m_ActiveTasks;
        if (this.m_ActiveTasks < 0) {
            this.m_ActiveTasks = 0;
        }
        this.updateMonitor();
    }

    private void updateMonitor() {
        this.m_MonitorLabel.setText(" x " + this.m_ActiveTasks);
        if (this.m_ActiveTasks > 0 && !this.m_animating) {
            this.m_MonitorLabel.setIcon(this.m_iconAnimated);
            this.m_animating = true;
        }
        if (this.m_ActiveTasks == 0 && this.m_animating) {
            this.m_MonitorLabel.setIcon(this.m_iconStationary);
            this.m_animating = false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            WekaTaskMonitor wekaTaskMonitor = new WekaTaskMonitor();
            wekaTaskMonitor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LocalString.get("Weka Tasks")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            jFrame.getContentPane().add((Component)wekaTaskMonitor, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            wekaTaskMonitor.taskStarted();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

