/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveRange
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private Range m_Range = new Range(LocalString.get("first-last"));

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option(LocalString.get("\tSpecifies list of instances to select. First and last\n") + LocalString.get("\tare valid indexes. (required)\n"), "R", 1, LocalString.get("-R <inst1,inst2-inst4,...>")));
        vector.addElement(new Option(LocalString.get("\tSpecifies if inverse of selection is to be output.\n"), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setInstancesIndices(string);
        } else {
            this.setInstancesIndices(LocalString.get("first-last"));
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-R";
        stringArray[n++] = this.getInstancesIndices();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return LocalString.get("A filter that removes a given range of instances of a dataset.");
    }

    public String instancesIndicesTipText() {
        return LocalString.get("The range of instances to select. First and last are valid indexes.");
    }

    public String getInstancesIndices() {
        return this.m_Range.getRanges();
    }

    public void setInstancesIndices(String string) {
        this.m_Range.setRanges(string);
    }

    public String invertSelectionTipText() {
        return LocalString.get("Whether to invert the selection.");
    }

    public boolean getInvertSelection() {
        return this.m_Range.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Range.setInvert(bl);
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        this.m_Range.setUpper(this.getInputFormat().numInstances() - 1);
        for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
            if (this.m_Range.isInRange(i)) continue;
            this.push(this.getInputFormat().instance(i));
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new RemoveRange(), stringArray);
            } else {
                Filter.filterFile(new RemoveRange(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

