/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MakeIndicator
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private SingleIndex m_AttIndex = new SingleIndex(LocalString.get("last"));
    private Range m_ValIndex = new Range(LocalString.get("last"));
    private boolean m_Numeric = true;

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        this.m_ValIndex.setUpper(instances.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instances.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Chosen attribute not nominal."));
        }
        if (instances.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Chosen attribute has less ") + LocalString.get("than two values."));
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(instance2 = (Instance)instance.copy()).isMissing(this.m_AttIndex.getIndex())) {
            if (this.m_ValIndex.isInRange((int)instance2.value(this.m_AttIndex.getIndex()))) {
                instance2.setValue(this.m_AttIndex.getIndex(), 1.0);
            } else {
                instance2.setValue(this.m_AttIndex.getIndex(), 0.0);
            }
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSets the attribute index."), "C", 1, LocalString.get("-C <col>")));
        vector.addElement(new Option(LocalString.get("\tSpecify the list of values to indicate. First and last are\n") + LocalString.get("\tvalid indexes (default last)"), "V", 1, LocalString.get("-V <index1,index2-index4,...>")));
        vector.addElement(new Option(LocalString.get("\tSet if new boolean attribute nominal."), "N", 0, LocalString.get("-N <index>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex(LocalString.get("last"));
        }
        String string2 = Utils.getOption('V', stringArray);
        if (string2.length() != 0) {
            this.setValueIndices(string2);
        } else {
            this.setValueIndices(LocalString.get("last"));
        }
        this.setNumeric(!Utils.getFlag('N', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        stringArray[n++] = "-V";
        stringArray[n++] = this.getValueIndices();
        if (!this.getNumeric()) {
            stringArray[n++] = "-N";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return LocalString.get("A filter that creates a new dataset with a boolean attribute ") + LocalString.get("replacing a nominal attribute.  In the new dataset, a value of 1 is ") + LocalString.get("assigned to an instance that exhibits a particular range of attribute ") + LocalString.get("values, a 0 to an instance that doesn't. The boolean attribute is ") + LocalString.get("coded as numeric by default.");
    }

    public String attributeIndexTipText() {
        return LocalString.get("Sets which attribute should be replaced by the indicator. This ") + LocalString.get("attribute must be nominal.");
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public Range getValueRange() {
        return this.m_ValIndex;
    }

    public String valueIndicesTipText() {
        return LocalString.get("Specify range of nominal values to act on.") + LocalString.get(" This is a comma separated list of attribute indices (numbered from") + LocalString.get(" 1), with \"first\" and \"last\" valid values. Specify an inclusive") + LocalString.get(" range with \"-\". E.g: \"first-3,5,6-10,last\".");
    }

    public String getValueIndices() {
        return this.m_ValIndex.getRanges();
    }

    public void setValueIndices(String string) {
        this.m_ValIndex.setRanges(string);
    }

    public void setValueIndex(int n) {
        this.setValueIndices("" + (n + 1));
    }

    public void setValueIndicesArray(int[] nArray) {
        this.setValueIndices(Range.indicesToRangeList(nArray));
    }

    public String numericTipText() {
        return LocalString.get("Determines whether the output indicator attribute is numeric. If ") + LocalString.get("this is set to false, the output attribute will be nominal.");
    }

    public void setNumeric(boolean bl) {
        this.m_Numeric = bl;
    }

    public boolean getNumeric() {
        return this.m_Numeric;
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i != this.m_AttIndex.getIndex()) {
                fastVector.addElement(attribute);
                continue;
            }
            if (this.m_Numeric) {
                fastVector.addElement(new Attribute(attribute.name()));
                continue;
            }
            int[] nArray = this.m_ValIndex.getSelection();
            String string = nArray.length == 1 ? attribute.value(nArray[0]) : this.m_ValIndex.getRanges().replace(',', '_');
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(LocalString.get("neg_") + string);
            fastVector2.addElement(LocalString.get("pos_") + string);
            fastVector.addElement(new Attribute(attribute.name(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new MakeIndicator(), stringArray);
            } else {
                Filter.filterFile(new MakeIndicator(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

