/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import weka.LocalString;
import weka.core.Utils;
import weka.experiment.Stats;

public class AttributeStats
implements Serializable {
    public int intCount = 0;
    public int realCount = 0;
    public int missingCount = 0;
    public int distinctCount = 0;
    public int uniqueCount = 0;
    public int totalCount = 0;
    public Stats numericStats;
    public int[] nominalCounts;

    protected void addDistinct(double d, int n) {
        if (n > 0) {
            if (n == 1) {
                ++this.uniqueCount;
            }
            if (Utils.eq(d, (int)d)) {
                this.intCount += n;
            } else {
                this.realCount += n;
            }
            if (this.nominalCounts != null) {
                this.nominalCounts[(int)d] = n;
            }
            if (this.numericStats != null) {
                this.numericStats.add(d, n);
                this.numericStats.calculateDerived();
            }
        }
        ++this.distinctCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utils.padLeft(LocalString.get("Type"), 4)).append(Utils.padLeft(LocalString.get("Nom"), 5));
        stringBuffer.append(Utils.padLeft(LocalString.get("Int"), 5)).append(Utils.padLeft(LocalString.get("Real"), 5));
        stringBuffer.append(Utils.padLeft(LocalString.get("Missing"), 12));
        stringBuffer.append(Utils.padLeft(LocalString.get("Unique"), 12));
        stringBuffer.append(Utils.padLeft(LocalString.get("Dist"), 6));
        if (this.nominalCounts != null) {
            stringBuffer.append(' ');
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                stringBuffer.append(Utils.padLeft("C[" + i + "]", 5));
            }
        }
        stringBuffer.append('\n');
        long l = Math.round(100.0 * (double)this.intCount / (double)this.totalCount);
        if (this.nominalCounts != null) {
            stringBuffer.append(Utils.padLeft(LocalString.get("Nom"), 4)).append(' ');
            stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
            stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
        } else {
            stringBuffer.append(Utils.padLeft(LocalString.get("Num"), 4)).append(' ');
            stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
            stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
        }
        l = Math.round(100.0 * (double)this.realCount / (double)this.totalCount);
        stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
        stringBuffer.append(Utils.padLeft("" + this.missingCount, 5)).append(" /");
        l = Math.round(100.0 * (double)this.missingCount / (double)this.totalCount);
        stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
        stringBuffer.append(Utils.padLeft("" + this.uniqueCount, 5)).append(" /");
        l = Math.round(100.0 * (double)this.uniqueCount / (double)this.totalCount);
        stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
        stringBuffer.append(Utils.padLeft("" + this.distinctCount, 5)).append(' ');
        if (this.nominalCounts != null) {
            for (int i = 0; i < this.nominalCounts.length; ++i) {
                stringBuffer.append(Utils.padLeft("" + this.nominalCounts[i], 5));
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

