/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ZeroR
extends Classifier
implements WeightedInstancesHandler {
    private double m_ClassValue;
    private double[] m_Counts;
    private Attribute m_Class;

    public String globalInfo() {
        return LocalString.get("Class for building and using a 0-R classifier. Predicts the mean ") + LocalString.get("(for a numeric class) or the mode (for a nominal class).");
    }

    public void buildClassifier(Instances instances) throws Exception {
        double d = 0.0;
        this.m_Class = instances.classAttribute();
        this.m_ClassValue = 0.0;
        switch (instances.classAttribute().type()) {
            case 0: {
                this.m_Counts = null;
                break;
            }
            case 1: {
                this.m_Counts = new double[instances.numClasses()];
                for (int i = 0; i < this.m_Counts.length; ++i) {
                    this.m_Counts[i] = 1.0;
                }
                d = instances.numClasses();
                break;
            }
            default: {
                throw new Exception(LocalString.get("ZeroR can only handle nominal and numeric class") + LocalString.get(" attributes."));
            }
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.classIsMissing()) continue;
            if (instances.classAttribute().isNominal()) {
                int n = (int)instance.classValue();
                this.m_Counts[n] = this.m_Counts[n] + instance.weight();
            } else {
                this.m_ClassValue += instance.weight() * instance.classValue();
            }
            d += instance.weight();
        }
        if (instances.classAttribute().isNumeric()) {
            if (Utils.gr(d, 0.0)) {
                this.m_ClassValue /= d;
            }
        } else {
            this.m_ClassValue = Utils.maxIndex(this.m_Counts);
            Utils.normalize(this.m_Counts, d);
        }
    }

    public double classifyInstance(Instance instance) {
        return this.m_ClassValue;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Counts == null) {
            double[] dArray = new double[]{this.m_ClassValue};
            return dArray;
        }
        return (double[])this.m_Counts.clone();
    }

    public String toString() {
        if (this.m_Class == null) {
            return LocalString.get("ZeroR: No model built yet.");
        }
        if (this.m_Counts == null) {
            return LocalString.get("ZeroR predicts class value: ") + this.m_ClassValue;
        }
        return LocalString.get("ZeroR predicts class value: ") + this.m_Class.value((int)this.m_ClassValue);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new ZeroR(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

