/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class TabuSearch
extends HillClimber {
    int m_nRuns = 10;
    int m_nTabuList = 5;
    HillClimber.Operation[] m_oTabuList = null;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        double d;
        this.m_oTabuList = new HillClimber.Operation[this.m_nTabuList];
        int n = 0;
        double d2 = d = this.calcScore(bayesNet);
        BayesNet bayesNet2 = new BayesNet();
        bayesNet2.m_Instances = instances;
        bayesNet2.initStructure();
        this.copyParentSets(bayesNet2, bayesNet);
        for (int i = 0; i < this.m_nRuns; ++i) {
            HillClimber.Operation operation = this.getOptimalOperation(bayesNet, instances);
            this.performOperation(bayesNet, instances, operation);
            if (operation == null) {
                throw new Exception(LocalString.get("Panic: could not find any step to make. Tabu list too long?"));
            }
            this.m_oTabuList[n] = operation;
            n = (n + 1) % this.m_nTabuList;
            if ((d += operation.m_fScore) > d2) {
                d2 = d;
                this.copyParentSets(bayesNet2, bayesNet);
            }
            if (!bayesNet.getDebug()) continue;
            this.printTabuList();
        }
        this.copyParentSets(bayesNet, bayesNet2);
        bayesNet2 = null;
    }

    void copyParentSets(BayesNet bayesNet, BayesNet bayesNet2) {
        int n = bayesNet2.getNrOfNodes();
        for (int i = 0; i < n; ++i) {
            bayesNet.getParentSet(i).copy(bayesNet2.getParentSet(i));
        }
    }

    boolean isNotTabu(HillClimber.Operation operation) {
        for (int i = 0; i < this.m_nTabuList; ++i) {
            if (!operation.equals(this.m_oTabuList[i])) continue;
            return false;
        }
        return true;
    }

    void printTabuList() {
        for (int i = 0; i < this.m_nTabuList; ++i) {
            HillClimber.Operation operation = this.m_oTabuList[i];
            if (operation == null) continue;
            if (operation.m_nOperation == 0) {
                System.out.print(" +(");
            } else {
                System.out.print(" -(");
            }
            System.out.print(operation.m_nTail + "->" + operation.m_nHead + ")");
        }
        System.out.println();
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int n) {
        this.m_nRuns = n;
    }

    public int getTabuList() {
        return this.m_nTabuList;
    }

    public void setTabuList(int n) {
        this.m_nTabuList = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tTabu list length\n"), "L", 1, LocalString.get("-L <integer>")));
        vector.addElement(new Option(LocalString.get("\tNumber of runs\n"), "U", 1, LocalString.get("-U <integer>")));
        vector.addElement(new Option(LocalString.get("\tMaximum number of parents\n"), "P", 1, LocalString.get("-P <nr of parents>")));
        vector.addElement(new Option(LocalString.get("\tUse arc reversal operation.\n\t(default false)"), "R", 0, "-R"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('L', stringArray);
        if (string2.length() != 0) {
            this.setTabuList(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('U', stringArray)).length() != 0) {
            this.setRuns(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getTabuList();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRuns();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return LocalString.get("This Bayes Network learning algorithm uses tabu search for finding a well scoring ") + LocalString.get("Bayes network structure. Tabu search is hill climbing till an optimum is reached. The ") + LocalString.get("following step is the least worst possible step. The last X steps are kept in a list and ") + LocalString.get("none of the steps in this so called tabu list is considered in taking the next step. ") + LocalString.get("The best network found in this traversal is returned.");
    }

    public String runsTipText() {
        return LocalString.get("Sets the number of steps to be performed.");
    }

    public String tabuListTipText() {
        return LocalString.get("Sets the length of the tabu list.");
    }
}

