/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.util.Random;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.boundaryvisualizer.DataGenerator;
import weka.gui.boundaryvisualizer.RemoteResult;

public class RemoteBoundaryVisualizerSubTask
implements Task {
    private TaskStatusInfo m_status = new TaskStatusInfo();
    private RemoteResult m_result;
    private int m_rowNumber;
    private int m_panelHeight;
    private int m_panelWidth;
    private Classifier m_classifier;
    private DataGenerator m_dataGenerator;
    private Instances m_trainingData;
    private int m_xAttribute;
    private int m_yAttribute;
    private double m_pixHeight;
    private double m_pixWidth;
    private double m_minX;
    private double m_minY;
    private double m_maxX;
    private double m_maxY;
    private int m_numOfSamplesPerRegion = 2;
    private int m_numOfSamplesPerGenerator;
    private double m_samplesBase = 2.0;
    private Random m_random;
    private double[] m_weightingAttsValues;
    private boolean[] m_attsToWeightOn;
    private double[] m_vals;
    private double[] m_dist;
    private Instance m_predInst;

    public void setRowNumber(int n) {
        this.m_rowNumber = n;
    }

    public void setPanelWidth(int n) {
        this.m_panelWidth = n;
    }

    public void setPanelHeight(int n) {
        this.m_panelHeight = n;
    }

    public void setPixHeight(double d) {
        this.m_pixHeight = d;
    }

    public void setPixWidth(double d) {
        this.m_pixWidth = d;
    }

    public void setClassifier(Classifier classifier) {
        this.m_classifier = classifier;
    }

    public void setDataGenerator(DataGenerator dataGenerator) {
        this.m_dataGenerator = dataGenerator;
    }

    public void setInstances(Instances instances) {
        this.m_trainingData = instances;
    }

    public void setMinMaxX(double d, double d2) {
        this.m_minX = d;
        this.m_maxX = d2;
    }

    public void setMinMaxY(double d, double d2) {
        this.m_minY = d;
        this.m_maxY = d2;
    }

    public void setXAttribute(int n) {
        this.m_xAttribute = n;
    }

    public void setYAttribute(int n) {
        this.m_yAttribute = n;
    }

    public void setNumSamplesPerRegion(int n) {
        this.m_numOfSamplesPerRegion = n;
    }

    public void setGeneratorSamplesBase(double d) {
        this.m_samplesBase = d;
    }

    public void execute() {
        this.m_random = new Random(this.m_rowNumber * 11);
        this.m_dataGenerator.setSeed(this.m_rowNumber * 11);
        this.m_result = new RemoteResult(this.m_rowNumber, this.m_panelWidth);
        this.m_status.setTaskResult(this.m_result);
        this.m_status.setExecutionStatus(1);
        try {
            this.m_numOfSamplesPerGenerator = (int)Math.pow(this.m_samplesBase, this.m_trainingData.numAttributes() - 3);
            if (this.m_trainingData == null) {
                throw new Exception(LocalString.get("No training data set (BoundaryPanel)"));
            }
            if (this.m_classifier == null) {
                throw new Exception(LocalString.get("No classifier set (BoundaryPanel)"));
            }
            if (this.m_dataGenerator == null) {
                throw new Exception(LocalString.get("No data generator set (BoundaryPanel)"));
            }
            if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
                throw new Exception(LocalString.get("Visualization dimensions must be numeric ") + LocalString.get("(RemoteBoundaryVisualizerSubTask)"));
            }
            this.m_attsToWeightOn = new boolean[this.m_trainingData.numAttributes()];
            this.m_attsToWeightOn[this.m_xAttribute] = true;
            this.m_attsToWeightOn[this.m_yAttribute] = true;
            this.m_weightingAttsValues = new double[this.m_attsToWeightOn.length];
            this.m_vals = new double[this.m_trainingData.numAttributes()];
            this.m_predInst = new Instance(1.0, this.m_vals);
            this.m_predInst.setDataset(this.m_trainingData);
            System.err.println(LocalString.get("Executing row number ") + this.m_rowNumber);
            for (int i = 0; i < this.m_panelWidth; ++i) {
                double[] dArray = this.calculateRegionProbs(i, this.m_rowNumber);
                this.m_result.setLocationProbs(i, dArray);
                this.m_result.setPercentCompleted((int)(100.0 * ((double)i / (double)this.m_panelWidth)));
            }
        }
        catch (Exception exception) {
            this.m_status.setExecutionStatus(2);
            this.m_status.setStatusMessage(LocalString.get("Row ") + this.m_rowNumber + LocalString.get(" failed."));
            System.err.print(exception);
            return;
        }
        this.m_status.setExecutionStatus(3);
        this.m_status.setStatusMessage(LocalString.get("Row ") + this.m_rowNumber + LocalString.get(" completed successfully."));
    }

    private double[] calculateRegionProbs(int n, int n2) throws Exception {
        double[] dArray = new double[this.m_trainingData.classAttribute().numValues()];
        for (int i = 0; i < this.m_numOfSamplesPerRegion; ++i) {
            int n3;
            double[] dArray2 = new double[this.m_trainingData.classAttribute().numValues()];
            this.m_weightingAttsValues[this.m_xAttribute] = this.getRandomX(n);
            this.m_weightingAttsValues[this.m_yAttribute] = this.getRandomY(this.m_panelHeight - n2 - 1);
            this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
            double[] dArray3 = this.m_dataGenerator.getWeights();
            double d = Utils.sum(dArray3);
            int[] nArray = Utils.sort(dArray3);
            int[] nArray2 = new int[nArray.length];
            double d2 = 0.0;
            double d3 = 0.99 * d;
            int n4 = dArray3.length - 1;
            int n5 = 0;
            for (n3 = dArray3.length - 1; n3 >= 0; --n3) {
                nArray2[n4--] = nArray[n3];
                ++n5;
                if ((d2 += dArray3[nArray[n3]]) > d3) break;
            }
            nArray = new int[n5];
            System.arraycopy(nArray2, n4 + 1, nArray, 0, n5);
            for (n3 = 0; n3 < this.m_numOfSamplesPerGenerator; ++n3) {
                this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                double[][] dArray4 = this.m_dataGenerator.generateInstances(nArray);
                for (int j = 0; j < dArray4.length; ++j) {
                    if (dArray4[j] == null) continue;
                    System.arraycopy(dArray4[j], 0, this.m_vals, 0, this.m_vals.length);
                    this.m_vals[this.m_xAttribute] = this.m_weightingAttsValues[this.m_xAttribute];
                    this.m_vals[this.m_yAttribute] = this.m_weightingAttsValues[this.m_yAttribute];
                    this.m_dist = this.m_classifier.distributionForInstance(this.m_predInst);
                    for (int k = 0; k < dArray2.length; ++k) {
                        int n6 = k;
                        dArray2[n6] = dArray2[n6] + this.m_dist[k] * dArray3[j];
                    }
                }
            }
            for (n3 = 0; n3 < dArray.length; ++n3) {
                int n7 = n3;
                dArray[n7] = dArray[n7] + dArray2[n3] * d;
            }
        }
        Utils.normalize(dArray);
        double[] dArray5 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
        return dArray5;
    }

    private double getRandomX(int n) {
        double d = this.m_minX + (double)n * this.m_pixWidth;
        return d + this.m_random.nextDouble() * this.m_pixWidth;
    }

    private double getRandomY(int n) {
        double d = this.m_minY + (double)n * this.m_pixHeight;
        return d + this.m_random.nextDouble() * this.m_pixHeight;
    }

    public TaskStatusInfo getTaskStatus() {
        return this.m_status;
    }
}

