/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import weka.LocalString;
import weka.core.Instances;

public class AttributeListPanel
extends JPanel {
    protected JTable m_Table = new JTable();
    protected AttributeTableModel m_Model;

    public AttributeListPanel() {
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public void setInstances(Instances instances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(instances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tableColumnModel = this.m_Table.getColumnModel();
            tableColumnModel.getColumn(0).setMaxWidth(60);
            tableColumnModel.getColumn(1).setMinWidth(100);
        } else {
            this.m_Model.setInstances(instances);
        }
        this.m_Table.sizeColumnsToFit(-1);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception(LocalString.get("supply the name of an arff file"));
            }
            Instances instances = new Instances(new BufferedReader(new FileReader(stringArray[0])));
            AttributeListPanel attributeListPanel = new AttributeListPanel();
            final JFrame jFrame = new JFrame(LocalString.get("Attribute List Panel"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)attributeListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            attributeListPanel.setInstances(instances);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        protected Instances m_Instances;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
        }

        public int getRowCount() {
            return this.m_Instances.numAttributes();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.m_Instances.attribute(n).name();
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String(LocalString.get("Name"));
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

