/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class Resample
extends Filter
implements SupervisedFilter,
OptionHandler {
    private double m_SampleSizePercent = 100.0;
    private int m_RandomSeed = 1;
    private double m_BiasToUniformClass = 0.0;
    private boolean m_FirstBatchDone = false;

    public String globalInfo() {
        return LocalString.get("Produces a random subsample of a dataset using sampling with replacement.") + LocalString.get("The original dataset must ") + LocalString.get("fit entirely in memory. The number of instances in the generated ") + LocalString.get("dataset may be specified. The dataset must have a nominal class ") + LocalString.get("attribute. If not, use the unsupervised version. The filter can be ") + LocalString.get("made to maintain the class distribution in the subsample, or to bias ") + LocalString.get("the class distribution toward a uniform distribution. When used in batch ") + LocalString.get("mode (i.e. in the FilteredClassifier), subsequent batches are NOTE resampled.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option(LocalString.get("\tSpecify the random number seed (default 1)"), "S", 1, LocalString.get("-S <num>")));
        vector.addElement(new Option(LocalString.get("\tThe size of the output dataset, as a percentage of\n") + LocalString.get("\tthe input dataset (default 100)"), "Z", 1, LocalString.get("-Z <num>")));
        vector.addElement(new Option(LocalString.get("\tBias factor towards uniform class distribution.\n") + LocalString.get("\t0 = distribution in input data -- 1 = uniform distribution.\n") + LocalString.get("\t(default 0)"), "B", 1, LocalString.get("-B <num>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        String string2 = Utils.getOption('B', stringArray);
        if (string2.length() != 0) {
            this.setBiasToUniformClass(Double.valueOf(string2));
        } else {
            this.setBiasToUniformClass(0.0);
        }
        String string3 = Utils.getOption('Z', stringArray);
        if (string3.length() != 0) {
            this.setSampleSizePercent(Double.valueOf(string3));
        } else {
            this.setSampleSizePercent(100.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getBiasToUniformClass();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.getSampleSizePercent();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String biasToUniformClassTipText() {
        return LocalString.get("Whether to use bias towards a uniform class. A value of 0 leaves the class ") + LocalString.get("distribution as-is, a value of 1 ensures the class distribution is ") + LocalString.get("uniform in the output data.");
    }

    public double getBiasToUniformClass() {
        return this.m_BiasToUniformClass;
    }

    public void setBiasToUniformClass(double d) {
        this.m_BiasToUniformClass = d;
    }

    public String randomSeedTipText() {
        return LocalString.get("Sets the random number seed for subsampling.");
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String sampeSizePercentTipText() {
        return LocalString.get("The subsample size as a percentage of the original set.");
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double d) {
        this.m_SampleSizePercent = d;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (instances.classIndex() < 0 || !instances.classAttribute().isNominal()) {
            throw new IllegalArgumentException(LocalString.get("Supervised resample requires nominal class"));
        }
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_FirstBatchDone = false;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (!this.m_FirstBatchDone) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    private void createSubsample() {
        int n;
        int n2;
        int n3 = this.getInputFormat().numInstances();
        int n4 = (int)((double)n3 * this.m_SampleSizePercent / 100.0);
        this.getInputFormat().sort(this.getInputFormat().classIndex());
        int[] nArray = new int[this.getInputFormat().numClasses() + 1];
        int n5 = 0;
        nArray[n5] = 0;
        for (n2 = 0; n2 < this.getInputFormat().numInstances(); ++n2) {
            Instance instance = this.getInputFormat().instance(n2);
            if (instance.classIsMissing()) {
                for (n = n5 + 1; n < nArray.length; ++n) {
                    nArray[n] = n2;
                }
                break;
            }
            if (instance.classValue() == (double)n5) continue;
            n = n5 + 1;
            while ((double)n <= instance.classValue()) {
                nArray[n] = n2;
                ++n;
            }
            n5 = (int)instance.classValue();
        }
        if (n5 <= this.getInputFormat().numClasses()) {
            for (n2 = n5 + 1; n2 < nArray.length; ++n2) {
                nArray[n2] = this.getInputFormat().numInstances();
            }
        }
        n2 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] == nArray[i + 1]) continue;
            ++n2;
        }
        Random random = new Random(this.m_RandomSeed);
        for (n = 0; n < n4; ++n) {
            int n6 = 0;
            if (random.nextDouble() < this.m_BiasToUniformClass) {
                int n7 = random.nextInt(n2);
                int n8 = 0;
                for (int i = 0; i < nArray.length - 1; ++i) {
                    if (nArray[i] == nArray[i + 1] || n8++ < n7) continue;
                    n6 = nArray[i] + random.nextInt(nArray[i + 1] - nArray[i]);
                    break;
                }
            } else {
                n6 = random.nextInt(n3);
            }
            this.push((Instance)this.getInputFormat().instance(n6).copy());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Resample(), stringArray);
            } else {
                Filter.filterFile(new Resample(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

