/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import javax.swing.JOptionPane;
import weka.LocalString;
import weka.core.Utils;

public class Memory {
    protected static boolean m_Enabled = true;
    protected boolean m_UseGUI = false;
    protected static long m_Initial = Runtime.getRuntime().totalMemory();
    protected long m_Total;
    protected long m_Max;
    protected Runtime m_Runtime;

    public Memory() {
        this(false);
    }

    public Memory(boolean bl) {
        this.m_UseGUI = bl;
        this.m_Runtime = Runtime.getRuntime();
        this.m_Max = this.m_Runtime.maxMemory();
        this.m_Total = this.m_Runtime.totalMemory();
    }

    public boolean isEnabled() {
        return m_Enabled;
    }

    public void setEnabled(boolean bl) {
        m_Enabled = bl;
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public long getInitial() {
        return m_Initial;
    }

    public long getCurrent() {
        this.m_Runtime = Runtime.getRuntime();
        this.m_Total = this.m_Runtime.totalMemory();
        return this.m_Total;
    }

    public long getMax() {
        return this.m_Max;
    }

    public boolean isOutOfMemory() {
        if (this.isEnabled()) {
            return this.getMax() - this.getCurrent() < this.getInitial() + 200000L;
        }
        return false;
    }

    public void showOutOfMemory() {
        if (!this.isEnabled()) {
            return;
        }
        System.gc();
        double d = 1048576.0;
        double d2 = (double)m_Initial / d;
        double d3 = (double)this.m_Total / d;
        double d4 = (double)this.m_Max / d;
        String string = LocalString.get("Not enough memory. Please load a smaller ") + LocalString.get("dataset or use larger heap size.\n") + LocalString.get("- initial JVM size:   ") + Utils.doubleToString(d2, 1) + LocalString.get("MB\n") + LocalString.get("- total memory used:  ") + Utils.doubleToString(d3, 1) + LocalString.get("MB\n") + LocalString.get("- max. memory avail.: ") + Utils.doubleToString(d4, 1) + LocalString.get("MB\n") + "\n" + "Note:\n" + LocalString.get("The Java heap size can be specified with the -Xmx option.\n") + LocalString.get("E.g., to use 128MB as heap size, the command line looks like this:\n") + LocalString.get("   java -Xmx128m -classpath ...");
        System.err.println(string);
        if (this.getUseGUI()) {
            JOptionPane.showMessageDialog(null, string, LocalString.get("OutOfMemory"), 2);
        }
    }

    public void stopThreads() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            if (thread == null || thread == Thread.currentThread()) continue;
            if (thread.getName().startsWith(LocalString.get("Thread"))) {
                thread.stop();
                continue;
            }
            if (!thread.getName().startsWith(LocalString.get("AWT-EventQueue"))) continue;
            thread.stop();
        }
        threadArray = null;
        System.gc();
    }
}

