/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Enumeration;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;

public class IB1
extends Classifier
implements UpdateableClassifier {
    private Instances m_Train;
    private double[] m_MinArray;
    private double[] m_MaxArray;

    public String globalInfo() {
        return LocalString.get("Nearest-neighbour classifier. Uses normalized Euclidean distance to ") + LocalString.get("find the training instance closest to the given test instance, and predicts ") + LocalString.get("the same class as this training instance. If multiple instances have ") + LocalString.get("the same (smallest) distance to the test instance, the first one found is ") + LocalString.get("used.  For more information, see \n\n") + LocalString.get("Aha, D., and D. Kibler (1991) \"Instance-based learning algorithms\", ") + LocalString.get("Machine Learning, vol.6, pp. 37-66.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.classAttribute().isNumeric()) {
            throw new Exception(LocalString.get("IB1: Class is numeric!"));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("IB1: Cannot handle string attributes!"));
        }
        this.m_Train = new Instances(instances, 0, instances.numInstances());
        this.m_Train.deleteWithMissingClass();
        this.m_MinArray = new double[this.m_Train.numAttributes()];
        this.m_MaxArray = new double[this.m_Train.numAttributes()];
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            this.m_MaxArray[i] = Double.NaN;
            this.m_MinArray[i] = Double.NaN;
        }
        Enumeration enumeration = this.m_Train.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.updateMinMax((Instance)enumeration.nextElement());
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception(LocalString.get("Incompatible instance types"));
        }
        if (instance.classIsMissing()) {
            return;
        }
        this.m_Train.add(instance);
        this.updateMinMax(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Train.numInstances() == 0) {
            throw new Exception(LocalString.get("No training instances!"));
        }
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        this.updateMinMax(instance);
        Enumeration enumeration = this.m_Train.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            double d3;
            Instance instance2 = (Instance)enumeration.nextElement();
            if (instance2.classIsMissing() || !((d3 = this.distance(instance, instance2)) < d)) continue;
            d = d3;
            d2 = instance2.classValue();
        }
        return d2;
    }

    public String toString() {
        return LocalString.get("IB1 classifier");
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            double d2;
            if (i == this.m_Train.classIndex()) continue;
            if (this.m_Train.attribute(i).isNominal()) {
                if (!instance.isMissing(i) && !instance2.isMissing(i) && (int)instance.value(i) == (int)instance2.value(i)) continue;
                d += 1.0;
                continue;
            }
            if (instance.isMissing(i) || instance2.isMissing(i)) {
                if (instance.isMissing(i) && instance2.isMissing(i)) {
                    d2 = 1.0;
                } else {
                    d2 = instance2.isMissing(i) ? this.norm(instance.value(i), i) : this.norm(instance2.value(i), i);
                    if (d2 < 0.5) {
                        d2 = 1.0 - d2;
                    }
                }
            } else {
                d2 = this.norm(instance.value(i), i) - this.norm(instance2.value(i), i);
            }
            d += d2 * d2;
        }
        return d;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_MinArray[n]) || Utils.eq(this.m_MaxArray[n], this.m_MinArray[n])) {
            return 0.0;
        }
        return (d - this.m_MinArray[n]) / (this.m_MaxArray[n] - this.m_MinArray[n]);
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            if (!this.m_Train.attribute(i).isNumeric() || instance.isMissing(i)) continue;
            if (Double.isNaN(this.m_MinArray[i])) {
                this.m_MinArray[i] = instance.value(i);
                this.m_MaxArray[i] = instance.value(i);
                continue;
            }
            if (instance.value(i) < this.m_MinArray[i]) {
                this.m_MinArray[i] = instance.value(i);
                continue;
            }
            if (!(instance.value(i) > this.m_MaxArray[i])) continue;
            this.m_MaxArray[i] = instance.value(i);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new IB1(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

