/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Option;
import weka.core.Utils;

public abstract class SingleClassifierEnhancer
extends Classifier {
    protected Classifier m_Classifier = new ZeroR();

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector(3);
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option(LocalString.get("\tFull name of base classifier.\n") + LocalString.get("\t(default: ") + this.defaultClassifierString() + ")", "W", 1, "-W"));
        vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to classifier ") + this.m_Classifier.getClass().getName() + ":"));
        enumeration = this.m_Classifier.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setClassifier(Classifier.forName(string, null));
            this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
        } else {
            this.setClassifier(Classifier.forName(this.defaultClassifierString(), null));
            this.setClassifier(Classifier.forName(this.defaultClassifierString(), Utils.partitionOptions(stringArray)));
        }
    }

    public String[] getOptions() {
        String[] stringArray = this.m_Classifier.getOptions();
        int n = stringArray.length;
        if (n > 0) {
            ++n;
        }
        String[] stringArray2 = super.getOptions();
        String[] stringArray3 = new String[stringArray2.length + n + 2];
        int n2 = 0;
        stringArray3[n2++] = "-W";
        stringArray3[n2++] = this.getClassifier().getClass().getName();
        System.arraycopy(stringArray2, 0, stringArray3, n2, stringArray2.length);
        n2 += stringArray2.length;
        if (stringArray.length > 0) {
            stringArray3[n2++] = "--";
            System.arraycopy(stringArray, 0, stringArray3, n2, stringArray.length);
        }
        return stringArray3;
    }

    public String classifierTipText() {
        return LocalString.get("The base classifier to be used.");
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
    }
}

