/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import weka.LocalString;
import weka.core.FastVector;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;

public class HierarchicalBCEngine
implements GraphConstants,
LayoutEngine {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected FastVector layoutCompleteListeners;
    protected int[][] graphMatrix;
    protected int[][] nodeLevels;
    protected int m_nodeWidth;
    protected int m_nodeHeight;
    protected JRadioButton m_jRbNaiveLayout;
    protected JRadioButton m_jRbPriorityLayout;
    protected JRadioButton m_jRbTopdown;
    protected JRadioButton m_jRbBottomup;
    protected JCheckBox m_jCbEdgeConcentration;
    protected JPanel m_controlsPanel;
    protected JProgressBar m_progress;
    protected boolean m_completeReLayout = false;
    private int origNodesSize;

    public HierarchicalBCEngine(FastVector fastVector, FastVector fastVector2, int n, int n2) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
        this.m_nodeWidth = n;
        this.m_nodeHeight = n2;
        this.makeGUIPanel(false);
    }

    public HierarchicalBCEngine(FastVector fastVector, FastVector fastVector2, int n, int n2, boolean bl) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
        this.m_nodeWidth = n;
        this.m_nodeHeight = n2;
        this.makeGUIPanel(bl);
    }

    public HierarchicalBCEngine() {
    }

    protected void makeGUIPanel(boolean bl) {
        this.m_jRbNaiveLayout = new JRadioButton(LocalString.get("Naive Layout"));
        this.m_jRbPriorityLayout = new JRadioButton(LocalString.get("Priority Layout"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jRbNaiveLayout);
        buttonGroup.add(this.m_jRbPriorityLayout);
        this.m_jRbPriorityLayout.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HierarchicalBCEngine.this.m_completeReLayout = true;
            }
        };
        this.m_jRbTopdown = new JRadioButton(LocalString.get("Top Down"));
        this.m_jRbBottomup = new JRadioButton(LocalString.get("Bottom Up"));
        this.m_jRbTopdown.addActionListener(actionListener);
        this.m_jRbBottomup.addActionListener(actionListener);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jRbTopdown);
        buttonGroup.add(this.m_jRbBottomup);
        this.m_jRbBottomup.setSelected(true);
        this.m_jCbEdgeConcentration = new JCheckBox(LocalString.get("With Edge Concentration"), bl);
        this.m_jCbEdgeConcentration.setSelected(bl);
        this.m_jCbEdgeConcentration.addActionListener(actionListener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_jRbNaiveLayout, gridBagConstraints);
        jPanel.add((Component)this.m_jRbPriorityLayout, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(LocalString.get("Layout Type")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.m_jRbTopdown, gridBagConstraints);
        jPanel2.add((Component)this.m_jRbBottomup, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(LocalString.get("Layout Method")));
        this.m_progress = new JProgressBar(0, 11);
        this.m_progress.setBorderPainted(false);
        this.m_progress.setStringPainted(true);
        this.m_progress.setString("");
        this.m_progress.setValue(0);
        this.m_controlsPanel = new JPanel(new GridBagLayout());
        this.m_controlsPanel.add((Component)jPanel, gridBagConstraints);
        this.m_controlsPanel.add((Component)jPanel2, gridBagConstraints);
        this.m_controlsPanel.add((Component)this.m_jCbEdgeConcentration, gridBagConstraints);
    }

    public JPanel getControlPanel() {
        return this.m_controlsPanel;
    }

    public JProgressBar getProgressBar() {
        return this.m_progress;
    }

    public void setNodesEdges(FastVector fastVector, FastVector fastVector2) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
    }

    public void setNodeSize(int n, int n2) {
        this.m_nodeWidth = n;
        this.m_nodeHeight = n2;
    }

    public void addLayoutCompleteEventListener(LayoutCompleteEventListener layoutCompleteEventListener) {
        if (this.layoutCompleteListeners == null) {
            this.layoutCompleteListeners = new FastVector();
        }
        this.layoutCompleteListeners.addElement(layoutCompleteEventListener);
    }

    public void removeLayoutCompleteEventListener(LayoutCompleteEventListener layoutCompleteEventListener) {
        if (this.layoutCompleteListeners != null) {
            for (int i = 0; i < this.layoutCompleteListeners.size(); ++i) {
                LayoutCompleteEventListener layoutCompleteEventListener2 = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                if (layoutCompleteEventListener2 != layoutCompleteEventListener) continue;
                this.layoutCompleteListeners.removeElementAt(i);
                return;
            }
            System.err.println(LocalString.get("layoutCompleteListener to be remove not present"));
        } else {
            System.err.println(LocalString.get("layoutCompleteListener to be remove not present"));
        }
    }

    public void fireLayoutCompleteEvent(LayoutCompleteEvent layoutCompleteEvent) {
        if (this.layoutCompleteListeners != null && this.layoutCompleteListeners.size() != 0) {
            for (int i = 0; i < this.layoutCompleteListeners.size(); ++i) {
                LayoutCompleteEventListener layoutCompleteEventListener = (LayoutCompleteEventListener)this.layoutCompleteListeners.elementAt(i);
                layoutCompleteEventListener.layoutCompleted(layoutCompleteEvent);
            }
        }
    }

    public void layoutGraph() {
        if (this.m_nodes == null || this.m_edges == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                HierarchicalBCEngine.this.m_progress.setBorderPainted(true);
                if (HierarchicalBCEngine.this.nodeLevels == null) {
                    HierarchicalBCEngine.this.makeProperHierarchy();
                } else if (HierarchicalBCEngine.this.m_completeReLayout) {
                    HierarchicalBCEngine.this.clearTemps_and_EdgesFromNodes();
                    HierarchicalBCEngine.this.makeProperHierarchy();
                    HierarchicalBCEngine.this.m_completeReLayout = false;
                }
                if (HierarchicalBCEngine.this.m_jRbTopdown.isSelected()) {
                    int n = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int n2 = 0;
                    int n3 = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(n3 + 4);
                        HierarchicalBCEngine.this.m_progress.setString(LocalString.get("Minimizing Crossings: Pass") + (n3 + 1));
                        if (n3 != 0) {
                            n = n2;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(false, HierarchicalBCEngine.this.nodeLevels);
                    } while ((n2 = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < n && ++n3 < 6);
                } else {
                    int n = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels);
                    int n4 = 0;
                    int n5 = 0;
                    do {
                        HierarchicalBCEngine.this.m_progress.setValue(n5 + 4);
                        HierarchicalBCEngine.this.m_progress.setString(LocalString.get("Minimizing Crossings: Pass") + (n5 + 1));
                        if (n5 != 0) {
                            n = n4;
                        }
                        HierarchicalBCEngine.this.nodeLevels = HierarchicalBCEngine.this.minimizeCrossings(true, HierarchicalBCEngine.this.nodeLevels);
                    } while ((n4 = HierarchicalBCEngine.this.crossings(HierarchicalBCEngine.this.nodeLevels)) < n && ++n5 < 6);
                }
                HierarchicalBCEngine.this.m_progress.setValue(10);
                HierarchicalBCEngine.this.m_progress.setString(LocalString.get("Laying out vertices"));
                if (HierarchicalBCEngine.this.m_jRbNaiveLayout.isSelected()) {
                    HierarchicalBCEngine.this.naiveLayout();
                } else {
                    HierarchicalBCEngine.this.priorityLayout1();
                }
                HierarchicalBCEngine.this.m_progress.setValue(11);
                HierarchicalBCEngine.this.m_progress.setString(LocalString.get("Layout Complete"));
                HierarchicalBCEngine.this.m_progress.repaint();
                HierarchicalBCEngine.this.fireLayoutCompleteEvent(new LayoutCompleteEvent(this));
                HierarchicalBCEngine.this.m_progress.setValue(0);
                HierarchicalBCEngine.this.m_progress.setString("");
                HierarchicalBCEngine.this.m_progress.setBorderPainted(false);
            }
        };
        thread.start();
    }

    protected void clearTemps_and_EdgesFromNodes() {
        int n;
        int n2 = this.m_nodes.size();
        for (n = this.origNodesSize; n < n2; ++n) {
            this.m_nodes.removeElementAt(this.origNodesSize);
        }
        for (n = 0; n < this.m_nodes.size(); ++n) {
            ((GraphNode)this.m_nodes.elementAt((int)n)).edges = null;
        }
        this.nodeLevels = null;
    }

    protected void processGraph() {
        this.origNodesSize = this.m_nodes.size();
        this.graphMatrix = new int[this.m_nodes.size()][this.m_nodes.size()];
        for (int i = 0; i < this.m_edges.size(); ++i) {
            this.graphMatrix[((GraphEdge)this.m_edges.elementAt((int)i)).src][((GraphEdge)this.m_edges.elementAt((int)i)).dest] = ((GraphEdge)this.m_edges.elementAt((int)i)).type;
        }
    }

    protected void makeProperHierarchy() {
        int n;
        int n2;
        int n3;
        int n4;
        this.processGraph();
        this.m_progress.setValue(1);
        this.m_progress.setString(LocalString.get("Removing Cycles"));
        this.removeCycles();
        this.m_progress.setValue(2);
        this.m_progress.setString(LocalString.get("Assigning levels to nodes"));
        int[] nArray = new int[this.m_nodes.size()];
        int n5 = 0;
        for (n4 = 0; n4 < this.graphMatrix.length; ++n4) {
            this.assignLevels(nArray, n5, n4, 0);
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] != 0) continue;
            n3 = 65536;
            for (n2 = 0; n2 < this.graphMatrix[n4].length; ++n2) {
                if (this.graphMatrix[n4][n2] != 1 || n3 <= nArray[n2]) continue;
                n3 = nArray[n2];
            }
            if (n3 == 65536 || n3 <= 1) continue;
            nArray[n4] = n3 - 1;
        }
        n4 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] <= n4) continue;
            n4 = nArray[n3];
        }
        int[] nArray2 = new int[n4 + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n6 = nArray[n2];
            nArray2[n6] = nArray2[n6] + 1;
        }
        int[] nArray3 = new int[n4 + 1];
        this.nodeLevels = new int[n4 + 1][];
        for (n = 0; n < nArray.length; n = (int)((byte)(n + 1))) {
            if (this.nodeLevels[nArray[n]] == null) {
                this.nodeLevels[nArray[n]] = new int[nArray2[nArray[n]]];
            }
            int n7 = nArray[n];
            int n8 = nArray3[n7];
            nArray3[n7] = n8 + 1;
            this.nodeLevels[nArray[n]][n8] = n;
        }
        this.m_progress.setValue(3);
        this.m_progress.setString(LocalString.get("Removing gaps by adding dummy vertices"));
        if (this.m_jCbEdgeConcentration.isSelected()) {
            this.removeGapsWithEdgeConcentration(nArray);
        } else {
            this.removeGaps(nArray);
        }
        for (n = 0; n < this.graphMatrix.length; ++n) {
            int n9;
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n);
            int n10 = 0;
            for (n9 = 0; n9 < this.graphMatrix[n].length; ++n9) {
                if (this.graphMatrix[n][n9] == 0) continue;
                ++n10;
            }
            graphNode.edges = new int[n10][2];
            int n11 = 0;
            for (n9 = 0; n9 < this.graphMatrix[n].length; ++n9) {
                if (this.graphMatrix[n][n9] == 0) continue;
                graphNode.edges[n11][0] = n9;
                graphNode.edges[n11][1] = this.graphMatrix[n][n9];
                ++n11;
            }
        }
    }

    private void removeGaps(int[] nArray) {
        int n = this.m_nodes.size();
        int n2 = this.graphMatrix[0].length;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = this.graphMatrix.length;
                if (this.graphMatrix[i][j] <= 0) continue;
                if (nArray[j] > nArray[i] + 1) {
                    int n5;
                    int[][] nArray2 = new int[this.graphMatrix.length + (nArray[j] - nArray[i] - 1)][this.graphMatrix.length + (nArray[j] - nArray[i] - 1)];
                    int n6 = nArray[i] + 1;
                    this.copyMatrix(this.graphMatrix, nArray2);
                    String string = new String("S" + n3++);
                    this.m_nodes.addElement(new GraphNode(string, string, 1));
                    int[] nArray3 = new int[this.nodeLevels[n6].length + 1];
                    System.arraycopy(this.nodeLevels[n6], 0, nArray3, 0, this.nodeLevels[n6].length);
                    nArray3[nArray3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[n6] = nArray3;
                    ++n6;
                    for (n5 = n4; n5 < n4 + nArray[j] - nArray[i] - 1 - 1; ++n5) {
                        String string2 = new String("S" + n3);
                        this.m_nodes.addElement(new GraphNode(string2, string2, 1));
                        nArray3 = new int[this.nodeLevels[n6].length + 1];
                        System.arraycopy(this.nodeLevels[n6], 0, nArray3, 0, this.nodeLevels[n6].length);
                        nArray3[nArray3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[n6++] = nArray3;
                        nArray2[n5][n5 + 1] = nArray2[i][j];
                        ++n3;
                        if (n5 <= n4) continue;
                        nArray2[n5][n5 - 1] = -1 * nArray2[i][j];
                    }
                    nArray2[n5][j] = nArray2[i][j];
                    nArray2[i][n4] = nArray2[i][j];
                    nArray2[n4][i] = -1 * nArray2[i][j];
                    nArray2[j][n5] = -1 * nArray2[i][j];
                    if (n5 > n4) {
                        nArray2[n5][n5 - 1] = -1 * nArray2[i][j];
                    }
                    nArray2[i][j] = 0;
                    nArray2[j][i] = 0;
                    this.graphMatrix = nArray2;
                    continue;
                }
                this.graphMatrix[j][i] = -1 * this.graphMatrix[i][j];
            }
        }
    }

    private void removeGapsWithEdgeConcentration(int[] nArray) {
        int n = this.m_nodes.size();
        int n2 = this.graphMatrix[0].length;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.graphMatrix[i][j] <= 0) continue;
                if (nArray[j] > nArray[i] + 1) {
                    int n4;
                    boolean bl = false;
                    int n5 = n;
                    int n6 = i;
                    for (int k = nArray[i]; k < nArray[j] - 1; ++k) {
                        bl = false;
                        while (n5 < this.graphMatrix.length) {
                            if (this.graphMatrix[n6][n5] > 0) {
                                bl = true;
                                break;
                            }
                            ++n5;
                        }
                        if (bl) {
                            n6 = n5++;
                            continue;
                        }
                        if (n6 == i) break;
                        n6 = n5 - 1;
                        break;
                    }
                    if (((GraphNode)this.m_nodes.elementAt((int)n6)).nodeType == 1) {
                        ((GraphNode)this.m_nodes.elementAt((int)n6)).nodeType = 2;
                    }
                    if (bl) {
                        this.graphMatrix[n6][j] = this.graphMatrix[i][j];
                        this.graphMatrix[j][n6] = -this.graphMatrix[i][j];
                        this.graphMatrix[i][j] = 0;
                        this.graphMatrix[j][i] = 0;
                        continue;
                    }
                    int n7 = this.graphMatrix.length;
                    int[][] nArray2 = new int[this.graphMatrix.length + (nArray[j] - nArray[n6] - 1)][this.graphMatrix.length + (nArray[j] - nArray[n6] - 1)];
                    int n8 = nArray[n6] + 1;
                    this.copyMatrix(this.graphMatrix, nArray2);
                    String string = new String("S" + n3++);
                    this.m_nodes.addElement(new GraphNode(string, string, 1));
                    int[] nArray3 = new int[this.nodeLevels[n8].length + 1];
                    System.arraycopy(this.nodeLevels[n8], 0, nArray3, 0, this.nodeLevels[n8].length);
                    nArray3[nArray3.length - 1] = this.m_nodes.size() - 1;
                    this.nodeLevels[n8] = nArray3;
                    nArray3 = new int[this.m_nodes.size() + 1];
                    System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                    nArray3[this.m_nodes.size() - 1] = n8++;
                    nArray = nArray3;
                    for (n4 = n7; n4 < n7 + nArray[j] - nArray[n6] - 1 - 1; ++n4) {
                        String string2 = new String("S" + n3++);
                        this.m_nodes.addElement(new GraphNode(string2, string2, 1));
                        nArray3 = new int[this.nodeLevels[n8].length + 1];
                        System.arraycopy(this.nodeLevels[n8], 0, nArray3, 0, this.nodeLevels[n8].length);
                        nArray3[nArray3.length - 1] = this.m_nodes.size() - 1;
                        this.nodeLevels[n8] = nArray3;
                        nArray3 = new int[this.m_nodes.size() + 1];
                        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                        nArray3[this.m_nodes.size() - 1] = n8++;
                        nArray = nArray3;
                        nArray2[n4][n4 + 1] = nArray2[i][j];
                        if (n4 <= n7) continue;
                        nArray2[n4][n4 - 1] = -1 * nArray2[i][j];
                    }
                    nArray2[n4][j] = nArray2[i][j];
                    nArray2[n6][n7] = nArray2[i][j];
                    nArray2[n7][n6] = -1 * nArray2[i][j];
                    nArray2[j][n4] = -1 * nArray2[i][j];
                    if (n4 > n7) {
                        nArray2[n4][n4 - 1] = -1 * nArray2[i][j];
                    }
                    nArray2[i][j] = 0;
                    nArray2[j][i] = 0;
                    this.graphMatrix = nArray2;
                    continue;
                }
                this.graphMatrix[j][i] = -1 * this.graphMatrix[i][j];
            }
        }
    }

    private int indexOfElementInLevel(int n, int[] nArray) throws Exception {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        throw new Exception(LocalString.get("Error. Didn't find element ") + ((GraphNode)this.m_nodes.elementAt((int)n)).ID + LocalString.get(" in level. Inspect code for ") + "weka.gui.graphvisualizer.HierarchicalBCEngine");
    }

    protected int crossings(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            MyList myList = new MyList();
            MyList myList2 = new MyList();
            MyListNode[] myListNodeArray = new MyListNode[this.m_nodes.size()];
            int[] nArray2 = new int[this.m_nodes.size()];
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < nArray[i].length + nArray[i + 1].length; ++j) {
                MyListNode myListNode;
                int n4;
                GraphNode graphNode;
                int n5;
                int n6;
                int n7;
                if (j % 2 == 0 && n2 < nArray[i].length || n3 >= nArray[i + 1].length) {
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    graphNode = (GraphNode)this.m_nodes.elementAt(nArray[i][n2]);
                    if (myListNodeArray[nArray[i][n2]] != null) {
                        MyListNode myListNode2 = new MyListNode(-1);
                        myListNode2.next = myList.first;
                        try {
                            do {
                                myListNode2 = myListNode2.next;
                                if (nArray[i][n2] == myListNode2.n) {
                                    ++n7;
                                    n5 += n6;
                                    myList.remove(myListNode2);
                                    continue;
                                }
                                ++n6;
                            } while (myListNode2 != myListNodeArray[nArray[i][n2]]);
                        }
                        catch (NullPointerException nullPointerException) {
                            System.out.println(LocalString.get("levels[i][uidx]: ") + nArray[i][n2] + LocalString.get(" which is: ") + ((GraphNode)this.m_nodes.elementAt((int)nArray[i][n2])).ID + LocalString.get(" temp: ") + myListNode2 + LocalString.get(" upper.first: ") + myList.first);
                            nullPointerException.printStackTrace();
                            System.exit(-1);
                        }
                        myListNodeArray[nArray[i][n2]] = null;
                        n = n + n7 * myList2.size() + n5;
                    }
                    for (n4 = 0; n4 < graphNode.edges.length; ++n4) {
                        if (graphNode.edges[n4][1] <= 0) continue;
                        try {
                            if (this.indexOfElementInLevel(graphNode.edges[n4][0], nArray[i + 1]) < n2) continue;
                            nArray2[graphNode.edges[n4][0]] = 1;
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    for (n4 = 0; n4 < nArray[i + 1].length; ++n4) {
                        if (nArray2[nArray[i + 1][n4]] != 1) continue;
                        myListNode = new MyListNode(nArray[i + 1][n4]);
                        myList2.add(myListNode);
                        myListNodeArray[nArray[i + 1][n4]] = myListNode;
                        nArray2[nArray[i + 1][n4]] = 0;
                    }
                    ++n2;
                    continue;
                }
                n7 = 0;
                n6 = 0;
                n5 = 0;
                graphNode = (GraphNode)this.m_nodes.elementAt(nArray[i + 1][n3]);
                if (myListNodeArray[nArray[i + 1][n3]] != null) {
                    MyListNode myListNode3 = new MyListNode(-1);
                    myListNode3.next = myList2.first;
                    try {
                        do {
                            myListNode3 = myListNode3.next;
                            if (nArray[i + 1][n3] == myListNode3.n) {
                                ++n7;
                                n5 += n6;
                                myList2.remove(myListNode3);
                                continue;
                            }
                            ++n6;
                        } while (myListNode3 != myListNodeArray[nArray[i + 1][n3]]);
                    }
                    catch (NullPointerException nullPointerException) {
                        System.out.print(LocalString.get("levels[i+1][lidx]: ") + nArray[i + 1][n3] + LocalString.get(" which is: ") + ((GraphNode)this.m_nodes.elementAt((int)nArray[i + 1][n3])).ID + LocalString.get(" temp: ") + myListNode3);
                        System.out.println(LocalString.get(" lower.first: ") + myList2.first);
                        nullPointerException.printStackTrace();
                        System.exit(-1);
                    }
                    myListNodeArray[nArray[i + 1][n3]] = null;
                    n = n + n7 * myList.size() + n5;
                }
                for (n4 = 0; n4 < graphNode.edges.length; ++n4) {
                    if (graphNode.edges[n4][1] >= 0) continue;
                    try {
                        if (this.indexOfElementInLevel(graphNode.edges[n4][0], nArray[i]) <= n3) continue;
                        nArray2[graphNode.edges[n4][0]] = 1;
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                for (n4 = 0; n4 < nArray[i].length; ++n4) {
                    if (nArray2[nArray[i][n4]] != 1) continue;
                    myListNode = new MyListNode(nArray[i][n4]);
                    myList.add(myListNode);
                    myListNodeArray[nArray[i][n4]] = myListNode;
                    nArray2[nArray[i][n4]] = 0;
                }
                ++n3;
            }
        }
        return n;
    }

    protected void removeCycles() {
        int[] nArray = new int[this.m_nodes.size()];
        for (int i = 0; i < this.graphMatrix.length; ++i) {
            if (nArray[i] != 0) continue;
            this.removeCycles2(i, nArray);
            nArray[i] = 1;
        }
    }

    private void removeCycles2(int n, int[] nArray) {
        nArray[n] = 2;
        for (int i = 0; i < this.graphMatrix[n].length; ++i) {
            if (this.graphMatrix[n][i] != 1) continue;
            if (nArray[i] == 0) {
                this.removeCycles2(i, nArray);
                nArray[i] = 1;
                continue;
            }
            if (nArray[i] != 2) continue;
            if (n == i) {
                this.graphMatrix[n][i] = 0;
                continue;
            }
            if (this.graphMatrix[i][n] == 1) {
                this.graphMatrix[i][n] = 3;
                this.graphMatrix[n][i] = -3;
                continue;
            }
            this.graphMatrix[i][n] = 2;
            this.graphMatrix[n][i] = -2;
        }
    }

    protected void assignLevels(int[] nArray, int n, int n2, int n3) {
        if (n2 >= this.graphMatrix.length) {
            return;
        }
        if (n3 >= this.graphMatrix[n2].length) {
            return;
        }
        if (this.graphMatrix[n2][n3] <= 0) {
            this.assignLevels(nArray, n, n2, ++n3);
        } else if (this.graphMatrix[n2][n3] == 1 || this.graphMatrix[n2][n3] == 3) {
            if (n + 1 > nArray[n3]) {
                nArray[n3] = n + 1;
                this.assignLevels(nArray, n + 1, n3, 0);
            }
            this.assignLevels(nArray, n, n2, ++n3);
        }
    }

    private int[][] minimizeCrossings(boolean bl, int[][] object) {
        if (!bl) {
            for (int i = 0; i < 1; ++i) {
                int n;
                int[][] nArrayArray = new int[((int[][])object).length][];
                this.copy2DArray((int[][])object, nArrayArray);
                for (n = 0; n < ((int[][])object).length - 1; ++n) {
                    this.phaseID(n, nArrayArray);
                }
                if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                    object = nArrayArray;
                }
                nArrayArray = new int[((int[][])object).length][];
                this.copy2DArray((int[][])object, nArrayArray);
                for (n = ((int[][])object).length - 2; n >= 0; --n) {
                    this.phaseIU(n, nArrayArray);
                }
                if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                    object = nArrayArray;
                }
                nArrayArray = new int[((int[][])object).length][];
                this.copy2DArray((int[][])object, nArrayArray);
                for (n = 0; n < ((int[][])object).length - 1; ++n) {
                    this.phaseIID(n, nArrayArray);
                }
                if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                    object = nArrayArray;
                }
                nArrayArray = new int[((int[][])object).length][];
                this.copy2DArray((int[][])object, nArrayArray);
                for (n = ((int[][])object).length - 2; n >= 0; --n) {
                    this.phaseIIU(n, nArrayArray);
                }
                if (this.crossings(nArrayArray) >= this.crossings((int[][])object)) continue;
                object = nArrayArray;
            }
            return object;
        }
        for (int i = 0; i < 1; ++i) {
            int n;
            int[][] nArrayArray = new int[((int[][])object).length][];
            this.copy2DArray((int[][])object, nArrayArray);
            for (n = ((int[][])object).length - 2; n >= 0; --n) {
                this.phaseIU(n, nArrayArray);
            }
            if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                object = nArrayArray;
            }
            nArrayArray = new int[((int[][])object).length][];
            this.copy2DArray((int[][])object, nArrayArray);
            for (n = 0; n < ((int[][])object).length - 1; ++n) {
                this.phaseID(n, nArrayArray);
            }
            if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                object = nArrayArray;
            }
            nArrayArray = new int[((int[][])object).length][];
            this.copy2DArray((int[][])object, nArrayArray);
            for (n = ((int[][])object).length - 2; n >= 0; --n) {
                this.phaseIIU(n, nArrayArray);
            }
            if (this.crossings(nArrayArray) < this.crossings((int[][])object)) {
                object = nArrayArray;
            }
            nArrayArray = new int[((int[][])object).length][];
            this.copy2DArray((int[][])object, nArrayArray);
            for (n = 0; n < ((int[][])object).length - 1; ++n) {
                this.phaseIID(n, nArrayArray);
            }
            if (this.crossings(nArrayArray) >= this.crossings((int[][])object)) continue;
            object = nArrayArray;
        }
        return object;
    }

    protected void phaseID(int n, int[][] nArray) {
        float[] fArray = this.calcColBC(n, nArray);
        HierarchicalBCEngine.isort(nArray[n + 1], fArray);
    }

    public void phaseIU(int n, int[][] nArray) {
        float[] fArray = this.calcRowBC(n, nArray);
        HierarchicalBCEngine.isort(nArray[n], fArray);
    }

    public void phaseIID(int n, int[][] nArray) {
        float[] fArray = this.calcColBC(n, nArray);
        for (int i = 0; i < fArray.length - 1; ++i) {
            int n2;
            if (fArray[i] != fArray[i + 1]) continue;
            int[][] nArrayArray = new int[nArray.length][];
            this.copy2DArray(nArray, nArrayArray);
            int n3 = nArray[n + 1][i];
            int n4 = nArray[n + 1][i + 1];
            nArray[n + 1][i + 1] = n3;
            nArray[n + 1][i] = n4;
            for (n2 = n + 1; n2 < nArray.length - 1; ++n2) {
                this.phaseID(n2, nArray);
            }
            if (this.crossings(nArray) <= this.crossings(nArrayArray)) {
                this.copy2DArray(nArray, nArrayArray);
            } else {
                this.copy2DArray(nArrayArray, nArray);
                nArray[n + 1][i + 1] = n3;
                nArray[n + 1][i] = n4;
            }
            for (n2 = nArray.length - 2; n2 >= 0; --n2) {
                this.phaseIU(n2, nArray);
            }
            if (this.crossings(nArrayArray) >= this.crossings(nArray)) continue;
            this.copy2DArray(nArrayArray, nArray);
        }
    }

    public void phaseIIU(int n, int[][] nArray) {
        float[] fArray = this.calcRowBC(n, nArray);
        for (int i = 0; i < fArray.length - 1; ++i) {
            int n2;
            if (fArray[i] != fArray[i + 1]) continue;
            int[][] nArrayArray = new int[nArray.length][];
            this.copy2DArray(nArray, nArrayArray);
            int n3 = nArray[n][i];
            int n4 = nArray[n][i + 1];
            nArray[n][i + 1] = n3;
            nArray[n][i] = n4;
            for (n2 = n - 1; n2 >= 0; --n2) {
                this.phaseIU(n2, nArray);
            }
            if (this.crossings(nArray) <= this.crossings(nArrayArray)) {
                this.copy2DArray(nArray, nArrayArray);
            } else {
                this.copy2DArray(nArrayArray, nArray);
                nArray[n][i + 1] = n3;
                nArray[n][i] = n4;
            }
            for (n2 = 0; n2 < nArray.length - 1; ++n2) {
                this.phaseID(n2, nArray);
            }
            if (this.crossings(nArrayArray) > this.crossings(nArray)) continue;
            this.copy2DArray(nArrayArray, nArray);
        }
    }

    protected float[] calcRowBC(int n, int[][] nArray) {
        float[] fArray = new float[nArray[n].length];
        for (int i = 0; i < nArray[n].length; ++i) {
            int n2 = 0;
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(nArray[n][i]);
            for (int j = 0; j < graphNode.edges.length; ++j) {
                if (graphNode.edges[j][1] <= 0) continue;
                ++n2;
                try {
                    fArray[i] = fArray[i] + (float)this.indexOfElementInLevel(graphNode.edges[j][0], nArray[n + 1]) + 1.0f;
                    continue;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (fArray[i] == 0.0f) continue;
            fArray[i] = fArray[i] / (float)n2;
        }
        return fArray;
    }

    protected float[] calcColBC(int n, int[][] nArray) {
        float[] fArray = new float[nArray[n + 1].length];
        for (int i = 0; i < nArray[n + 1].length; ++i) {
            int n2 = 0;
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(nArray[n + 1][i]);
            for (int j = 0; j < graphNode.edges.length; ++j) {
                if (graphNode.edges[j][1] >= 1) continue;
                ++n2;
                try {
                    fArray[i] = fArray[i] + (float)this.indexOfElementInLevel(graphNode.edges[j][0], nArray[n]) + 1.0f;
                    continue;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (fArray[i] == 0.0f) continue;
            fArray[i] = fArray[i] / (float)n2;
        }
        return fArray;
    }

    protected void printMatrices(int[][] nArray) {
        int n = 0;
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2;
            float[] fArray = null;
            float[] fArray2 = null;
            try {
                fArray = this.calcRowBC(n, nArray);
                fArray2 = this.calcColBC(n, nArray);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("i: " + n + LocalString.get(" levels.length: ") + nArray.length);
                nullPointerException.printStackTrace();
                return;
            }
            System.out.print("\nM" + (n + 1) + "\t");
            for (n2 = 0; n2 < nArray[n + 1].length; ++n2) {
                System.out.print(((GraphNode)this.m_nodes.elementAt((int)nArray[n + 1][n2])).ID + " ");
            }
            System.out.println("");
            for (n2 = 0; n2 < nArray[n].length; ++n2) {
                System.out.print(((GraphNode)this.m_nodes.elementAt((int)nArray[n][n2])).ID + "\t");
                for (int i = 0; i < nArray[n + 1].length; ++i) {
                    System.out.print(this.graphMatrix[nArray[n][n2]][nArray[n + 1][i]] + " ");
                }
                System.out.println(fArray[n2]);
            }
            System.out.print("\t");
            for (n2 = 0; n2 < nArray[n + 1].length; ++n2) {
                System.out.print(fArray2[n2] + " ");
            }
        }
        System.out.println(LocalString.get("\nAt the end i: ") + n + LocalString.get(" levels.length: ") + nArray.length);
    }

    protected static void isort(int[] nArray, float[] fArray) {
        for (int i = 0; i < fArray.length - 1; ++i) {
            int n = i;
            float f = fArray[n + 1];
            int n2 = nArray[n + 1];
            if (f == 0.0f) continue;
            int n3 = n + 1;
            while (n > -1 && (f < fArray[n] || fArray[n] == 0.0f)) {
                if (fArray[n] == 0.0f) {
                    --n;
                    continue;
                }
                fArray[n3] = fArray[n];
                nArray[n3] = nArray[n];
                n3 = n--;
            }
            fArray[n3] = f;
            nArray[n3] = n2;
        }
    }

    protected void copyMatrix(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
    }

    protected void copy2DArray(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = new int[nArray[i].length];
            System.arraycopy(nArray[i], 0, nArray2[i], 0, nArray[i].length);
        }
    }

    protected void naiveLayout() {
        if (this.nodeLevels == null) {
            this.makeProperHierarchy();
        }
        int n = 0;
        for (int i = 0; i < this.nodeLevels.length; ++i) {
            for (int j = 0; j < this.nodeLevels[i].length; ++j) {
                n = this.nodeLevels[i][j];
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n);
                graphNode.x = j * this.m_nodeWidth;
                graphNode.y = i * 3 * this.m_nodeHeight;
            }
        }
    }

    protected int uConnectivity(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.nodeLevels[n - 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[n - 1][i]][this.nodeLevels[n][n2]] <= 0) continue;
            ++n3;
        }
        return n3;
    }

    protected int lConnectivity(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.nodeLevels[n + 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[n][n2]][this.nodeLevels[n + 1][i]] <= 0) continue;
            ++n3;
        }
        return n3;
    }

    protected int uBCenter(int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = 0; i < this.nodeLevels[n - 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[n - 1][i]][this.nodeLevels[n][n2]] <= 0) continue;
            n3 += nArray[this.nodeLevels[n - 1][i]];
        }
        if (n3 != 0) {
            n3 /= this.uConnectivity(n, n2);
        }
        return n3;
    }

    protected int lBCenter(int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = 0; i < this.nodeLevels[n + 1].length; ++i) {
            if (this.graphMatrix[this.nodeLevels[n][n2]][this.nodeLevels[n + 1][i]] <= 0) continue;
            n3 += nArray[this.nodeLevels[n + 1][i]];
        }
        if (n3 != 0) {
            n3 /= this.lConnectivity(n, n2);
        }
        return n3;
    }

    private void tempMethod(int[] nArray) {
        int n;
        int n2 = nArray[0];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= n2) continue;
            n2 = nArray[n];
        }
        if (n2 < 0) {
            n2 *= -1;
            n = 0;
            while (n < nArray.length) {
                int n3 = n++;
                nArray[n3] = nArray[n3] + n2;
            }
        }
        int n4 = 0;
        for (n = 0; n < this.nodeLevels.length; ++n) {
            for (int i = 0; i < this.nodeLevels[n].length; ++i) {
                n4 = this.nodeLevels[n][i];
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n4);
                graphNode.x = nArray[n4] * this.m_nodeWidth;
                graphNode.y = n * 3 * this.m_nodeHeight;
            }
        }
    }

    protected void priorityLayout1() {
        int n;
        int n2;
        int[] nArray = new int[this.m_nodes.size()];
        int n3 = 0;
        for (int i = 0; i < this.nodeLevels.length; ++i) {
            int n4 = 0;
            for (n2 = 0; n2 < this.nodeLevels[i].length; ++n2) {
                nArray[this.nodeLevels[i][n2]] = n2;
                ++n4;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        for (n2 = 1; n2 < this.nodeLevels.length; ++n2) {
            int[] nArray2 = new int[this.nodeLevels[n2].length];
            int[] nArray3 = new int[this.nodeLevels[n2].length];
            for (n = 0; n < this.nodeLevels[n2].length; ++n) {
                nArray2[n] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[n2][n])).ID.startsWith("S") ? n3 + 1 : this.uConnectivity(n2, n);
                nArray3[n] = this.uBCenter(n2, n, nArray);
            }
            this.priorityLayout2(this.nodeLevels[n2], nArray2, nArray3, nArray);
        }
        for (n2 = this.nodeLevels.length - 2; n2 >= 0; --n2) {
            int[] nArray4 = new int[this.nodeLevels[n2].length];
            int[] nArray5 = new int[this.nodeLevels[n2].length];
            for (n = 0; n < this.nodeLevels[n2].length; ++n) {
                nArray4[n] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[n2][n])).ID.startsWith("S") ? n3 + 1 : this.lConnectivity(n2, n);
                nArray5[n] = this.lBCenter(n2, n, nArray);
            }
            this.priorityLayout2(this.nodeLevels[n2], nArray4, nArray5, nArray);
        }
        for (n2 = 2; n2 < this.nodeLevels.length; ++n2) {
            int[] nArray6 = new int[this.nodeLevels[n2].length];
            int[] nArray7 = new int[this.nodeLevels[n2].length];
            for (n = 0; n < this.nodeLevels[n2].length; ++n) {
                nArray6[n] = ((GraphNode)this.m_nodes.elementAt((int)this.nodeLevels[n2][n])).ID.startsWith("S") ? n3 + 1 : this.uConnectivity(n2, n);
                nArray7[n] = this.uBCenter(n2, n, nArray);
            }
            this.priorityLayout2(this.nodeLevels[n2], nArray6, nArray7, nArray);
        }
        n2 = nArray[0];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= n2) continue;
            n2 = nArray[n];
        }
        if (n2 < 0) {
            n2 *= -1;
            n = 0;
            while (n < nArray.length) {
                int n5 = n++;
                nArray[n5] = nArray[n5] + n2;
            }
        }
        int n6 = 0;
        for (n = 0; n < this.nodeLevels.length; ++n) {
            for (int i = 0; i < this.nodeLevels[n].length; ++i) {
                n6 = this.nodeLevels[n][i];
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n6);
                graphNode.x = nArray[n6] * this.m_nodeWidth;
                graphNode.y = n * 3 * this.m_nodeHeight;
            }
        }
    }

    private void priorityLayout2(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        int n2;
        int n3;
        int[] nArray5 = new int[nArray2.length];
        nArray5[0] = 0;
        for (n3 = 0; n3 < nArray2.length - 1; ++n3) {
            n2 = n3 + 1;
            for (n = n3; n > -1 && nArray2[nArray5[n]] < nArray2[n2]; --n) {
                nArray5[n + 1] = nArray5[n];
            }
            nArray5[++n] = n2;
        }
        for (n3 = 0; n3 < nArray5.length; ++n3) {
            block3: for (n = 0; n < nArray5.length; ++n) {
                int n4;
                n2 = 0;
                int n5 = 0;
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    if (nArray4[nArray[nArray5[n]]] > nArray4[nArray[n4]]) {
                        ++n2;
                        continue;
                    }
                    if (nArray4[nArray[nArray5[n]]] >= nArray4[nArray[n4]]) continue;
                    ++n5;
                }
                int[] nArray6 = new int[n2];
                int[] nArray7 = new int[n5];
                int n6 = 0;
                int n7 = 0;
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    if (nArray4[nArray[nArray5[n]]] > nArray4[nArray[n4]]) {
                        nArray6[n6++] = n4;
                        continue;
                    }
                    if (nArray4[nArray[nArray5[n]]] >= nArray4[nArray[n4]]) continue;
                    nArray7[n7++] = n4;
                }
                while (Math.abs(nArray4[nArray[nArray5[n]]] - 1 - nArray3[nArray5[n]]) < Math.abs(nArray4[nArray[nArray5[n]]] - nArray3[nArray5[n]])) {
                    n4 = nArray4[nArray[nArray5[n]]];
                    n6 = 0;
                    for (n7 = nArray6.length - 1; n7 >= 0 && n4 - nArray4[nArray[nArray6[n7]]] <= 1; --n7) {
                        if (nArray2[nArray5[n]] <= nArray2[nArray6[n7]]) {
                            n6 = 1;
                            break;
                        }
                        n4 = nArray4[nArray[nArray6[n7]]];
                    }
                    if (n6 != 0) break;
                    n4 = nArray4[nArray[nArray5[n]]] - 1;
                    for (n7 = nArray6.length - 1; n7 >= 0; --n7) {
                        if (n4 != nArray4[nArray[nArray6[n7]]]) continue;
                        nArray4[nArray[nArray6[n7]]] = n4 = nArray4[nArray[nArray6[n7]]] - 1;
                    }
                    nArray4[nArray[nArray5[n]]] = nArray4[nArray[nArray5[n]]] - 1;
                }
                while (Math.abs(nArray4[nArray[nArray5[n]]] + 1 - nArray3[nArray5[n]]) < Math.abs(nArray4[nArray[nArray5[n]]] - nArray3[nArray5[n]])) {
                    n4 = nArray4[nArray[nArray5[n]]];
                    n6 = 0;
                    for (n7 = 0; n7 < nArray7.length && nArray4[nArray[nArray7[n7]]] - n4 <= 1; ++n7) {
                        if (nArray2[nArray5[n]] <= nArray2[nArray7[n7]]) {
                            n6 = 1;
                            break;
                        }
                        n4 = nArray4[nArray[nArray7[n7]]];
                    }
                    if (n6 != 0) continue block3;
                    n4 = nArray4[nArray[nArray5[n]]] + 1;
                    for (n7 = 0; n7 < nArray7.length; ++n7) {
                        if (n4 != nArray4[nArray[nArray7[n7]]]) continue;
                        nArray4[nArray[nArray7[n7]]] = n4 = nArray4[nArray[nArray7[n7]]] + 1;
                    }
                    nArray4[nArray[nArray5[n]]] = nArray4[nArray[nArray5[n]]] + 1;
                }
            }
        }
    }

    private class MyListNode {
        int n;
        MyListNode next;
        MyListNode previous;

        public MyListNode(int n) {
            this.n = n;
            this.next = null;
            this.previous = null;
        }
    }

    private class MyList {
        int size;
        MyListNode first = null;
        MyListNode last = null;

        private MyList() {
        }

        public void add(int n) {
            if (this.first == null) {
                this.first = this.last = new MyListNode(n);
            } else if (this.last.next == null) {
                this.last.next = new MyListNode(n);
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                System.err.println(LocalString.get("Error shouldn't be in here. Check MyList code"));
                --this.size;
            }
            ++this.size;
        }

        public void add(MyListNode myListNode) {
            if (this.first == null) {
                this.first = this.last = myListNode;
            } else if (this.last.next == null) {
                this.last.next = myListNode;
                this.last.next.previous = this.last;
                this.last = this.last.next;
            } else {
                System.err.println(LocalString.get("Error shouldn't be in here. Check MyList code"));
                --this.size;
            }
            ++this.size;
        }

        public void remove(MyListNode myListNode) {
            if (myListNode.previous != null) {
                myListNode.previous.next = myListNode.next;
            }
            if (myListNode.next != null) {
                myListNode.next.previous = myListNode.previous;
            }
            if (this.last == myListNode) {
                this.last = myListNode.previous;
            }
            if (this.first == myListNode) {
                this.first = myListNode.next;
            }
            --this.size;
        }

        public void remove(int n) {
            MyListNode myListNode = this.first;
            while (myListNode != null && myListNode.n != n) {
                myListNode = myListNode.next;
            }
            if (myListNode == null) {
                System.err.println(LocalString.get("element ") + n + LocalString.get("not present in the list"));
                return;
            }
            if (myListNode.previous != null) {
                myListNode.previous.next = myListNode.next;
            }
            if (myListNode.next != null) {
                myListNode.next.previous = myListNode.previous;
            }
            if (this.last == myListNode) {
                this.last = myListNode.previous;
            }
            if (this.first == myListNode) {
                this.first = myListNode.next;
            }
            --this.size;
        }

        public int size() {
            return this.size;
        }
    }
}

