/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Comparator;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class InstanceComparator
implements Comparator,
Serializable {
    protected boolean m_IncludeClass;

    public InstanceComparator() {
        this(true);
    }

    public InstanceComparator(boolean bl) {
        this.setIncludeClass(bl);
    }

    public void setIncludeClass(boolean bl) {
        this.m_IncludeClass = bl;
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public int compare(Object object, Object object2) {
        Instance instance = (Instance)object;
        Instance instance2 = (Instance)object2;
        int n = instance.classIndex() == -1 ? instance.numAttributes() - 1 : instance.classIndex();
        int n2 = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (!this.getIncludeClass() && i == n) continue;
            if (instance.isMissing(i) || instance2.isMissing(i)) {
                if (instance.isMissing(i) && instance2.isMissing(i)) continue;
                if (instance.isMissing(i)) {
                    n2 = -1;
                    break;
                }
                n2 = 1;
                break;
            }
            if (Utils.eq(instance.value(i), instance2.value(i))) continue;
            if (instance.value(i) < instance2.value(i)) {
                n2 = -1;
                break;
            }
            n2 = 1;
            break;
        }
        return n2;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            return;
        }
        Instances instances = new Instances(new BufferedReader(new FileReader(stringArray[0])));
        instances.setClassIndex(instances.numAttributes() - 1);
        InstanceComparator instanceComparator = new InstanceComparator();
        System.out.println(LocalString.get("\nIncluding the class"));
        System.out.println(LocalString.get("comparing 1. instance with 1.: ") + instanceComparator.compare(instances.instance(0), instances.instance(0)));
        System.out.println(LocalString.get("comparing 1. instance with 2.: ") + instanceComparator.compare(instances.instance(0), instances.instance(1)));
        System.out.println(LocalString.get("comparing 2. instance with 1.: ") + instanceComparator.compare(instances.instance(1), instances.instance(0)));
        instanceComparator = new InstanceComparator(false);
        System.out.println(LocalString.get("\nExcluding the class"));
        System.out.println(LocalString.get("comparing 1. instance with 1.: ") + instanceComparator.compare(instances.instance(0), instances.instance(0)));
        System.out.println(LocalString.get("comparing 1. instance with 2.: ") + instanceComparator.compare(instances.instance(0), instances.instance(1)));
        System.out.println(LocalString.get("comparing 2. instance with 1.: ") + instanceComparator.compare(instances.instance(1), instances.instance(0)));
    }
}

