/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.neural.LinearUnit;
import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralNode;
import weka.classifiers.functions.neural.SigmoidUnit;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;

public class MultilayerPerceptron
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    private Instances m_instances = null;
    private Instance m_currentInstance = null;
    private boolean m_numeric = false;
    private double[] m_attributeRanges;
    private double[] m_attributeBases;
    private NeuralEnd[] m_outputs = new NeuralEnd[0];
    private NeuralEnd[] m_inputs = new NeuralEnd[0];
    private NeuralConnection[] m_neuralNodes = new NeuralConnection[0];
    private int m_numClasses = 0;
    private int m_numAttributes = 0;
    private NodePanel m_nodePanel = null;
    private ControlPanel m_controlPanel = null;
    private int m_nextId = 0;
    private FastVector m_selected = new FastVector(4);
    private FastVector m_graphers = new FastVector(2);
    private int m_numEpochs = 500;
    private boolean m_stopIt = true;
    private boolean m_stopped = true;
    private boolean m_accepted = false;
    private JFrame m_win;
    private boolean m_autoBuild = true;
    private boolean m_gui = false;
    private int m_valSize = 0;
    private int m_driftThreshold = 20;
    private long m_randomSeed = 0L;
    private Random m_random = null;
    private boolean m_useNomToBin = true;
    private NominalToBinary m_nominalToBinaryFilter = new NominalToBinary();
    private String m_hiddenLayers = "a";
    private boolean m_normalizeAttributes = true;
    private boolean m_decay = false;
    private double m_learningRate = 0.3;
    private double m_momentum = 0.2;
    private int m_epoch = 0;
    private double m_error = 0.0;
    private boolean m_reset = true;
    private boolean m_normalizeClass = true;
    private SigmoidUnit m_sigmoidUnit = new SigmoidUnit();
    private LinearUnit m_linearUnit = new LinearUnit();

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new MultilayerPerceptron(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public void setDecay(boolean bl) {
        this.m_decay = bl;
    }

    public boolean getDecay() {
        return this.m_decay;
    }

    public void setReset(boolean bl) {
        if (this.m_gui) {
            bl = false;
        }
        this.m_reset = bl;
    }

    public boolean getReset() {
        return this.m_reset;
    }

    public void setNormalizeNumericClass(boolean bl) {
        this.m_normalizeClass = bl;
    }

    public boolean getNormalizeNumericClass() {
        return this.m_normalizeClass;
    }

    public void setNormalizeAttributes(boolean bl) {
        this.m_normalizeAttributes = bl;
    }

    public boolean getNormalizeAttributes() {
        return this.m_normalizeAttributes;
    }

    public void setNominalToBinaryFilter(boolean bl) {
        this.m_useNomToBin = bl;
    }

    public boolean getNominalToBinaryFilter() {
        return this.m_useNomToBin;
    }

    public void setRandomSeed(long l) {
        if (l >= 0L) {
            this.m_randomSeed = l;
        }
    }

    public long getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setValidationThreshold(int n) {
        if (n > 0) {
            this.m_driftThreshold = n;
        }
    }

    public int getValidationThreshold() {
        return this.m_driftThreshold;
    }

    public void setLearningRate(double d) {
        if (d > 0.0 && d <= 1.0) {
            this.m_learningRate = d;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeLearning.setText("" + d);
            }
        }
    }

    public double getLearningRate() {
        return this.m_learningRate;
    }

    public void setMomentum(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.m_momentum = d;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeMomentum.setText("" + d);
            }
        }
    }

    public double getMomentum() {
        return this.m_momentum;
    }

    public void setAutoBuild(boolean bl) {
        if (!this.m_gui) {
            bl = true;
        }
        this.m_autoBuild = bl;
    }

    public boolean getAutoBuild() {
        return this.m_autoBuild;
    }

    public void setHiddenLayers(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 0) {
            return;
        }
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("a") || string3.equals("i") || string3.equals("o") || string3.equals("t")) {
                string2 = string2 + string3;
            } else {
                double d = Double.valueOf(string3);
                int n = (int)d;
                if ((double)n == d && (n != 0 || stringTokenizer.countTokens() == 0 && bl) && n >= 0) {
                    string2 = string2 + n;
                } else {
                    return;
                }
            }
            bl = false;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + ", ";
        }
        this.m_hiddenLayers = string2;
    }

    public String getHiddenLayers() {
        return this.m_hiddenLayers;
    }

    public void setGUI(boolean bl) {
        this.m_gui = bl;
        if (!bl) {
            this.setAutoBuild(true);
        } else {
            this.setReset(false);
        }
    }

    public boolean getGUI() {
        return this.m_gui;
    }

    public void setValidationSetSize(int n) {
        if (n < 0 || n > 99) {
            return;
        }
        this.m_valSize = n;
    }

    public int getValidationSetSize() {
        return this.m_valSize;
    }

    public void setTrainingTime(int n) {
        if (n > 0) {
            this.m_numEpochs = n;
        }
    }

    public int getTrainingTime() {
        return this.m_numEpochs;
    }

    private void addNode(NeuralConnection neuralConnection) {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_neuralNodes.length + 1];
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            neuralConnectionArray[i] = this.m_neuralNodes[i];
        }
        neuralConnectionArray[neuralConnectionArray.length - 1] = neuralConnection;
        this.m_neuralNodes = neuralConnectionArray;
    }

    private boolean removeNode(NeuralConnection neuralConnection) {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_neuralNodes.length - 1];
        int n = 0;
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            if (neuralConnection == this.m_neuralNodes[i]) {
                ++n;
                continue;
            }
            if (i - n < neuralConnectionArray.length) {
                neuralConnectionArray[i - n] = this.m_neuralNodes[i];
                continue;
            }
            return false;
        }
        this.m_neuralNodes = neuralConnectionArray;
        return true;
    }

    private Instances setClassType(Instances instances) throws Exception {
        if (instances != null) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            this.m_attributeRanges = new double[instances.numAttributes()];
            this.m_attributeBases = new double[instances.numAttributes()];
            for (int i = 0; i < instances.numAttributes(); ++i) {
                int n;
                d = Double.POSITIVE_INFINITY;
                d2 = Double.NEGATIVE_INFINITY;
                for (n = 0; n < instances.numInstances(); ++n) {
                    if (instances.instance(n).isMissing(i)) continue;
                    double d3 = instances.instance(n).value(i);
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
                this.m_attributeRanges[i] = (d2 - d) / 2.0;
                this.m_attributeBases[i] = (d2 + d) / 2.0;
                if (i == instances.classIndex() || !this.m_normalizeAttributes) continue;
                for (n = 0; n < instances.numInstances(); ++n) {
                    if (this.m_attributeRanges[i] != 0.0) {
                        instances.instance(n).setValue(i, (instances.instance(n).value(i) - this.m_attributeBases[i]) / this.m_attributeRanges[i]);
                        continue;
                    }
                    instances.instance(n).setValue(i, instances.instance(n).value(i) - this.m_attributeBases[i]);
                }
            }
            this.m_numeric = instances.classAttribute().isNumeric();
        }
        return instances;
    }

    public synchronized void blocker(boolean bl) {
        if (bl) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    private void updateDisplay() {
        if (this.m_gui) {
            this.m_controlPanel.m_errorLabel.repaint();
            this.m_controlPanel.m_epochsLabel.repaint();
        }
    }

    private void resetNetwork() {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].reset();
        }
    }

    private void calculateOutputs() {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].outputValue(true);
        }
    }

    private double calculateErrors() throws Exception {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.m_numAttributes; ++n) {
            this.m_inputs[n].errorValue(true);
        }
        for (n = 0; n < this.m_numClasses; ++n) {
            d2 = this.m_outputs[n].errorValue(false);
            d += d2 * d2;
        }
        return d;
    }

    private void updateNetworkWeights(double d, double d2) {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].updateWeights(d, d2);
        }
    }

    private void setupInputs() throws Exception {
        this.m_inputs = new NeuralEnd[this.m_numAttributes];
        int n = 0;
        for (int i = 0; i < this.m_numAttributes + 1; ++i) {
            if (this.m_instances.classIndex() != i) {
                this.m_inputs[i - n] = new NeuralEnd(this.m_instances.attribute(i).name());
                this.m_inputs[i - n].setX(0.1);
                this.m_inputs[i - n].setY(((double)(i - n) + 1.0) / (double)(this.m_numAttributes + 1));
                this.m_inputs[i - n].setLink(true, i);
                continue;
            }
            n = 1;
        }
    }

    private void setupOutputs() throws Exception {
        this.m_outputs = new NeuralEnd[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i] = this.m_numeric ? new NeuralEnd(this.m_instances.classAttribute().name()) : new NeuralEnd(this.m_instances.classAttribute().value(i));
            this.m_outputs[i].setX(0.9);
            this.m_outputs[i].setY(((double)i + 1.0) / (double)(this.m_numClasses + 1));
            this.m_outputs[i].setLink(false, i);
            NeuralNode neuralNode = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
            ++this.m_nextId;
            neuralNode.setX(0.75);
            neuralNode.setY(((double)i + 1.0) / (double)(this.m_numClasses + 1));
            this.addNode(neuralNode);
            NeuralConnection.connect(neuralNode, this.m_outputs[i]);
        }
    }

    private void setupHiddenLayer() {
        int n;
        String string;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_hiddenLayers, ",");
        int n3 = 0;
        int n4 = 0;
        int n5 = stringTokenizer.countTokens();
        for (n2 = 0; n2 < n5; ++n2) {
            string = stringTokenizer.nextToken().trim();
            n3 = string.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (string.equals("i") ? this.m_numAttributes : (string.equals("o") ? this.m_numClasses : (string.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(string).intValue())));
            for (n = 0; n < n3; ++n) {
                NeuralNode neuralNode = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
                ++this.m_nextId;
                neuralNode.setX(0.5 / (double)n5 * (double)n2 + 0.25);
                neuralNode.setY(((double)n + 1.0) / (double)(n3 + 1));
                this.addNode(neuralNode);
                if (n2 <= 0) continue;
                for (int i = this.m_neuralNodes.length - n - 1 - n4; i < this.m_neuralNodes.length - n - 1; ++i) {
                    NeuralConnection.connect(this.m_neuralNodes[i], neuralNode);
                }
            }
            n4 = n3;
        }
        stringTokenizer = new StringTokenizer(this.m_hiddenLayers, ",");
        string = stringTokenizer.nextToken();
        n3 = string.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (string.equals("i") ? this.m_numAttributes : (string.equals("o") ? this.m_numClasses : (string.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(string).intValue())));
        if (n3 == 0) {
            for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                for (n = 0; n < this.m_numClasses; ++n) {
                    NeuralConnection.connect(this.m_inputs[n2], this.m_neuralNodes[n]);
                }
            }
        } else {
            for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                for (n = this.m_numClasses; n < this.m_numClasses + n3; ++n) {
                    NeuralConnection.connect(this.m_inputs[n2], this.m_neuralNodes[n]);
                }
            }
            for (n2 = this.m_neuralNodes.length - n4; n2 < this.m_neuralNodes.length; ++n2) {
                for (n = 0; n < this.m_numClasses; ++n) {
                    NeuralConnection.connect(this.m_neuralNodes[n2], this.m_neuralNodes[n]);
                }
            }
        }
    }

    private void setEndsToLinear() {
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            if ((this.m_neuralNodes[i].getType() & 8) == 8) {
                ((NeuralNode)this.m_neuralNodes[i]).setMethod(this.m_linearUnit);
                continue;
            }
            ((NeuralNode)this.m_neuralNodes[i]).setMethod(this.m_sigmoidUnit);
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        if (instances.numInstances() == 0) {
            throw new IllegalArgumentException(LocalString.get("No training instances."));
        }
        this.m_epoch = 0;
        this.m_error = 0.0;
        this.m_instances = null;
        this.m_currentInstance = null;
        this.m_controlPanel = null;
        this.m_nodePanel = null;
        this.m_outputs = new NeuralEnd[0];
        this.m_inputs = new NeuralEnd[0];
        this.m_numAttributes = 0;
        this.m_numClasses = 0;
        this.m_neuralNodes = new NeuralConnection[0];
        this.m_selected = new FastVector(4);
        this.m_graphers = new FastVector(2);
        this.m_nextId = 0;
        this.m_stopIt = true;
        this.m_stopped = true;
        this.m_accepted = false;
        this.m_instances = new Instances(instances);
        this.m_instances.deleteWithMissingClass();
        if (this.m_instances.numInstances() == 0) {
            this.m_instances = null;
            throw new IllegalArgumentException(LocalString.get("All class values missing."));
        }
        this.m_random = new Random(this.m_randomSeed);
        this.m_instances.randomize(this.m_random);
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter = new NominalToBinary();
            this.m_nominalToBinaryFilter.setInputFormat(this.m_instances);
            this.m_instances = Filter.useFilter(this.m_instances, this.m_nominalToBinaryFilter);
        }
        this.m_numAttributes = this.m_instances.numAttributes() - 1;
        this.m_numClasses = this.m_instances.numClasses();
        this.setClassType(this.m_instances);
        Instances instances2 = null;
        int n2 = (int)((double)this.m_valSize / 100.0 * (double)this.m_instances.numInstances());
        if (this.m_valSize > 0) {
            if (n2 == 0) {
                n2 = 1;
            }
            instances2 = new Instances(this.m_instances, 0, n2);
        }
        this.setupInputs();
        this.setupOutputs();
        if (this.m_autoBuild) {
            this.setupHiddenLayer();
        }
        if (this.m_gui) {
            this.m_win = new JFrame();
            this.m_win.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    boolean bl = MultilayerPerceptron.this.m_stopIt;
                    MultilayerPerceptron.this.m_stopIt = true;
                    int n = JOptionPane.showConfirmDialog(MultilayerPerceptron.this.m_win, LocalString.get("Are You Sure...\n") + LocalString.get("Click Yes To Accept") + LocalString.get(" The Neural Network") + LocalString.get("\n Click No To Return"), LocalString.get("Accept Neural Network"), 0);
                    if (n == 0) {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(2);
                        MultilayerPerceptron.this.m_accepted = true;
                        MultilayerPerceptron.this.blocker(false);
                    } else {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(0);
                    }
                    MultilayerPerceptron.this.m_stopIt = bl;
                }
            });
            this.m_win.getContentPane().setLayout(new BorderLayout());
            this.m_win.setTitle(LocalString.get("Neural Network"));
            this.m_nodePanel = new NodePanel();
            JScrollPane jScrollPane = new JScrollPane(this.m_nodePanel, 22, 31);
            this.m_controlPanel = new ControlPanel();
            this.m_win.getContentPane().add((Component)jScrollPane, "Center");
            this.m_win.getContentPane().add((Component)this.m_controlPanel, "South");
            this.m_win.setSize(640, 480);
            this.m_win.setVisible(true);
        }
        if (this.m_gui) {
            this.blocker(true);
            this.m_controlPanel.m_changeEpochs.setEnabled(false);
            this.m_controlPanel.m_changeLearning.setEnabled(false);
            this.m_controlPanel.m_changeMomentum.setEnabled(false);
        }
        if (this.m_numeric) {
            this.setEndsToLinear();
        }
        if (this.m_accepted) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.m_learningRate;
        if (n2 == this.m_instances.numInstances()) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (n = n2; n < this.m_instances.numInstances(); ++n) {
            if (this.m_instances.instance(n).classIsMissing()) continue;
            d4 += this.m_instances.instance(n).weight();
        }
        if (this.m_valSize != 0) {
            for (n = 0; n < instances2.numInstances(); ++n) {
                if (instances2.instance(n).classIsMissing()) continue;
                d5 += instances2.instance(n).weight();
            }
        }
        this.m_stopped = false;
        for (n = 1; n < this.m_numEpochs + 1; ++n) {
            int n3;
            d = 0.0;
            for (n3 = n2; n3 < this.m_instances.numInstances(); ++n3) {
                this.m_currentInstance = this.m_instances.instance(n3);
                if (this.m_currentInstance.classIsMissing()) continue;
                this.resetNetwork();
                this.calculateOutputs();
                double d7 = this.m_learningRate * this.m_currentInstance.weight();
                if (this.m_decay) {
                    d7 /= (double)n;
                }
                d += this.calculateErrors() / (double)this.m_instances.numClasses() * this.m_currentInstance.weight();
                this.updateNetworkWeights(d7, this.m_momentum);
            }
            if (Double.isInfinite(d /= d4) || Double.isNaN(d)) {
                if (!this.m_reset) {
                    this.m_instances = null;
                    throw new Exception(LocalString.get("Network cannot train. Try restarting with a") + LocalString.get(" smaller learning rate."));
                }
                this.m_learningRate /= 2.0;
                this.buildClassifier(instances);
                this.m_learningRate = d6;
                this.m_instances = new Instances(this.m_instances, 0);
                return;
            }
            if (this.m_valSize != 0) {
                d = 0.0;
                for (n3 = 0; n3 < instances2.numInstances(); ++n3) {
                    this.m_currentInstance = instances2.instance(n3);
                    if (this.m_currentInstance.classIsMissing()) continue;
                    this.resetNetwork();
                    this.calculateOutputs();
                    d += this.calculateErrors() / (double)instances2.numClasses() * this.m_currentInstance.weight();
                }
                d2 = d < d3 ? 0.0 : (d2 += 1.0);
                d3 = d;
                if (d2 > (double)this.m_driftThreshold || n + 1 >= this.m_numEpochs) {
                    this.m_accepted = true;
                }
                d /= d5;
            }
            this.m_epoch = n;
            this.m_error = d;
            this.updateDisplay();
            if (this.m_gui) {
                while ((this.m_stopIt || this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) && !this.m_accepted) {
                    this.m_stopIt = true;
                    this.m_stopped = true;
                    if (this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) {
                        this.m_controlPanel.m_startStop.setEnabled(false);
                    } else {
                        this.m_controlPanel.m_startStop.setEnabled(true);
                    }
                    this.m_controlPanel.m_startStop.setText(LocalString.get("Start"));
                    this.m_controlPanel.m_startStop.setActionCommand(LocalString.get("Start"));
                    this.m_controlPanel.m_changeEpochs.setEnabled(true);
                    this.m_controlPanel.m_changeLearning.setEnabled(true);
                    this.m_controlPanel.m_changeMomentum.setEnabled(true);
                    this.blocker(true);
                    if (!this.m_numeric) continue;
                    this.setEndsToLinear();
                }
                this.m_controlPanel.m_changeEpochs.setEnabled(false);
                this.m_controlPanel.m_changeLearning.setEnabled(false);
                this.m_controlPanel.m_changeMomentum.setEnabled(false);
                this.m_stopped = false;
                if (this.m_accepted) {
                    this.m_win.dispose();
                    this.m_controlPanel = null;
                    this.m_nodePanel = null;
                    this.m_instances = new Instances(this.m_instances, 0);
                    return;
                }
            }
            if (!this.m_accepted) continue;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        if (this.m_gui) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter.input(instance);
            this.m_currentInstance = this.m_nominalToBinaryFilter.output();
        } else {
            this.m_currentInstance = instance;
        }
        if (this.m_normalizeAttributes) {
            for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
                if (i == this.m_instances.classIndex()) continue;
                if (this.m_attributeRanges[i] != 0.0) {
                    this.m_currentInstance.setValue(i, (this.m_currentInstance.value(i) - this.m_attributeBases[i]) / this.m_attributeRanges[i]);
                    continue;
                }
                this.m_currentInstance.setValue(i, this.m_currentInstance.value(i) - this.m_attributeBases[i]);
            }
        }
        this.resetNetwork();
        double[] dArray = new double[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            dArray[i] = this.m_outputs[i].outputValue(true);
        }
        if (this.m_instances.classAttribute().isNumeric()) {
            return dArray;
        }
        double d = 0.0;
        for (n = 0; n < this.m_numClasses; ++n) {
            d += dArray[n];
        }
        if (d <= 0.0) {
            return null;
        }
        n = 0;
        while (n < this.m_numClasses) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(14);
        vector.addElement(new Option(LocalString.get("\tLearning Rate for the backpropagation algorithm.\n") + LocalString.get("\t(Value should be between 0 - 1, Default = 0.3)."), "L", 1, LocalString.get("-L <learning rate>")));
        vector.addElement(new Option(LocalString.get("\tMomentum Rate for the backpropagation algorithm.\n") + LocalString.get("\t(Value should be between 0 - 1, Default = 0.2)."), "M", 1, LocalString.get("-M <momentum>")));
        vector.addElement(new Option(LocalString.get("\tNumber of epochs to train through.\n") + LocalString.get("\t(Default = 500)."), "N", 1, LocalString.get("-N <number of epochs>")));
        vector.addElement(new Option(LocalString.get("\tPercentage size of validation set to use to terminate") + LocalString.get(" training (if this is non zero it can pre-empt num of epochs.\n") + LocalString.get("\t(Value should be between 0 - 100, Default = 0)."), "V", 1, LocalString.get("-V <percentage size of validation set>")));
        vector.addElement(new Option(LocalString.get("\tThe value used to seed the random number generator") + LocalString.get("\t(Value should be >= 0 and and a long, Default = 0)."), "S", 1, LocalString.get("-S <seed>")));
        vector.addElement(new Option(LocalString.get("\tThe consequetive number of errors allowed for validation") + LocalString.get(" testing before the netwrok terminates.") + LocalString.get("\t(Value should be > 0, Default = 20)."), "E", 1, LocalString.get("-E <threshold for number of consequetive errors>")));
        vector.addElement(new Option(LocalString.get("\tGUI will be opened.\n") + LocalString.get("\t(Use this to bring up a GUI)."), "G", 0, "-G"));
        vector.addElement(new Option(LocalString.get("\tAutocreation of the network connections will NOT be done.\n") + LocalString.get("\t(This will be ignored if -G is NOT set)"), "A", 0, "-A"));
        vector.addElement(new Option(LocalString.get("\tA NominalToBinary filter will NOT automatically be used.\n") + LocalString.get("\t(Set this to not use a NominalToBinary filter)."), "B", 0, "-B"));
        vector.addElement(new Option(LocalString.get("\tThe hidden layers to be created for the network.\n") + LocalString.get("\t(Value should be a list of comma seperated Natural numbers") + LocalString.get(" or the letters 'a' = (attribs + classes) / 2, 'i'") + LocalString.get(" = attribs, 'o' = classes, 't' = attribs .+ classes)") + LocalString.get(" For wildcard values") + LocalString.get(",Default = a)."), "H", 1, LocalString.get("-H <comma seperated numbers for nodes on each layer>")));
        vector.addElement(new Option(LocalString.get("\tNormalizing a numeric class will NOT be done.\n") + LocalString.get("\t(Set this to not normalize the class if it's numeric)."), "C", 0, "-C"));
        vector.addElement(new Option(LocalString.get("\tNormalizing the attributes will NOT be done.\n") + LocalString.get("\t(Set this to not normalize the attributes)."), "I", 0, "-I"));
        vector.addElement(new Option(LocalString.get("\tReseting the network will NOT be allowed.\n") + LocalString.get("\t(Set this to not allow the network to reset)."), "R", 0, "-R"));
        vector.addElement(new Option(LocalString.get("\tLearning rate decay will occur.\n") + LocalString.get("\t(Set this to cause the learning rate to decay)."), "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setLearningRate(new Double(string));
        } else {
            this.setLearningRate(0.3);
        }
        String string2 = Utils.getOption('M', stringArray);
        if (string2.length() != 0) {
            this.setMomentum(new Double(string2));
        } else {
            this.setMomentum(0.2);
        }
        String string3 = Utils.getOption('N', stringArray);
        if (string3.length() != 0) {
            this.setTrainingTime(Integer.parseInt(string3));
        } else {
            this.setTrainingTime(500);
        }
        String string4 = Utils.getOption('V', stringArray);
        if (string4.length() != 0) {
            this.setValidationSetSize(Integer.parseInt(string4));
        } else {
            this.setValidationSetSize(0);
        }
        String string5 = Utils.getOption('S', stringArray);
        if (string5.length() != 0) {
            this.setRandomSeed(Long.parseLong(string5));
        } else {
            this.setRandomSeed(0L);
        }
        String string6 = Utils.getOption('E', stringArray);
        if (string6.length() != 0) {
            this.setValidationThreshold(Integer.parseInt(string6));
        } else {
            this.setValidationThreshold(20);
        }
        String string7 = Utils.getOption('H', stringArray);
        if (string7.length() != 0) {
            this.setHiddenLayers(string7);
        } else {
            this.setHiddenLayers("a");
        }
        if (Utils.getFlag('G', stringArray)) {
            this.setGUI(true);
        } else {
            this.setGUI(false);
        }
        if (Utils.getFlag('A', stringArray)) {
            this.setAutoBuild(false);
        } else {
            this.setAutoBuild(true);
        }
        if (Utils.getFlag('B', stringArray)) {
            this.setNominalToBinaryFilter(false);
        } else {
            this.setNominalToBinaryFilter(true);
        }
        if (Utils.getFlag('C', stringArray)) {
            this.setNormalizeNumericClass(false);
        } else {
            this.setNormalizeNumericClass(true);
        }
        if (Utils.getFlag('I', stringArray)) {
            this.setNormalizeAttributes(false);
        } else {
            this.setNormalizeAttributes(true);
        }
        if (Utils.getFlag('R', stringArray)) {
            this.setReset(false);
        } else {
            this.setReset(true);
        }
        if (Utils.getFlag('D', stringArray)) {
            this.setDecay(true);
        } else {
            this.setDecay(false);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[21];
        int n = 0;
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.getLearningRate();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMomentum();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getTrainingTime();
        stringArray[n++] = "-V";
        stringArray[n++] = "" + this.getValidationSetSize();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.getValidationThreshold();
        stringArray[n++] = "-H";
        stringArray[n++] = this.getHiddenLayers();
        if (this.getGUI()) {
            stringArray[n++] = "-G";
        }
        if (!this.getAutoBuild()) {
            stringArray[n++] = "-A";
        }
        if (!this.getNominalToBinaryFilter()) {
            stringArray[n++] = "-B";
        }
        if (!this.getNormalizeNumericClass()) {
            stringArray[n++] = "-C";
        }
        if (!this.getNormalizeAttributes()) {
            stringArray[n++] = "-I";
        }
        if (!this.getReset()) {
            stringArray[n++] = "-R";
        }
        if (this.getDecay()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        int n;
        NeuralConnection[] neuralConnectionArray;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.m_neuralNodes.length * 100);
        for (n2 = 0; n2 < this.m_neuralNodes.length; ++n2) {
            NeuralNode neuralNode = (NeuralNode)this.m_neuralNodes[n2];
            double[] dArray = neuralNode.getWeights();
            neuralConnectionArray = neuralNode.getInputs();
            if (neuralNode.getMethod() instanceof SigmoidUnit) {
                stringBuffer.append(LocalString.get("Sigmoid "));
            } else if (neuralNode.getMethod() instanceof LinearUnit) {
                stringBuffer.append(LocalString.get("Linear "));
            }
            stringBuffer.append(LocalString.get("Node ") + neuralNode.getId() + LocalString.get("\n    Inputs    Weights\n"));
            stringBuffer.append(LocalString.get("    Threshold    ") + dArray[0] + "\n");
            for (n = 1; n < neuralNode.getNumInputs() + 1; ++n) {
                if ((neuralConnectionArray[n - 1].getType() & 1) == 1) {
                    stringBuffer.append(LocalString.get("    Attrib ") + this.m_instances.attribute(((NeuralEnd)neuralConnectionArray[n - 1]).getLink()).name() + "    " + dArray[n] + "\n");
                    continue;
                }
                stringBuffer.append(LocalString.get("    Node ") + neuralConnectionArray[n - 1].getId() + "    " + dArray[n] + "\n");
            }
        }
        for (n2 = 0; n2 < this.m_outputs.length; ++n2) {
            neuralConnectionArray = this.m_outputs[n2].getInputs();
            stringBuffer.append(LocalString.get("Class ") + this.m_instances.classAttribute().value(this.m_outputs[n2].getLink()) + LocalString.get("\n    Input\n"));
            for (n = 0; n < this.m_outputs[n2].getNumInputs(); ++n) {
                if ((neuralConnectionArray[n].getType() & 1) == 1) {
                    stringBuffer.append(LocalString.get("    Attrib ") + this.m_instances.attribute(((NeuralEnd)neuralConnectionArray[n]).getLink()).name() + "\n");
                    continue;
                }
                stringBuffer.append(LocalString.get("    Node ") + neuralConnectionArray[n].getId() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String globalInfo() {
        return LocalString.get("This neural network uses backpropagation to train.");
    }

    public String learningRateTipText() {
        return LocalString.get("The amount the") + LocalString.get(" weights are updated.");
    }

    public String momentumTipText() {
        return LocalString.get("Momentum applied to the weights during updating.");
    }

    public String autoBuildTipText() {
        return LocalString.get("Adds and connects up hidden layers in the network.");
    }

    public String randomSeedTipText() {
        return LocalString.get("Seed used to initialise the random number generator.") + LocalString.get("Random numbers are used for setting the initial weights of the") + LocalString.get(" connections betweem nodes, and also for shuffling the training data.");
    }

    public String validationThresholdTipText() {
        return LocalString.get("Used to terminate validation testing.") + LocalString.get("The value here dictates how many times in a row the validation set") + LocalString.get(" error can get worse before training is terminated.");
    }

    public String GUITipText() {
        return LocalString.get("Brings up a gui interface.") + LocalString.get(" This will allow the pausing and altering of the nueral network") + LocalString.get(" during training.\n\n") + LocalString.get("* To add a node left click (this node will be automatically selected,") + LocalString.get(" ensure no other nodes were selected).\n") + LocalString.get("* To select a node left click on it either while no other node is") + LocalString.get(" selected or while holding down the control key (this toggles that") + LocalString.get(" node as being selected and not selected.\n") + LocalString.get("* To connect a node, first have the start node(s) selected, then click") + LocalString.get(" either the end node or on an empty space (this will create a new node") + LocalString.get(" that is connected with the selected nodes). The selection status of") + LocalString.get(" nodes will stay the same after the connection. (Note these are") + LocalString.get(" directed connections, also a connection between two nodes will not") + LocalString.get(" be established more than once and certain connections that are") + LocalString.get(" deemed to be invalid will not be made).\n") + LocalString.get("* To remove a connection select one of the connected node(s) in the") + LocalString.get(" connection and then right click the other node (it does not matter") + LocalString.get(" whether the node is the start or end the connection will be removed") + ").\n" + LocalString.get("* To remove a node right click it while no other nodes (including it)") + LocalString.get(" are selected. (This will also remove all connections to it)\n.") + LocalString.get("* To deselect a node either left click it while holding down control,") + LocalString.get(" or right click on empty space.\n") + LocalString.get("* The raw inputs are provided from the labels on the left.\n") + LocalString.get("* The red nodes are hidden layers.\n") + LocalString.get("* The orange nodes are the output nodes.\n") + LocalString.get("* The labels on the right show the class the output node represents.") + LocalString.get(" Note that with a numeric class the output node will automatically be") + LocalString.get(" made into an unthresholded linear unit.\n\n") + LocalString.get("Alterations to the neural network can only be done while the network") + LocalString.get(" is not running, This also applies to the learning rate and other") + LocalString.get(" fields on the control panel.\n\n") + LocalString.get("* You can accept the network as being finished at any time.\n") + LocalString.get("* The network is automatically paused at the beginning.\n") + LocalString.get("* There is a running indication of what epoch the network is up to") + LocalString.get(" and what the (rough) error for that epoch was (or for") + LocalString.get(" the validation if that is being used). Note that this error value") + LocalString.get(" is based on a network that changes as the value is computed.") + LocalString.get(" (also depending on whether") + LocalString.get(" the class is normalized will effect the error reported for numeric") + LocalString.get(" classes.\n") + LocalString.get("* Once the network is done it will pause again and either wait to be") + LocalString.get(" accepted or trained more.\n\n") + LocalString.get("Note that if the gui is not set the network will not require any") + LocalString.get(" interaction.\n");
    }

    public String validationSetSizeTipText() {
        return LocalString.get("The percentage size of the validation set.") + LocalString.get("(The training will continue until it is observed that") + LocalString.get(" the error on the validation set has been consistently getting") + LocalString.get(" worse, or if the training time is reached).\n") + LocalString.get("If This is set to zero no validation set will be used and instead") + LocalString.get(" the network will train for the specified number of epochs.");
    }

    public String trainingTimeTipText() {
        return LocalString.get("The number of epochs to train through.") + LocalString.get(" If the validation set is non-zero then it can terminate the network") + LocalString.get(" early");
    }

    public String nominalToBinaryFilterTipText() {
        return LocalString.get("This will preprocess the instances with the filter.") + LocalString.get(" This could help improve performance if there are nominal attributes") + LocalString.get(" in the data.");
    }

    public String hiddenLayersTipText() {
        return LocalString.get("This defines the hidden layers of the neural network.") + LocalString.get(" This is a list of positive whole numbers. 1 for each hidden layer.") + LocalString.get(" Comma seperated. To have no hidden layers put a single 0 here.") + LocalString.get(" This will only be used if autobuild is set. There are also wildcard") + LocalString.get(" values 'a' = (attribs + classes) / 2, 'i' = attribs, 'o' = classes") + LocalString.get(" , 't' = attribs + classes.");
    }

    public String normalizeNumericClassTipText() {
        return LocalString.get("This will normalize the class if it's numeric.") + LocalString.get(" This could help improve performance of the network, It normalizes") + LocalString.get(" the class to be between -1 and 1. Note that this is only internally") + LocalString.get(", the output will be scaled back to the original range.");
    }

    public String normalizeAttributesTipText() {
        return LocalString.get("This will normalize the attributes.") + LocalString.get(" This could help improve performance of the network.") + LocalString.get(" This is not reliant on the class being numeric. This will also") + LocalString.get(" normalize nominal attributes as well (after they have been run") + LocalString.get(" through the nominal to binary filter if that is in use) so that the") + LocalString.get(" nominal values are between -1 and 1");
    }

    public String resetTipText() {
        return LocalString.get("This will allow the network to reset with a lower learning rate.") + LocalString.get(" If the network diverges from the answer this will automatically") + LocalString.get(" reset the network with a lower learning rate and begin training") + LocalString.get(" again. This option is only available if the gui is not set. Note") + LocalString.get(" that if the network diverges but isn't allowed to reset it will") + LocalString.get(" fail the training process and return an error message.");
    }

    public String decayTipText() {
        return LocalString.get("This will cause the learning rate to decrease.") + LocalString.get(" This will divide the starting learning rate by the epoch number, to") + LocalString.get(" determine what the current learning rate should be. This may help") + LocalString.get(" to stop the network from diverging from the target output, as well") + LocalString.get(" as improve general performance. Note that the decaying learning") + LocalString.get(" rate will not be shown in the gui, only the original learning rate") + LocalString.get(". If the learning rate is changed in the gui, this is treated as the") + LocalString.get(" starting learning rate.");
    }

    static /* synthetic */ boolean access$700(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_stopped;
    }

    static /* synthetic */ int access$1400(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_nextId;
    }

    static /* synthetic */ Random access$1500(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_random;
    }

    static /* synthetic */ SigmoidUnit access$1600(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_sigmoidUnit;
    }

    static /* synthetic */ int access$1408(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_nextId++;
    }

    static /* synthetic */ void access$1700(MultilayerPerceptron multilayerPerceptron, NeuralConnection neuralConnection) {
        multilayerPerceptron.addNode(neuralConnection);
    }

    static /* synthetic */ ControlPanel access$2100(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_controlPanel;
    }

    static /* synthetic */ int access$2200(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_epoch;
    }

    static /* synthetic */ int access$2400(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_valSize;
    }

    static /* synthetic */ double access$2500(MultilayerPerceptron multilayerPerceptron) {
        return multilayerPerceptron.m_error;
    }

    static /* synthetic */ int access$2302(MultilayerPerceptron multilayerPerceptron, int n) {
        multilayerPerceptron.m_numEpochs = n;
        return multilayerPerceptron.m_numEpochs;
    }

    class ControlPanel
    extends JPanel {
        public JButton m_startStop;
        public JButton m_acceptButton;
        public JPanel m_epochsLabel;
        public JLabel m_totalEpochsLabel;
        public JTextField m_changeEpochs;
        public JLabel m_learningLabel;
        public JLabel m_momentumLabel;
        public JTextField m_changeLearning;
        public JTextField m_changeMomentum;
        public JPanel m_errorLabel;

        public ControlPanel() {
            this.setBorder(BorderFactory.createTitledBorder(LocalString.get("Controls")));
            this.m_totalEpochsLabel = new JLabel(LocalString.get("Num Of Epochs  "));
            this.m_epochsLabel = new JPanel(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = controlPanel;
                }

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(MultilayerPerceptron.access$2100((MultilayerPerceptron)ControlPanel.access$2000((ControlPanel)this.this$1)).m_totalEpochsLabel.getForeground());
                    graphics.drawString(LocalString.get("Epoch  ") + MultilayerPerceptron.access$2200(ControlPanel.access$2000(this.this$1)), 0, 10);
                }
            };
            this.m_epochsLabel.setFont(this.m_totalEpochsLabel.getFont());
            this.m_changeEpochs = new JTextField();
            this.m_changeEpochs.setText("" + MultilayerPerceptron.this.m_numEpochs);
            this.m_errorLabel = new JPanel(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = controlPanel;
                }

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(MultilayerPerceptron.access$2100((MultilayerPerceptron)ControlPanel.access$2000((ControlPanel)this.this$1)).m_totalEpochsLabel.getForeground());
                    if (MultilayerPerceptron.access$2400(ControlPanel.access$2000(this.this$1)) == 0) {
                        graphics.drawString(LocalString.get("Error per Epoch = ") + Utils.doubleToString(MultilayerPerceptron.access$2500(ControlPanel.access$2000(this.this$1)), 7), 0, 10);
                    } else {
                        graphics.drawString(LocalString.get("Validation Error per Epoch = ") + Utils.doubleToString(MultilayerPerceptron.access$2500(ControlPanel.access$2000(this.this$1)), 7), 0, 10);
                    }
                }
            };
            this.m_errorLabel.setFont(this.m_epochsLabel.getFont());
            this.m_learningLabel = new JLabel(LocalString.get("Learning Rate = "));
            this.m_momentumLabel = new JLabel(LocalString.get("Momentum = "));
            this.m_changeLearning = new JTextField();
            this.m_changeMomentum = new JTextField();
            this.m_changeLearning.setText("" + MultilayerPerceptron.this.m_learningRate);
            this.m_changeMomentum.setText("" + MultilayerPerceptron.this.m_momentum);
            this.setLayout(new BorderLayout(15, 10));
            MultilayerPerceptron.this.m_stopIt = true;
            MultilayerPerceptron.this.m_accepted = false;
            this.m_startStop = new JButton(LocalString.get("Start"));
            this.m_startStop.setActionCommand(LocalString.get("Start"));
            this.m_acceptButton = new JButton(LocalString.get("Accept"));
            this.m_acceptButton.setActionCommand(LocalString.get("Accept"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.m_startStop);
            jPanel.add(this.m_acceptButton);
            this.add((Component)jPanel, "West");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            Box box = new Box(0);
            box.add(this.m_epochsLabel);
            jPanel2.add(box);
            box = new Box(0);
            Component component = Box.createGlue();
            box.add(this.m_totalEpochsLabel);
            box.add(this.m_changeEpochs);
            this.m_changeEpochs.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            box = new Box(0);
            box.add(this.m_errorLabel);
            jPanel2.add(box);
            this.add((Component)jPanel2, "Center");
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            box = new Box(0);
            component = Box.createGlue();
            box.add(this.m_learningLabel);
            box.add(this.m_changeLearning);
            this.m_changeLearning.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            box = new Box(0);
            component = Box.createGlue();
            box.add(this.m_momentumLabel);
            box.add(this.m_changeMomentum);
            this.m_changeMomentum.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            this.add((Component)jPanel2, "East");
            this.m_startStop.addActionListener(new ActionListener(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = controlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals(LocalString.get("Start"))) {
                        MultilayerPerceptron.access$2802(ControlPanel.access$2000(this.this$1), false);
                        this.this$1.m_startStop.setText(LocalString.get("Stop"));
                        this.this$1.m_startStop.setActionCommand(LocalString.get("Stop"));
                        int n = Integer.valueOf(this.this$1.m_changeEpochs.getText());
                        MultilayerPerceptron.access$2302(ControlPanel.access$2000(this.this$1), n);
                        this.this$1.m_changeEpochs.setText("" + MultilayerPerceptron.access$2300(ControlPanel.access$2000(this.this$1)));
                        double d = Double.valueOf(this.this$1.m_changeLearning.getText());
                        ControlPanel.access$2000(this.this$1).setLearningRate(d);
                        this.this$1.m_changeLearning.setText("" + MultilayerPerceptron.access$2600(ControlPanel.access$2000(this.this$1)));
                        d = Double.valueOf(this.this$1.m_changeMomentum.getText());
                        ControlPanel.access$2000(this.this$1).setMomentum(d);
                        this.this$1.m_changeMomentum.setText("" + MultilayerPerceptron.access$2700(ControlPanel.access$2000(this.this$1)));
                        ControlPanel.access$2000(this.this$1).blocker(false);
                    } else if (actionEvent.getActionCommand().equals(LocalString.get("Stop"))) {
                        MultilayerPerceptron.access$2802(ControlPanel.access$2000(this.this$1), true);
                        this.this$1.m_startStop.setText(LocalString.get("Start"));
                        this.this$1.m_startStop.setActionCommand(LocalString.get("Start"));
                    }
                }
            });
            this.m_acceptButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = controlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MultilayerPerceptron.access$2902(ControlPanel.access$2000(this.this$1), true);
                    ControlPanel.access$2000(this.this$1).blocker(false);
                }
            });
            this.m_changeEpochs.addActionListener(new ActionListener(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = controlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Integer.valueOf(this.this$1.m_changeEpochs.getText());
                    if (n > 0) {
                        MultilayerPerceptron.access$2302(ControlPanel.access$2000(this.this$1), n);
                        ControlPanel.access$2000(this.this$1).blocker(false);
                    }
                }
            });
        }

        static /* synthetic */ MultilayerPerceptron access$2000(ControlPanel controlPanel) {
            return controlPanel.MultilayerPerceptron.this;
        }
    }

    private class NodePanel
    extends JPanel {
        public NodePanel() {
            this.addMouseListener(new MouseAdapter(this, MultilayerPerceptron.this){
                private final /* synthetic */ MultilayerPerceptron val$this$0;
                private final /* synthetic */ NodePanel this$1;
                {
                    this.this$1 = nodePanel;
                    this.val$this$0 = multilayerPerceptron;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!MultilayerPerceptron.access$700(NodePanel.access$600(this.this$1))) {
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 0x10) == 16 && !mouseEvent.isAltDown()) {
                        int n;
                        Graphics graphics = this.this$1.getGraphics();
                        int n2 = mouseEvent.getX();
                        int n3 = mouseEvent.getY();
                        int n4 = this.this$1.getWidth();
                        int n5 = this.this$1.getHeight();
                        boolean bl = false;
                        FastVector fastVector = new FastVector(4);
                        for (n = 0; n < MultilayerPerceptron.access$800(NodePanel.access$600(this.this$1)); ++n) {
                            if (!MultilayerPerceptron.access$900(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$900(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.access$1100(NodePanel.access$600(this.this$1)); ++n) {
                            if (!MultilayerPerceptron.access$1200(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$1200(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1)).length; ++n) {
                            if (!MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        NeuralNode neuralNode = new NeuralNode(String.valueOf(MultilayerPerceptron.access$1400(NodePanel.access$600(this.this$1))), MultilayerPerceptron.access$1500(NodePanel.access$600(this.this$1)), MultilayerPerceptron.access$1600(NodePanel.access$600(this.this$1)));
                        MultilayerPerceptron.access$1408(NodePanel.access$600(this.this$1));
                        neuralNode.setX((double)mouseEvent.getX() / (double)n4);
                        neuralNode.setY((double)mouseEvent.getY() / (double)n5);
                        fastVector.addElement(neuralNode);
                        MultilayerPerceptron.access$1700(NodePanel.access$600(this.this$1), neuralNode);
                        NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                    } else {
                        int n;
                        Graphics graphics = this.this$1.getGraphics();
                        int n6 = mouseEvent.getX();
                        int n7 = mouseEvent.getY();
                        int n8 = this.this$1.getWidth();
                        int n9 = this.this$1.getHeight();
                        boolean bl = false;
                        FastVector fastVector = new FastVector(4);
                        for (n = 0; n < MultilayerPerceptron.access$800(NodePanel.access$600(this.this$1)); ++n) {
                            if (!MultilayerPerceptron.access$900(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$900(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.access$1100(NodePanel.access$600(this.this$1)); ++n) {
                            if (!MultilayerPerceptron.access$1200(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$1200(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1)).length; ++n) {
                            if (!MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1))[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.access$1300(NodePanel.access$600(this.this$1))[n]);
                            NodePanel.access$1000(this.this$1, fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        NodePanel.access$1000(this.this$1, null, (mouseEvent.getModifiers() & 2) == 2, false);
                    }
                }
            });
        }

        private void selection(FastVector fastVector, boolean bl, boolean bl2) {
            if (fastVector == null) {
                MultilayerPerceptron.this.m_selected.removeAllElements();
                this.repaint();
                return;
            }
            if ((bl || MultilayerPerceptron.this.m_selected.size() == 0) && bl2) {
                boolean bl3 = false;
                for (int i = 0; i < fastVector.size(); ++i) {
                    bl3 = false;
                    for (int j = 0; j < MultilayerPerceptron.this.m_selected.size(); ++j) {
                        if (fastVector.elementAt(i) != MultilayerPerceptron.this.m_selected.elementAt(j)) continue;
                        MultilayerPerceptron.this.m_selected.removeElementAt(j);
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    MultilayerPerceptron.this.m_selected.addElement(fastVector.elementAt(i));
                }
                this.repaint();
                return;
            }
            if (bl2) {
                for (int i = 0; i < MultilayerPerceptron.this.m_selected.size(); ++i) {
                    for (int j = 0; j < fastVector.size(); ++j) {
                        NeuralConnection.connect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i), (NeuralConnection)fastVector.elementAt(j));
                    }
                }
            } else if (MultilayerPerceptron.this.m_selected.size() > 0) {
                for (int i = 0; i < MultilayerPerceptron.this.m_selected.size(); ++i) {
                    for (int j = 0; j < fastVector.size(); ++j) {
                        NeuralConnection.disconnect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i), (NeuralConnection)fastVector.elementAt(j));
                        NeuralConnection.disconnect((NeuralConnection)fastVector.elementAt(j), (NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < fastVector.size(); ++i) {
                    ((NeuralConnection)fastVector.elementAt(i)).removeAllInputs();
                    ((NeuralConnection)fastVector.elementAt(i)).removeAllOutputs();
                    MultilayerPerceptron.this.removeNode((NeuralConnection)fastVector.elementAt(i));
                }
            }
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            if (25 * MultilayerPerceptron.this.m_numAttributes > 25 * MultilayerPerceptron.this.m_numClasses && 25 * MultilayerPerceptron.this.m_numAttributes > n3) {
                this.setSize(n2, 25 * MultilayerPerceptron.this.m_numAttributes);
            } else if (25 * MultilayerPerceptron.this.m_numClasses > n3) {
                this.setSize(n2, 25 * MultilayerPerceptron.this.m_numClasses);
            } else {
                this.setSize(n2, n3);
            }
            n3 = this.getHeight();
            for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                MultilayerPerceptron.this.m_inputs[n].drawInputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                MultilayerPerceptron.this.m_outputs[n].drawInputLines(graphics, n2, n3);
                MultilayerPerceptron.this.m_outputs[n].drawOutputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                MultilayerPerceptron.this.m_neuralNodes[n].drawInputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                MultilayerPerceptron.this.m_inputs[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                MultilayerPerceptron.this.m_outputs[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                MultilayerPerceptron.this.m_neuralNodes[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_selected.size(); ++n) {
                ((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(n)).drawHighlight(graphics, n2, n3);
            }
        }

        static /* synthetic */ MultilayerPerceptron access$600(NodePanel nodePanel) {
            return nodePanel.MultilayerPerceptron.this;
        }

        static /* synthetic */ void access$1000(NodePanel nodePanel, FastVector fastVector, boolean bl, boolean bl2) {
            nodePanel.selection(fastVector, bl, bl2);
        }
    }

    protected class NeuralEnd
    extends NeuralConnection {
        private int m_link = 0;
        private boolean m_input = true;

        public NeuralEnd(String string) {
            super(string);
        }

        public boolean onUnit(Graphics graphics, int n, int n2, int n3, int n4) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = (int)(this.m_x * (double)n3) - fontMetrics.stringWidth(this.m_id) / 2;
            int n6 = (int)(this.m_y * (double)n4) - fontMetrics.getHeight() / 2;
            return n >= n5 && n <= n5 + fontMetrics.stringWidth(this.m_id) + 4 && n2 >= n6 && n2 <= n6 + fontMetrics.getHeight() + fontMetrics.getDescent() + 4;
        }

        public void drawNode(Graphics graphics, int n, int n2) {
            if ((this.m_type & 1) == 1) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.orange);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (int)(this.m_x * (double)n) - fontMetrics.stringWidth(this.m_id) / 2;
            int n4 = (int)(this.m_y * (double)n2) - fontMetrics.getHeight() / 2;
            graphics.fill3DRect(n3, n4, fontMetrics.stringWidth(this.m_id) + 4, fontMetrics.getHeight() + fontMetrics.getDescent() + 4, true);
            graphics.setColor(Color.black);
            graphics.drawString(this.m_id, n3 + 2, n4 + fontMetrics.getHeight() + 2);
        }

        public void drawHighlight(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (int)(this.m_x * (double)n) - fontMetrics.stringWidth(this.m_id) / 2;
            int n4 = (int)(this.m_y * (double)n2) - fontMetrics.getHeight() / 2;
            graphics.fillRect(n3 - 2, n4 - 2, fontMetrics.stringWidth(this.m_id) + 8, fontMetrics.getHeight() + fontMetrics.getDescent() + 8);
            this.drawNode(graphics, n, n2);
        }

        public double outputValue(boolean bl) {
            if (Double.isNaN(this.m_unitValue) && bl) {
                if (this.m_input) {
                    this.m_unitValue = MultilayerPerceptron.this.m_currentInstance.isMissing(this.m_link) ? 0.0 : MultilayerPerceptron.this.m_currentInstance.value(this.m_link);
                } else {
                    this.m_unitValue = 0.0;
                    for (int i = 0; i < this.m_numInputs; ++i) {
                        this.m_unitValue += this.m_inputList[i].outputValue(true);
                    }
                    if (MultilayerPerceptron.this.m_numeric && MultilayerPerceptron.this.m_normalizeClass) {
                        this.m_unitValue = this.m_unitValue * MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] + MultilayerPerceptron.this.m_attributeBases[MultilayerPerceptron.this.m_instances.classIndex()];
                    }
                }
            }
            return this.m_unitValue;
        }

        public double errorValue(boolean bl) {
            if (!Double.isNaN(this.m_unitValue) && Double.isNaN(this.m_unitError) && bl) {
                if (this.m_input) {
                    this.m_unitError = 0.0;
                    for (int i = 0; i < this.m_numOutputs; ++i) {
                        this.m_unitError += this.m_outputList[i].errorValue(true);
                    }
                } else if (MultilayerPerceptron.this.m_currentInstance.classIsMissing()) {
                    this.m_unitError = 0.1;
                } else if (MultilayerPerceptron.this.m_instances.classAttribute().isNominal()) {
                    this.m_unitError = MultilayerPerceptron.this.m_currentInstance.classValue() == (double)this.m_link ? 1.0 - this.m_unitValue : 0.0 - this.m_unitValue;
                } else if (MultilayerPerceptron.this.m_numeric) {
                    this.m_unitError = MultilayerPerceptron.this.m_normalizeClass ? (MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] == 0.0 ? 0.0 : (MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue) / MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()]) : MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue;
                }
            }
            return this.m_unitError;
        }

        public void reset() {
            if (!Double.isNaN(this.m_unitValue) || !Double.isNaN(this.m_unitError)) {
                this.m_unitValue = Double.NaN;
                this.m_unitError = Double.NaN;
                this.m_weightsUpdated = false;
                for (int i = 0; i < this.m_numInputs; ++i) {
                    this.m_inputList[i].reset();
                }
            }
        }

        public void setLink(boolean bl, int n) throws Exception {
            this.m_input = bl;
            this.m_type = bl ? 1 : 2;
            this.m_link = n < 0 || bl && n > MultilayerPerceptron.this.m_instances.numAttributes() || !bl && MultilayerPerceptron.this.m_instances.classAttribute().isNominal() && n > MultilayerPerceptron.this.m_instances.classAttribute().numValues() ? 0 : n;
        }

        public int getLink() {
            return this.m_link;
        }
    }
}

