/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;

public class RandomSearch
extends ASSearch
implements StartSetHandler,
OptionHandler {
    private int[] m_starting;
    private Range m_startRange;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_onlyConsiderBetterAndSmaller;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_seed;
    private double m_searchSize;
    private int m_iterations;
    private Random m_random;
    private boolean m_verbose;

    public String globalInfo() {
        return LocalString.get("RandomSearch : \n\nPerforms a Random search in ") + LocalString.get("the space of attribute subsets. If no start set is supplied, Random ") + LocalString.get("search starts from a random point and reports the best subset found. ") + LocalString.get("If a start set is supplied, Random searches randomly for subsets ") + LocalString.get("that are as good or better than the start point with the same or ") + LocalString.get("or fewer attributes. Using RandomSearch in conjunction with a start ") + LocalString.get("set containing all attributes equates to the LVF algorithm of Liu ") + LocalString.get("and Setiono (ICML-96).\n");
    }

    public RandomSearch() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSpecify a starting set of attributes.") + LocalString.get("\n\tEg. 1,3,5-7.") + LocalString.get("\n\tIf a start point is supplied,") + LocalString.get("\n\trandom search evaluates the start") + LocalString.get("\n\tpoint and then randomly looks for") + LocalString.get("\n\tsubsets that are as good as or better") + LocalString.get("\n\tthan the start point with the same") + LocalString.get("\n\tor lower cardinality."), "P", 1, LocalString.get("-P <start set>")));
        vector.addElement(new Option(LocalString.get("\tPercent of search space to consider.") + LocalString.get("\n\t(default = 25%)."), "F", 1, LocalString.get("-F <percent> ")));
        vector.addElement(new Option(LocalString.get("\tOutput subsets as the search progresses.") + LocalString.get("\n\t(default = false)."), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setSearchPercent(new Double(string));
        }
        this.setVerbose(Utils.getFlag('V', stringArray));
    }

    public String startSetTipText() {
        return LocalString.get("Set the start point for the search. This is specified as a comma ") + LocalString.get("seperated list off attribute indexes starting at 1. It can include ") + LocalString.get("ranges. Eg. 1,2,5-9,17. If specified, Random searches for subsets ") + LocalString.get("of attributes that are as good as or better than the start set with ") + LocalString.get("the same or lower cardinality.");
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String verboseTipText() {
        return LocalString.get("Print progress information. Sends progress info to the terminal ") + LocalString.get("as the search progresses.");
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String searchPercentTipText() {
        return LocalString.get("Percentage of the search space to explore.");
    }

    public void setSearchPercent(double d) {
        if ((d = Math.abs(d)) == 0.0) {
            d = 25.0;
        }
        if (d > 100.0) {
            d = 100.0;
        }
        this.m_searchSize = d / 100.0;
    }

    public double getSearchPercent() {
        return this.m_searchSize;
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        if (this.m_verbose) {
            stringArray[n++] = "-V";
        }
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.m_searchSize;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("\tRandom search.\n\tStart set: "));
        if (this.m_starting == null) {
            stringBuffer.append(LocalString.get("no attributes\n"));
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append(LocalString.get("\tNumber of iterations: ") + this.m_iterations + " (" + this.m_searchSize * 100.0 + LocalString.get("% of the search space)\n"));
        stringBuffer.append(LocalString.get("\tMerit of best subset found: ") + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        double d;
        int n;
        int n2 = this.m_numAttribs;
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        this.m_onlyConsiderBetterAndSmaller = false;
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + LocalString.get(" is not a ") + LocalString.get("Subset evaluator!"));
        }
        this.m_random = new Random(this.m_seed);
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)aSEvaluation;
        this.m_numAttribs = instances.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            for (n = 0; n < this.m_starting.length; ++n) {
                if (this.m_starting[n] == this.m_classIndex) continue;
                this.m_bestGroup.set(this.m_starting[n]);
            }
            this.m_onlyConsiderBetterAndSmaller = true;
            d = subsetEvaluator.evaluateSubset(this.m_bestGroup);
            n2 = this.countFeatures(this.m_bestGroup);
        } else {
            this.m_bestGroup = this.generateRandomSubset();
            d = subsetEvaluator.evaluateSubset(this.m_bestGroup);
        }
        if (this.m_verbose) {
            System.out.println(LocalString.get("Initial subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
        }
        n = this.m_hasClass ? this.m_numAttribs - 1 : this.m_numAttribs;
        this.m_iterations = (int)(this.m_searchSize * Math.pow(2.0, n));
        for (n = 0; n < this.m_iterations; ++n) {
            double d2;
            BitSet bitSet = this.generateRandomSubset();
            if (this.m_onlyConsiderBetterAndSmaller) {
                int n3 = this.countFeatures(bitSet);
                if (n3 > n2 || !((d2 = subsetEvaluator.evaluateSubset(bitSet)) >= d)) continue;
                n2 = n3;
                this.m_bestGroup = bitSet;
                d = d2;
                if (!this.m_verbose) continue;
                System.out.print(LocalString.get("New best subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup) + " :");
                System.out.println(Utils.doubleToString((double)n / (double)this.m_iterations * 100.0, 5, 1) + LocalString.get("% done"));
                continue;
            }
            d2 = subsetEvaluator.evaluateSubset(bitSet);
            if (!(d2 > d)) continue;
            this.m_bestGroup = bitSet;
            d = d2;
            if (!this.m_verbose) continue;
            System.out.print(LocalString.get("New best subset (") + Utils.doubleToString(Math.abs(d), 8, 5) + "): " + this.printSubset(this.m_bestGroup) + " :");
            System.out.println(Utils.doubleToString((double)n / (double)this.m_iterations * 100.0, 5, 1) + LocalString.get("% done"));
        }
        this.m_bestMerit = d;
        return this.attributeList(this.m_bestGroup);
    }

    private String printSubset(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer.append(i + 1 + " ");
        }
        return stringBuffer.toString();
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private BitSet generateRandomSubset() {
        BitSet bitSet = new BitSet(this.m_numAttribs);
        for (int i = 0; i < this.m_numAttribs; ++i) {
            double d = this.m_random.nextDouble();
            if (!(d <= 0.5) || this.m_hasClass && i == this.m_classIndex) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private int countFeatures(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_searchSize = 0.25;
        this.m_seed = 1;
        this.m_onlyConsiderBetterAndSmaller = false;
        this.m_verbose = false;
    }
}

