/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierSubsetEval
extends HoldOutSubsetEvaluator
implements OptionHandler,
ErrorBasedMeritEvaluator {
    private Instances m_trainingInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Classifier m_Classifier = new ZeroR();
    private Evaluation m_Evaluation;
    private File m_holdOutFile = new File(LocalString.get("Click to set hold out or ") + LocalString.get("test instances"));
    private Instances m_holdOutInstances = null;
    private boolean m_useTraining = true;

    public String globalInfo() {
        return LocalString.get("Evaluates attribute subsets on training data or a seperate ") + LocalString.get("hold out testing set");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tclass name of the classifier to use for") + LocalString.get("\n\taccuracy estimation. Place any") + LocalString.get("\n\tclassifier options LAST on the") + LocalString.get("\n\tcommand line following a \"--\".") + LocalString.get("\n\teg. -C weka.classifiers.bayes.NaiveBayes ... ") + "-- -K", "B", 1, LocalString.get("-B <classifier>")));
        vector.addElement(new Option(LocalString.get("\tUse the training data to estimate") + LocalString.get(" accuracy."), "T", 0, "-T"));
        vector.addElement(new Option(LocalString.get("\tName of the hold out/test set to ") + LocalString.get("\n\testimate accuracy on."), "H", 1, LocalString.get("-H <filename>")));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to ") + LocalString.get("scheme ") + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('B', stringArray);
        if (string.length() == 0) {
            throw new Exception(LocalString.get("A classifier must be specified with -B option"));
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
        string = Utils.getOption('H', stringArray);
        if (string.length() != 0) {
            this.setHoldOutFile(new File(string));
        }
        this.setUseTraining(Utils.getFlag('T', stringArray));
    }

    public String classifierTipText() {
        return LocalString.get("Classifier to use for estimating the accuracy of subsets");
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String holdOutFileTipText() {
        return LocalString.get("File containing hold out/test instances.");
    }

    public File getHoldOutFile() {
        return this.m_holdOutFile;
    }

    public void setHoldOutFile(File file) {
        this.m_holdOutFile = file;
    }

    public String useTrainingTipText() {
        return LocalString.get("Use training data instead of hold out/test instances.");
    }

    public boolean getUseTraining() {
        return this.m_useTraining;
    }

    public void setUseTraining(boolean bl) {
        this.m_useTraining = bl;
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[6 + stringArray.length];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-B";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        if (this.getUseTraining()) {
            stringArray2[n++] = "-T";
        }
        stringArray2[n++] = "-H";
        stringArray2[n++] = this.getHoldOutFile().getPath();
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Can't handle string attributes!"));
        }
        this.m_trainingInstances = instances;
        this.m_classIndex = this.m_trainingInstances.classIndex();
        this.m_numAttribs = this.m_trainingInstances.numAttributes();
        this.m_numInstances = this.m_trainingInstances.numInstances();
        if (!this.m_useTraining && !this.getHoldOutFile().getPath().startsWith(LocalString.get("Click to set"))) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getHoldOutFile().getPath()));
            this.m_holdOutInstances = new Instances(bufferedReader);
            this.m_holdOutInstances.setClassIndex(this.m_trainingInstances.classIndex());
            if (!this.m_trainingInstances.equalHeaders(this.m_holdOutInstances)) {
                throw new Exception(LocalString.get("Hold out/test set is not compatable with ") + LocalString.get("training data."));
            }
        }
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        int n;
        double d = 0.0;
        int n2 = 0;
        Instances instances = null;
        Instances instances2 = null;
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances = new Instances(this.m_trainingInstances);
        if (!this.m_useTraining) {
            if (this.m_holdOutInstances == null) {
                throw new Exception(LocalString.get("Must specify a set of hold out/test instances ") + LocalString.get("with -H"));
            }
            instances2 = new Instances(this.m_holdOutInstances);
        }
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        if (!this.m_useTraining) {
            instances2 = Filter.useFilter(instances2, remove);
        }
        this.m_Classifier.buildClassifier(instances);
        this.m_Evaluation = new Evaluation(instances);
        if (!this.m_useTraining) {
            this.m_Evaluation.evaluateModel(this.m_Classifier, instances2);
        } else {
            this.m_Evaluation.evaluateModel(this.m_Classifier, instances);
        }
        d = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -d;
    }

    public double evaluateSubset(BitSet bitSet, Instances instances) throws Exception {
        int n;
        int n2 = 0;
        Instances instances2 = null;
        Instances instances3 = null;
        if (!this.m_trainingInstances.equalHeaders(instances)) {
            throw new Exception(LocalString.get("evaluateSubset : Incompatable instance types."));
        }
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances2 = new Instances(this.m_trainingInstances);
        instances3 = new Instances(instances);
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, remove);
        instances3 = Filter.useFilter(instances3, remove);
        this.m_Classifier.buildClassifier(instances2);
        this.m_Evaluation = new Evaluation(instances2);
        this.m_Evaluation.evaluateModel(this.m_Classifier, instances3);
        double d = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -d;
    }

    public double evaluateSubset(BitSet bitSet, Instance instance, boolean bl) throws Exception {
        int n;
        int n2 = 0;
        Instances instances = null;
        Instance instance2 = null;
        if (!this.m_trainingInstances.equalHeaders(instance.dataset())) {
            throw new Exception(LocalString.get("evaluateSubset : Incompatable instance types."));
        }
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances = new Instances(this.m_trainingInstances);
        instance2 = (Instance)instance.copy();
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        if (bl) {
            instances = Filter.useFilter(instances, remove);
            this.m_Classifier.buildClassifier(instances);
        }
        remove.input(instance2);
        instance2 = remove.output();
        double[] dArray = this.m_Classifier.distributionForInstance(instance2);
        double d = this.m_trainingInstances.classAttribute().isNominal() ? dArray[(int)instance2.classValue()] : dArray[0];
        double d2 = this.m_trainingInstances.classAttribute().isNominal() ? 1.0 - d : instance2.classValue() - d;
        return -d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainingInstances == null) {
            stringBuffer.append(LocalString.get("\tClassifier subset evaluator has not been built yet\n"));
        } else {
            stringBuffer.append(LocalString.get("\tClassifier Subset Evaluator\n"));
            stringBuffer.append(LocalString.get("\tLearning scheme: ") + this.getClassifier().getClass().getName() + "\n");
            stringBuffer.append(LocalString.get("\tScheme options: "));
            String[] stringArray = new String[]{};
            if (this.m_Classifier instanceof OptionHandler) {
                stringArray = this.m_Classifier.getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append(LocalString.get("\tHold out/test set: "));
            if (!this.m_useTraining) {
                if (this.getHoldOutFile().getPath().startsWith(LocalString.get("Click to set"))) {
                    stringBuffer.append(LocalString.get("none\n"));
                } else {
                    stringBuffer.append(this.getHoldOutFile().getPath() + '\n');
                }
            } else {
                stringBuffer.append(LocalString.get("Training data\n"));
            }
            if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                stringBuffer.append(LocalString.get("\tAccuracy estimation: MAE\n"));
            } else {
                stringBuffer.append(LocalString.get("\tAccuracy estimation: classification error\n"));
            }
        }
        return stringBuffer.toString();
    }

    protected void resetOptions() {
        this.m_trainingInstances = null;
        this.m_Evaluation = null;
        this.m_Classifier = new ZeroR();
        this.m_holdOutFile = new File(LocalString.get("Click to set hold out or test instances"));
        this.m_holdOutInstances = null;
        this.m_useTraining = false;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new ClassifierSubsetEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

