/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.LocalString;
import weka.associations.AprioriItemSet;
import weka.associations.Associator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class Apriori
extends Associator
implements OptionHandler {
    protected double m_minSupport;
    protected double m_upperBoundMinSupport;
    protected double m_lowerBoundMinSupport;
    protected static final int CONFIDENCE = 0;
    protected static final int LIFT = 1;
    protected static final int LEVERAGE = 2;
    protected static final int CONVICTION = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, LocalString.get("Confidence")), new Tag(1, LocalString.get("Lift")), new Tag(2, LocalString.get("Leverage")), new Tag(3, LocalString.get("Conviction"))};
    protected int m_metricType = 0;
    protected double m_minMetric;
    protected int m_numRules;
    protected double m_delta;
    protected double m_significanceLevel;
    protected int m_cycles;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected boolean m_outputItemSets;
    protected boolean m_removeMissingCols;
    protected boolean m_verbose;

    public String globalInfo() {
        return LocalString.get("Finds association rules.");
    }

    public Apriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_removeMissingCols = false;
        this.m_verbose = false;
        this.m_delta = 0.05;
        this.m_minMetric = 0.9;
        this.m_numRules = 10;
        this.m_lowerBoundMinSupport = 0.1;
        this.m_upperBoundMinSupport = 1.0;
        this.m_significanceLevel = -1.0;
        this.m_outputItemSets = false;
    }

    protected Instances removeMissingColumns(Instances instances) throws Exception {
        Serializable serializable;
        int n = instances.numInstances();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int[] nArray;
            serializable = instances.attributeStats(i);
            if (this.m_upperBoundMinSupport == 1.0 && n3 != n && (nArray = serializable.nominalCounts)[Utils.maxIndex(nArray)] > n3) {
                n3 = nArray[Utils.maxIndex(nArray)];
            }
            if (serializable.missingCount != n) continue;
            if (bl) {
                stringBuffer.append(i + 1);
                bl = false;
            } else {
                stringBuffer.append("," + (i + 1));
            }
            ++n2;
        }
        if (this.m_verbose) {
            System.err.println(LocalString.get("Removed : ") + n2 + LocalString.get(" columns with all missing ") + LocalString.get("values."));
        }
        if (this.m_upperBoundMinSupport == 1.0 && n3 != n) {
            this.m_upperBoundMinSupport = (double)n3 / (double)n;
            if (this.m_verbose) {
                System.err.println(LocalString.get("Setting upper bound min support to : ") + this.m_upperBoundMinSupport);
            }
        }
        if (stringBuffer.toString().length() > 0) {
            Remove remove = new Remove();
            remove.setAttributeIndices(stringBuffer.toString());
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            serializable = Filter.useFilter(instances, remove);
            return serializable;
        }
        return instances;
    }

    public void buildAssociations(Instances instances) throws Exception {
        int n = 0;
        if (instances.checkForStringAttributes()) {
            throw new Exception(LocalString.get("Can't handle string attributes!"));
        }
        if (this.m_removeMissingCols) {
            instances = this.removeMissingColumns(instances);
        }
        this.m_cycles = 0;
        this.m_minSupport = this.m_upperBoundMinSupport - this.m_delta;
        this.m_minSupport = this.m_minSupport < this.m_lowerBoundMinSupport ? this.m_lowerBoundMinSupport : this.m_minSupport;
        do {
            int n2;
            int n3;
            this.m_Ls = new FastVector();
            this.m_hashtables = new FastVector();
            this.m_allTheRules = new FastVector[6];
            this.m_allTheRules[0] = new FastVector();
            this.m_allTheRules[1] = new FastVector();
            this.m_allTheRules[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3] = new FastVector();
                this.m_allTheRules[4] = new FastVector();
                this.m_allTheRules[5] = new FastVector();
            }
            FastVector[] fastVectorArray = new FastVector[6];
            fastVectorArray[0] = new FastVector();
            fastVectorArray[1] = new FastVector();
            fastVectorArray[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                fastVectorArray[3] = new FastVector();
                fastVectorArray[4] = new FastVector();
                fastVectorArray[5] = new FastVector();
            }
            this.findLargeItemSets(instances);
            if (this.m_significanceLevel != -1.0 || this.m_metricType != 0) {
                this.findRulesBruteForce();
            } else {
                this.findRulesQuickly();
            }
            double[] dArray = new double[this.m_allTheRules[2].size()];
            for (n3 = 0; n3 < this.m_allTheRules[2].size(); ++n3) {
                dArray[n3] = ((AprioriItemSet)this.m_allTheRules[1].elementAt(n3)).support();
            }
            int[] nArray = Utils.stableSort(dArray);
            for (n3 = 0; n3 < this.m_allTheRules[2].size(); ++n3) {
                fastVectorArray[0].addElement(this.m_allTheRules[0].elementAt(nArray[n3]));
                fastVectorArray[1].addElement(this.m_allTheRules[1].elementAt(nArray[n3]));
                fastVectorArray[2].addElement(this.m_allTheRules[2].elementAt(nArray[n3]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                fastVectorArray[3].addElement(this.m_allTheRules[3].elementAt(nArray[n3]));
                fastVectorArray[4].addElement(this.m_allTheRules[4].elementAt(nArray[n3]));
                fastVectorArray[5].addElement(this.m_allTheRules[5].elementAt(nArray[n3]));
            }
            this.m_allTheRules[0].removeAllElements();
            this.m_allTheRules[1].removeAllElements();
            this.m_allTheRules[2].removeAllElements();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3].removeAllElements();
                this.m_allTheRules[4].removeAllElements();
                this.m_allTheRules[5].removeAllElements();
            }
            double[] dArray2 = new double[fastVectorArray[2].size()];
            n3 = 2 + this.m_metricType;
            for (n2 = 0; n2 < fastVectorArray[2].size(); ++n2) {
                dArray2[n2] = (Double)fastVectorArray[n3].elementAt(n2);
            }
            nArray = Utils.stableSort(dArray2);
            for (n2 = fastVectorArray[0].size() - 1; n2 >= fastVectorArray[0].size() - this.m_numRules && n2 >= 0; --n2) {
                this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(nArray[n2]));
                this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(nArray[n2]));
                this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(nArray[n2]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                this.m_allTheRules[3].addElement(fastVectorArray[3].elementAt(nArray[n2]));
                this.m_allTheRules[4].addElement(fastVectorArray[4].elementAt(nArray[n2]));
                this.m_allTheRules[5].addElement(fastVectorArray[5].elementAt(nArray[n2]));
            }
            if (this.m_verbose && this.m_Ls.size() > 1) {
                System.out.println(this.toString());
            }
            this.m_minSupport -= this.m_delta;
            n = (int)(this.m_minSupport * (double)instances.numInstances() + 0.5);
            ++this.m_cycles;
        } while (this.m_allTheRules[0].size() < this.m_numRules && Utils.grOrEq(this.m_minSupport, this.m_lowerBoundMinSupport) && n >= 1);
        this.m_minSupport += this.m_delta;
    }

    public Enumeration listOptions() {
        String string = LocalString.get("\tThe required number of rules. (default = ") + this.m_numRules + ")";
        String string2 = LocalString.get("\tThe minimum confidence of a rule. (default = ") + this.m_minMetric + ")";
        String string3 = LocalString.get("\tThe delta by which the minimum support is decreased in\n");
        String string4 = LocalString.get("\teach iteration. (default = ") + this.m_delta + ")";
        String string5 = LocalString.get("\tThe lower bound for the minimum support. (default = ") + this.m_lowerBoundMinSupport + ")";
        String string6 = LocalString.get("\tIf used, rules are tested for significance at\n");
        String string7 = LocalString.get("\tthe given level. Slower. (default = no significance testing)");
        String string8 = LocalString.get("\tIf set the itemsets found are also output. (default = no)");
        String string9 = LocalString.get("\tThe metric type by which to rank rules. (default = ") + LocalString.get("confidence)");
        FastVector fastVector = new FastVector(9);
        fastVector.addElement(new Option(string, "N", 1, LocalString.get("-N <required number of rules output>")));
        fastVector.addElement(new Option(string9, "T", 1, LocalString.get("-T <0=confidence | 1=lift | ") + LocalString.get("2=leverage | 3=Conviction>")));
        fastVector.addElement(new Option(string2, "C", 1, LocalString.get("-C <minimum metric score of a rule>")));
        fastVector.addElement(new Option(string3 + string4, "D", 1, LocalString.get("-D <delta for minimum support>")));
        fastVector.addElement(new Option(LocalString.get("\tUpper bound for minimum support. ") + LocalString.get("(default = 1.0)"), "U", 1, LocalString.get("-U <upper bound for minimum support>")));
        fastVector.addElement(new Option(string5, "M", 1, LocalString.get("-M <lower bound for minimum support>")));
        fastVector.addElement(new Option(string6 + string7, "S", 1, LocalString.get("-S <significance level>")));
        fastVector.addElement(new Option(string8, "S", 0, "-I"));
        fastVector.addElement(new Option(LocalString.get("\tRemove columns that contain ") + LocalString.get("all missing values (default = no)"), "R", 0, "-R"));
        fastVector.addElement(new Option(LocalString.get("\tReport progress iteratively. (default ") + "= no)", "V", 0, "-V"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('N', stringArray);
        String string2 = Utils.getOption('C', stringArray);
        String string3 = Utils.getOption('D', stringArray);
        String string4 = Utils.getOption('U', stringArray);
        String string5 = Utils.getOption('M', stringArray);
        String string6 = Utils.getOption('S', stringArray);
        String string7 = Utils.getOption('T', stringArray);
        if (string7.length() != 0) {
            this.setMetricType(new SelectedTag(Integer.parseInt(string7), TAGS_SELECTION));
        }
        if (string.length() != 0) {
            this.m_numRules = Integer.parseInt(string);
        }
        if (string2.length() != 0) {
            this.m_minMetric = new Double(string2);
        }
        if (string3.length() != 0) {
            this.m_delta = new Double(string3);
        }
        if (string4.length() != 0) {
            this.setUpperBoundMinSupport(new Double(string4));
        }
        if (string5.length() != 0) {
            this.m_lowerBoundMinSupport = new Double(string5);
        }
        if (string6.length() != 0) {
            this.m_significanceLevel = new Double(string6);
        }
        this.m_outputItemSets = Utils.getFlag('I', stringArray);
        this.m_verbose = Utils.getFlag('V', stringArray);
        this.setRemoveAllMissingCols(Utils.getFlag('R', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[16];
        int n = 0;
        if (this.m_outputItemSets) {
            stringArray[n++] = "-I";
        }
        if (this.getRemoveAllMissingCols()) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_numRules;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.m_metricType;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_minMetric;
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.m_delta;
        stringArray[n++] = "-U";
        stringArray[n++] = "" + this.m_upperBoundMinSupport;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_lowerBoundMinSupport;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_significanceLevel;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Ls.size() <= 1) {
            return LocalString.get("\nNo large itemsets and rules found!\n");
        }
        stringBuffer.append(LocalString.get("\nApriori\n=======\n\n"));
        stringBuffer.append(LocalString.get("Minimum support: ") + Utils.doubleToString(this.m_minSupport, 2) + '\n');
        stringBuffer.append(LocalString.get("Minimum metric <"));
        switch (this.m_metricType) {
            case 0: {
                stringBuffer.append(LocalString.get("confidence>: "));
                break;
            }
            case 1: {
                stringBuffer.append(LocalString.get("lift>: "));
                break;
            }
            case 2: {
                stringBuffer.append(LocalString.get("leverage>: "));
                break;
            }
            case 3: {
                stringBuffer.append(LocalString.get("conviction>: "));
            }
        }
        stringBuffer.append(Utils.doubleToString(this.m_minMetric, 2) + '\n');
        if (this.m_significanceLevel != -1.0) {
            stringBuffer.append(LocalString.get("Significance level: ") + Utils.doubleToString(this.m_significanceLevel, 2) + '\n');
        }
        stringBuffer.append(LocalString.get("Number of cycles performed: ") + this.m_cycles + '\n');
        stringBuffer.append(LocalString.get("\nGenerated sets of large itemsets:\n"));
        for (n = 0; n < this.m_Ls.size(); ++n) {
            stringBuffer.append(LocalString.get("\nSize of set of large itemsets L(") + (n + 1) + "): " + ((FastVector)this.m_Ls.elementAt(n)).size() + '\n');
            if (!this.m_outputItemSets) continue;
            stringBuffer.append(LocalString.get("\nLarge Itemsets L(") + (n + 1) + "):\n");
            for (int i = 0; i < ((FastVector)this.m_Ls.elementAt(n)).size(); ++i) {
                stringBuffer.append(((AprioriItemSet)((FastVector)this.m_Ls.elementAt(n)).elementAt(i)).toString(this.m_instances) + "\n");
            }
        }
        stringBuffer.append(LocalString.get("\nBest rules found:\n\n"));
        for (n = 0; n < this.m_allTheRules[0].size(); ++n) {
            stringBuffer.append(Utils.doubleToString((double)n + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((AprioriItemSet)this.m_allTheRules[0].elementAt(n)).toString(this.m_instances) + " ==> " + ((AprioriItemSet)this.m_allTheRules[1].elementAt(n)).toString(this.m_instances) + LocalString.get("    conf:(") + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(n), 2) + ")");
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                stringBuffer.append((this.m_metricType == 1 ? " <" : "") + LocalString.get(" lift:(") + Utils.doubleToString((Double)this.m_allTheRules[3].elementAt(n), 2) + ")" + (this.m_metricType == 1 ? ">" : ""));
                stringBuffer.append((this.m_metricType == 2 ? " <" : "") + LocalString.get(" lev:(") + Utils.doubleToString((Double)this.m_allTheRules[4].elementAt(n), 2) + ")");
                stringBuffer.append(" [" + (int)((Double)this.m_allTheRules[4].elementAt(n) * (double)this.m_instances.numInstances()) + "]" + (this.m_metricType == 2 ? ">" : ""));
                stringBuffer.append((this.m_metricType == 3 ? " <" : "") + LocalString.get(" conv:(") + Utils.doubleToString((Double)this.m_allTheRules[5].elementAt(n), 2) + ")" + (this.m_metricType == 3 ? ">" : ""));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String removeAllMissingColsTipText() {
        return LocalString.get("Remove columns with all missing values.");
    }

    public void setRemoveAllMissingCols(boolean bl) {
        this.m_removeMissingCols = bl;
    }

    public boolean getRemoveAllMissingCols() {
        return this.m_removeMissingCols;
    }

    public String upperBoundMinSupportTipText() {
        return LocalString.get("Upper bound for minimum support. Start iteratively decreasing ") + LocalString.get("minimum support from this value.");
    }

    public double getUpperBoundMinSupport() {
        return this.m_upperBoundMinSupport;
    }

    public void setUpperBoundMinSupport(double d) {
        this.m_upperBoundMinSupport = d;
    }

    public String lowerBoundMinSupportTipText() {
        return LocalString.get("Lower bound for minimum support.");
    }

    public double getLowerBoundMinSupport() {
        return this.m_lowerBoundMinSupport;
    }

    public void setLowerBoundMinSupport(double d) {
        this.m_lowerBoundMinSupport = d;
    }

    public SelectedTag getMetricType() {
        return new SelectedTag(this.m_metricType, TAGS_SELECTION);
    }

    public String metricTypeTipText() {
        return LocalString.get("Set the type of metric by which to rank rules. Confidence is ") + LocalString.get("the proportion of the examples covered by the premise that are also ") + LocalString.get("covered by the consequence. Lift is confidence divided by the ") + LocalString.get("proportion of all examples that are covered by the consequence. This ") + LocalString.get("is a measure of the importance of the association that is independent ") + LocalString.get("of support. Leverage is the proportion of additional examples covered ") + LocalString.get("by both the premise and consequence above those expected if the ") + LocalString.get("premise and consequence were independent of each other. The total ") + LocalString.get("number of examples that this represents is presented in brackets ") + LocalString.get("following the leverage. Conviction is ") + LocalString.get("another measure of departure from independence and furthermore takes into ") + LocalString.get("account implicaton. Conviction is given ") + LocalString.get("by P(premise)P(!consequence) / P(premise, !consequence).");
    }

    public void setMetricType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_metricType = selectedTag.getSelectedTag().getID();
        }
        if (this.m_significanceLevel != -1.0 && this.m_metricType != 0) {
            this.m_metricType = 0;
        }
        if (this.m_metricType == 0) {
            this.setMinMetric(0.9);
        }
        if (this.m_metricType == 1 || this.m_metricType == 3) {
            this.setMinMetric(1.1);
        }
        if (this.m_metricType == 2) {
            this.setMinMetric(0.1);
        }
    }

    public String minMetricTipText() {
        return LocalString.get("Minimum metric score. Consider only rules with scores higher than ") + LocalString.get("this value.");
    }

    public double getMinMetric() {
        return this.m_minMetric;
    }

    public void setMinMetric(double d) {
        this.m_minMetric = d;
    }

    public String numRulesTipText() {
        return LocalString.get("Number of rules to find.");
    }

    public int getNumRules() {
        return this.m_numRules;
    }

    public void setNumRules(int n) {
        this.m_numRules = n;
    }

    public String deltaTipText() {
        return LocalString.get("Iteratively decrease support by this factor. Reduces support ") + LocalString.get("until min support is reached or required number of rules has been ") + LocalString.get("generated.");
    }

    public double getDelta() {
        return this.m_delta;
    }

    public void setDelta(double d) {
        this.m_delta = d;
    }

    public String significanceLevelTipText() {
        return LocalString.get("Significance level. Significance test (confidence metric only).");
    }

    public double getSignificanceLevel() {
        return this.m_significanceLevel;
    }

    public void setSignificanceLevel(double d) {
        this.m_significanceLevel = d;
    }

    private void findLargeItemSets(Instances instances) throws Exception {
        int n = 0;
        this.m_instances = instances;
        int n2 = (int)(this.m_minSupport * (double)instances.numInstances() + 0.5);
        int n3 = (int)(this.m_upperBoundMinSupport * (double)instances.numInstances() + 0.5);
        FastVector fastVector = AprioriItemSet.singletons(instances);
        AprioriItemSet.upDateCounters(fastVector, instances);
        fastVector = AprioriItemSet.deleteItemSets(fastVector, n2, n3);
        if (fastVector.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement(fastVector);
            FastVector fastVector2 = fastVector;
            fastVector = AprioriItemSet.mergeAllItemSets(fastVector2, n, instances.numInstances());
            Hashtable hashtable = AprioriItemSet.getHashtable(fastVector2, fastVector2.size());
            this.m_hashtables.addElement(hashtable);
            fastVector = AprioriItemSet.pruneItemSets(fastVector, hashtable);
            AprioriItemSet.upDateCounters(fastVector, instances);
            fastVector = AprioriItemSet.deleteItemSets(fastVector, n2, n3);
            ++n;
        } while (fastVector.size() > 0);
    }

    private void findRulesBruteForce() throws Exception {
        for (int i = 1; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                AprioriItemSet aprioriItemSet = (AprioriItemSet)enumeration.nextElement();
                FastVector[] fastVectorArray = aprioriItemSet.generateRulesBruteForce(this.m_minMetric, this.m_metricType, this.m_hashtables, i + 1, this.m_instances.numInstances(), this.m_significanceLevel);
                for (int j = 0; j < fastVectorArray[0].size(); ++j) {
                    this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(j));
                    this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(j));
                    this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(j));
                    this.m_allTheRules[3].addElement(fastVectorArray[3].elementAt(j));
                    this.m_allTheRules[4].addElement(fastVectorArray[4].elementAt(j));
                    this.m_allTheRules[5].addElement(fastVectorArray[5].elementAt(j));
                }
            }
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int i = 1; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                AprioriItemSet aprioriItemSet = (AprioriItemSet)enumeration.nextElement();
                FastVector[] fastVectorArray = aprioriItemSet.generateRules(this.m_minMetric, this.m_hashtables, i + 1);
                for (int j = 0; j < fastVectorArray[0].size(); ++j) {
                    this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(j));
                    this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(j));
                    this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(j));
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Apriori apriori = new Apriori();
        try {
            stringBuffer.append(LocalString.get("\n\nApriori options:\n\n"));
            stringBuffer.append(LocalString.get("-t <training file>\n"));
            stringBuffer.append(LocalString.get("\tThe name of the training file.\n"));
            Enumeration enumeration = apriori.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + '\n');
            }
            String string = Utils.getOption('t', stringArray);
            if (string.length() == 0) {
                throw new Exception(LocalString.get("No training file given!"));
            }
            apriori.setOptions(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            apriori.buildAssociations(new Instances(bufferedReader));
            System.out.println(apriori);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage() + stringBuffer);
        }
    }
}

