/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*
 *    Stopwords.java
 *    Copyright (C) 2001 Eibe Frank
 */

package weka.core;

import java.util.*;

/**
 * Class that can test whether a given string is a stop word.
 * Lowercases all words before the test.
 *
 * @author Eibe Frank (eibe@cs.waikato.ac.nz)
 * @author Ashraf M. Kibriya (amk14@cs.waikato.ac.nz)
 * @version $Revision: 1.1.2.1 $
 */
public class Stopwords {
  
  /** The hashtable containing the list of stopwords */
  private static Hashtable m_Stopwords = null;

  static {
   
    if (m_Stopwords == null) {
      m_Stopwords = new Hashtable();
      Double dummy = new Double(0);

      
      //Stopwords list from Rainbow
      m_Stopwords.put("a", dummy);
      m_Stopwords.put(weka.LocalString.get("able"), dummy);
      m_Stopwords.put(weka.LocalString.get("about"), dummy);
      m_Stopwords.put(weka.LocalString.get("above"), dummy);
      m_Stopwords.put(weka.LocalString.get("according"), dummy);
      m_Stopwords.put(weka.LocalString.get("accordingly"), dummy);
      m_Stopwords.put(weka.LocalString.get("across"), dummy);
      m_Stopwords.put(weka.LocalString.get("actually"), dummy);
      m_Stopwords.put(weka.LocalString.get("after"), dummy);
      m_Stopwords.put(weka.LocalString.get("afterwards"), dummy);
      m_Stopwords.put(weka.LocalString.get("again"), dummy);
      m_Stopwords.put(weka.LocalString.get("against"), dummy);
      m_Stopwords.put(weka.LocalString.get("all"), dummy);
      m_Stopwords.put(weka.LocalString.get("allow"), dummy);
      m_Stopwords.put(weka.LocalString.get("allows"), dummy);
      m_Stopwords.put(weka.LocalString.get("almost"), dummy);
      m_Stopwords.put(weka.LocalString.get("alone"), dummy);
      m_Stopwords.put(weka.LocalString.get("along"), dummy);
      m_Stopwords.put(weka.LocalString.get("already"), dummy);
      m_Stopwords.put(weka.LocalString.get("also"), dummy);
      m_Stopwords.put(weka.LocalString.get("although"), dummy);
      m_Stopwords.put(weka.LocalString.get("always"), dummy);
      m_Stopwords.put("am", dummy);
      m_Stopwords.put(weka.LocalString.get("among"), dummy);
      m_Stopwords.put(weka.LocalString.get("amongst"), dummy);
      m_Stopwords.put("an", dummy);
      m_Stopwords.put(weka.LocalString.get("and"), dummy);
      m_Stopwords.put(weka.LocalString.get("another"), dummy);
      m_Stopwords.put(weka.LocalString.get("any"), dummy);
      m_Stopwords.put(weka.LocalString.get("anybody"), dummy);
      m_Stopwords.put(weka.LocalString.get("anyhow"), dummy);
      m_Stopwords.put(weka.LocalString.get("anyone"), dummy);
      m_Stopwords.put(weka.LocalString.get("anything"), dummy);
      m_Stopwords.put(weka.LocalString.get("anyway"), dummy);
      m_Stopwords.put(weka.LocalString.get("anyways"), dummy);
      m_Stopwords.put(weka.LocalString.get("anywhere"), dummy);
      m_Stopwords.put(weka.LocalString.get("apart"), dummy);
      m_Stopwords.put(weka.LocalString.get("appear"), dummy);
      m_Stopwords.put(weka.LocalString.get("appreciate"), dummy);
      m_Stopwords.put(weka.LocalString.get("appropriate"), dummy);
      m_Stopwords.put(weka.LocalString.get("are"), dummy);
      m_Stopwords.put(weka.LocalString.get("around"), dummy);
      m_Stopwords.put("as", dummy);
      m_Stopwords.put(weka.LocalString.get("aside"), dummy);
      m_Stopwords.put(weka.LocalString.get("ask"), dummy);
      m_Stopwords.put(weka.LocalString.get("asking"), dummy);
      m_Stopwords.put(weka.LocalString.get("associated"), dummy);
      m_Stopwords.put("at", dummy);
      m_Stopwords.put(weka.LocalString.get("available"), dummy);
      m_Stopwords.put(weka.LocalString.get("away"), dummy);
      m_Stopwords.put(weka.LocalString.get("awfully"), dummy);
      m_Stopwords.put("b", dummy);
      m_Stopwords.put("be", dummy);
      m_Stopwords.put(weka.LocalString.get("became"), dummy);
      m_Stopwords.put(weka.LocalString.get("because"), dummy);
      m_Stopwords.put(weka.LocalString.get("become"), dummy);
      m_Stopwords.put(weka.LocalString.get("becomes"), dummy);
      m_Stopwords.put(weka.LocalString.get("becoming"), dummy);
      m_Stopwords.put(weka.LocalString.get("been"), dummy);
      m_Stopwords.put(weka.LocalString.get("before"), dummy);
      m_Stopwords.put(weka.LocalString.get("beforehand"), dummy);
      m_Stopwords.put(weka.LocalString.get("behind"), dummy);
      m_Stopwords.put(weka.LocalString.get("being"), dummy);
      m_Stopwords.put(weka.LocalString.get("believe"), dummy);
      m_Stopwords.put(weka.LocalString.get("below"), dummy);
      m_Stopwords.put(weka.LocalString.get("beside"), dummy);
      m_Stopwords.put(weka.LocalString.get("besides"), dummy);
      m_Stopwords.put(weka.LocalString.get("best"), dummy);
      m_Stopwords.put(weka.LocalString.get("better"), dummy);
      m_Stopwords.put(weka.LocalString.get("between"), dummy);
      m_Stopwords.put(weka.LocalString.get("beyond"), dummy);
      m_Stopwords.put(weka.LocalString.get("both"), dummy);
      m_Stopwords.put(weka.LocalString.get("brief"), dummy);
      m_Stopwords.put(weka.LocalString.get("but"), dummy);
      m_Stopwords.put("by", dummy);
      m_Stopwords.put("c", dummy);
      m_Stopwords.put(weka.LocalString.get("came"), dummy);
      m_Stopwords.put(weka.LocalString.get("can"), dummy);
      m_Stopwords.put(weka.LocalString.get("cannot"), dummy);
      m_Stopwords.put(weka.LocalString.get("cant"), dummy);
      m_Stopwords.put(weka.LocalString.get("cause"), dummy);
      m_Stopwords.put(weka.LocalString.get("causes"), dummy);
      m_Stopwords.put(weka.LocalString.get("certain"), dummy);
      m_Stopwords.put(weka.LocalString.get("certainly"), dummy);
      m_Stopwords.put(weka.LocalString.get("changes"), dummy);
      m_Stopwords.put(weka.LocalString.get("clearly"), dummy);
      m_Stopwords.put("co", dummy);
      m_Stopwords.put(weka.LocalString.get("com"), dummy);
      m_Stopwords.put(weka.LocalString.get("come"), dummy);
      m_Stopwords.put(weka.LocalString.get("comes"), dummy);
      m_Stopwords.put(weka.LocalString.get("concerning"), dummy);
      m_Stopwords.put(weka.LocalString.get("consequently"), dummy);
      m_Stopwords.put(weka.LocalString.get("consider"), dummy);
      m_Stopwords.put(weka.LocalString.get("considering"), dummy);
      m_Stopwords.put(weka.LocalString.get("contain"), dummy);
      m_Stopwords.put(weka.LocalString.get("containing"), dummy);
      m_Stopwords.put(weka.LocalString.get("contains"), dummy);
      m_Stopwords.put(weka.LocalString.get("corresponding"), dummy);
      m_Stopwords.put(weka.LocalString.get("could"), dummy);
      m_Stopwords.put(weka.LocalString.get("course"), dummy);
      m_Stopwords.put(weka.LocalString.get("currently"), dummy);
      m_Stopwords.put("d", dummy);
      m_Stopwords.put(weka.LocalString.get("definitely"), dummy);
      m_Stopwords.put(weka.LocalString.get("described"), dummy);
      m_Stopwords.put(weka.LocalString.get("despite"), dummy);
      m_Stopwords.put(weka.LocalString.get("did"), dummy);
      m_Stopwords.put(weka.LocalString.get("different"), dummy);
      m_Stopwords.put("do", dummy);
      m_Stopwords.put(weka.LocalString.get("does"), dummy);
      m_Stopwords.put(weka.LocalString.get("doing"), dummy);
      m_Stopwords.put(weka.LocalString.get("done"), dummy);
      m_Stopwords.put(weka.LocalString.get("down"), dummy);
      m_Stopwords.put(weka.LocalString.get("downwards"), dummy);
      m_Stopwords.put(weka.LocalString.get("during"), dummy);
      m_Stopwords.put("e", dummy);
      m_Stopwords.put(weka.LocalString.get("each"), dummy);
      m_Stopwords.put(weka.LocalString.get("edu"), dummy);
      m_Stopwords.put("eg", dummy);
      m_Stopwords.put(weka.LocalString.get("eight"), dummy);
      m_Stopwords.put(weka.LocalString.get("either"), dummy);
      m_Stopwords.put(weka.LocalString.get("else"), dummy);
      m_Stopwords.put(weka.LocalString.get("elsewhere"), dummy);
      m_Stopwords.put(weka.LocalString.get("enough"), dummy);
      m_Stopwords.put(weka.LocalString.get("entirely"), dummy);
      m_Stopwords.put(weka.LocalString.get("especially"), dummy);
      m_Stopwords.put("et", dummy);
      m_Stopwords.put(weka.LocalString.get("etc"), dummy);
      m_Stopwords.put(weka.LocalString.get("even"), dummy);
      m_Stopwords.put(weka.LocalString.get("ever"), dummy);
      m_Stopwords.put(weka.LocalString.get("every"), dummy);
      m_Stopwords.put(weka.LocalString.get("everybody"), dummy);
      m_Stopwords.put(weka.LocalString.get("everyone"), dummy);
      m_Stopwords.put(weka.LocalString.get("everything"), dummy);
      m_Stopwords.put(weka.LocalString.get("everywhere"), dummy);
      m_Stopwords.put("ex", dummy);
      m_Stopwords.put(weka.LocalString.get("exactly"), dummy);
      m_Stopwords.put(weka.LocalString.get("example"), dummy);
      m_Stopwords.put(weka.LocalString.get("except"), dummy);
      m_Stopwords.put("f", dummy);
      m_Stopwords.put(weka.LocalString.get("far"), dummy);
      m_Stopwords.put(weka.LocalString.get("few"), dummy);
      m_Stopwords.put(weka.LocalString.get("fifth"), dummy);
      m_Stopwords.put(weka.LocalString.get("first"), dummy);
      m_Stopwords.put(weka.LocalString.get("five"), dummy);
      m_Stopwords.put(weka.LocalString.get("followed"), dummy);
      m_Stopwords.put(weka.LocalString.get("following"), dummy);
      m_Stopwords.put(weka.LocalString.get("follows"), dummy);
      m_Stopwords.put(weka.LocalString.get("for"), dummy);
      m_Stopwords.put(weka.LocalString.get("former"), dummy);
      m_Stopwords.put(weka.LocalString.get("formerly"), dummy);
      m_Stopwords.put(weka.LocalString.get("forth"), dummy);
      m_Stopwords.put(weka.LocalString.get("four"), dummy);
      m_Stopwords.put(weka.LocalString.get("from"), dummy);
      m_Stopwords.put(weka.LocalString.get("further"), dummy);
      m_Stopwords.put(weka.LocalString.get("furthermore"), dummy);
      m_Stopwords.put("g", dummy);
      m_Stopwords.put(weka.LocalString.get("get"), dummy);
      m_Stopwords.put(weka.LocalString.get("gets"), dummy);
      m_Stopwords.put(weka.LocalString.get("getting"), dummy);
      m_Stopwords.put(weka.LocalString.get("given"), dummy);
      m_Stopwords.put(weka.LocalString.get("gives"), dummy);
      m_Stopwords.put("go", dummy);
      m_Stopwords.put(weka.LocalString.get("goes"), dummy);
      m_Stopwords.put(weka.LocalString.get("going"), dummy);
      m_Stopwords.put(weka.LocalString.get("gone"), dummy);
      m_Stopwords.put(weka.LocalString.get("got"), dummy);
      m_Stopwords.put(weka.LocalString.get("gotten"), dummy);
      m_Stopwords.put(weka.LocalString.get("greetings"), dummy);
      m_Stopwords.put("h", dummy);
      m_Stopwords.put(weka.LocalString.get("had"), dummy);
      m_Stopwords.put(weka.LocalString.get("happens"), dummy);
      m_Stopwords.put(weka.LocalString.get("hardly"), dummy);
      m_Stopwords.put(weka.LocalString.get("has"), dummy);
      m_Stopwords.put(weka.LocalString.get("have"), dummy);
      m_Stopwords.put(weka.LocalString.get("having"), dummy);
      m_Stopwords.put("he", dummy);
      m_Stopwords.put(weka.LocalString.get("hello"), dummy);
      m_Stopwords.put(weka.LocalString.get("help"), dummy);
      m_Stopwords.put(weka.LocalString.get("hence"), dummy);
      m_Stopwords.put(weka.LocalString.get("her"), dummy);
      m_Stopwords.put(weka.LocalString.get("here"), dummy);
      m_Stopwords.put(weka.LocalString.get("hereafter"), dummy);
      m_Stopwords.put(weka.LocalString.get("hereby"), dummy);
      m_Stopwords.put(weka.LocalString.get("herein"), dummy);
      m_Stopwords.put(weka.LocalString.get("hereupon"), dummy);
      m_Stopwords.put(weka.LocalString.get("hers"), dummy);
      m_Stopwords.put(weka.LocalString.get("herself"), dummy);
      m_Stopwords.put("hi", dummy);
      m_Stopwords.put(weka.LocalString.get("him"), dummy);
      m_Stopwords.put(weka.LocalString.get("himself"), dummy);
      m_Stopwords.put(weka.LocalString.get("his"), dummy);
      m_Stopwords.put(weka.LocalString.get("hither"), dummy);
      m_Stopwords.put(weka.LocalString.get("hopefully"), dummy);
      m_Stopwords.put(weka.LocalString.get("how"), dummy);
      m_Stopwords.put(weka.LocalString.get("howbeit"), dummy);
      m_Stopwords.put(weka.LocalString.get("however"), dummy);
      m_Stopwords.put("i", dummy);
      m_Stopwords.put("ie", dummy);
      m_Stopwords.put("if", dummy);
      m_Stopwords.put(weka.LocalString.get("ignored"), dummy);
      m_Stopwords.put(weka.LocalString.get("immediate"), dummy);
      m_Stopwords.put("in", dummy);
      m_Stopwords.put(weka.LocalString.get("inasmuch"), dummy);
      m_Stopwords.put(weka.LocalString.get("inc"), dummy);
      m_Stopwords.put(weka.LocalString.get("indeed"), dummy);
      m_Stopwords.put(weka.LocalString.get("indicate"), dummy);
      m_Stopwords.put(weka.LocalString.get("indicated"), dummy);
      m_Stopwords.put(weka.LocalString.get("indicates"), dummy);
      m_Stopwords.put(weka.LocalString.get("inner"), dummy);
      m_Stopwords.put(weka.LocalString.get("insofar"), dummy);
      m_Stopwords.put(weka.LocalString.get("instead"), dummy);
      m_Stopwords.put(weka.LocalString.get("into"), dummy);
      m_Stopwords.put(weka.LocalString.get("inward"), dummy);
      m_Stopwords.put("is", dummy);
      m_Stopwords.put("it", dummy);
      m_Stopwords.put(weka.LocalString.get("its"), dummy);
      m_Stopwords.put(weka.LocalString.get("itself"), dummy);
      m_Stopwords.put("j", dummy);
      m_Stopwords.put(weka.LocalString.get("just"), dummy);
      m_Stopwords.put("k", dummy);
      m_Stopwords.put(weka.LocalString.get("keep"), dummy);
      m_Stopwords.put(weka.LocalString.get("keeps"), dummy);
      m_Stopwords.put(weka.LocalString.get("kept"), dummy);
      m_Stopwords.put(weka.LocalString.get("know"), dummy);
      m_Stopwords.put(weka.LocalString.get("knows"), dummy);
      m_Stopwords.put(weka.LocalString.get("known"), dummy);
      m_Stopwords.put("l", dummy);
      m_Stopwords.put(weka.LocalString.get("last"), dummy);
      m_Stopwords.put(weka.LocalString.get("lately"), dummy);
      m_Stopwords.put(weka.LocalString.get("later"), dummy);
      m_Stopwords.put(weka.LocalString.get("latter"), dummy);
      m_Stopwords.put(weka.LocalString.get("latterly"), dummy);
      m_Stopwords.put(weka.LocalString.get("least"), dummy);
      m_Stopwords.put(weka.LocalString.get("less"), dummy);
      m_Stopwords.put(weka.LocalString.get("lest"), dummy);
      m_Stopwords.put(weka.LocalString.get("let"), dummy);
      m_Stopwords.put(weka.LocalString.get("like"), dummy);
      m_Stopwords.put(weka.LocalString.get("liked"), dummy);
      m_Stopwords.put(weka.LocalString.get("likely"), dummy);
      m_Stopwords.put(weka.LocalString.get("little"), dummy);
      m_Stopwords.put("ll", dummy); //added to avoid words like you'll,I'll etc.
      m_Stopwords.put(weka.LocalString.get("look"), dummy);
      m_Stopwords.put(weka.LocalString.get("looking"), dummy);
      m_Stopwords.put(weka.LocalString.get("looks"), dummy);
      m_Stopwords.put(weka.LocalString.get("ltd"), dummy);
      m_Stopwords.put("m", dummy);
      m_Stopwords.put(weka.LocalString.get("mainly"), dummy);
      m_Stopwords.put(weka.LocalString.get("many"), dummy);
      m_Stopwords.put(weka.LocalString.get("may"), dummy);
      m_Stopwords.put(weka.LocalString.get("maybe"), dummy);
      m_Stopwords.put("me", dummy);
      m_Stopwords.put(weka.LocalString.get("mean"), dummy);
      m_Stopwords.put(weka.LocalString.get("meanwhile"), dummy);
      m_Stopwords.put(weka.LocalString.get("merely"), dummy);
      m_Stopwords.put(weka.LocalString.get("might"), dummy);
      m_Stopwords.put(weka.LocalString.get("more"), dummy);
      m_Stopwords.put(weka.LocalString.get("moreover"), dummy);
      m_Stopwords.put(weka.LocalString.get("most"), dummy);
      m_Stopwords.put(weka.LocalString.get("mostly"), dummy);
      m_Stopwords.put(weka.LocalString.get("much"), dummy);
      m_Stopwords.put(weka.LocalString.get("must"), dummy);
      m_Stopwords.put("my", dummy);
      m_Stopwords.put(weka.LocalString.get("myself"), dummy);
      m_Stopwords.put("n", dummy);
      m_Stopwords.put(weka.LocalString.get("name"), dummy);
      m_Stopwords.put(weka.LocalString.get("namely"), dummy);
      m_Stopwords.put("nd", dummy);
      m_Stopwords.put(weka.LocalString.get("near"), dummy);
      m_Stopwords.put(weka.LocalString.get("nearly"), dummy);
      m_Stopwords.put(weka.LocalString.get("necessary"), dummy);
      m_Stopwords.put(weka.LocalString.get("need"), dummy);
      m_Stopwords.put(weka.LocalString.get("needs"), dummy);
      m_Stopwords.put(weka.LocalString.get("neither"), dummy);
      m_Stopwords.put(weka.LocalString.get("never"), dummy);
      m_Stopwords.put(weka.LocalString.get("nevertheless"), dummy);
      m_Stopwords.put(weka.LocalString.get("new"), dummy);
      m_Stopwords.put(weka.LocalString.get("next"), dummy);
      m_Stopwords.put(weka.LocalString.get("nine"), dummy);
      m_Stopwords.put("no", dummy);
      m_Stopwords.put(weka.LocalString.get("nobody"), dummy);
      m_Stopwords.put(weka.LocalString.get("non"), dummy);
      m_Stopwords.put(weka.LocalString.get("none"), dummy);
      m_Stopwords.put(weka.LocalString.get("noone"), dummy);
      m_Stopwords.put(weka.LocalString.get("nor"), dummy);
      m_Stopwords.put(weka.LocalString.get("normally"), dummy);
      m_Stopwords.put(weka.LocalString.get("not"), dummy);
      m_Stopwords.put(weka.LocalString.get("nothing"), dummy);
      m_Stopwords.put(weka.LocalString.get("novel"), dummy);
      m_Stopwords.put(weka.LocalString.get("now"), dummy);
      m_Stopwords.put(weka.LocalString.get("nowhere"), dummy);
      m_Stopwords.put("o", dummy);
      m_Stopwords.put(weka.LocalString.get("obviously"), dummy);
      m_Stopwords.put("of", dummy);
      m_Stopwords.put(weka.LocalString.get("off"), dummy);
      m_Stopwords.put(weka.LocalString.get("often"), dummy);
      m_Stopwords.put("oh", dummy);
      m_Stopwords.put("ok", dummy);
      m_Stopwords.put(weka.LocalString.get("okay"), dummy);
      m_Stopwords.put(weka.LocalString.get("old"), dummy);
      m_Stopwords.put("on", dummy);
      m_Stopwords.put(weka.LocalString.get("once"), dummy);
      m_Stopwords.put(weka.LocalString.get("one"), dummy);
      m_Stopwords.put(weka.LocalString.get("ones"), dummy);
      m_Stopwords.put(weka.LocalString.get("only"), dummy);
      m_Stopwords.put(weka.LocalString.get("onto"), dummy);
      m_Stopwords.put("or", dummy);
      m_Stopwords.put(weka.LocalString.get("other"), dummy);
      m_Stopwords.put(weka.LocalString.get("others"), dummy);
      m_Stopwords.put(weka.LocalString.get("otherwise"), dummy);
      m_Stopwords.put(weka.LocalString.get("ought"), dummy);
      m_Stopwords.put(weka.LocalString.get("our"), dummy);
      m_Stopwords.put(weka.LocalString.get("ours"), dummy);
      m_Stopwords.put(weka.LocalString.get("ourselves"), dummy);
      m_Stopwords.put(weka.LocalString.get("out"), dummy);
      m_Stopwords.put(weka.LocalString.get("outside"), dummy);
      m_Stopwords.put(weka.LocalString.get("over"), dummy);
      m_Stopwords.put(weka.LocalString.get("overall"), dummy);
      m_Stopwords.put(weka.LocalString.get("own"), dummy);
      m_Stopwords.put("p", dummy);
      m_Stopwords.put(weka.LocalString.get("particular"), dummy);
      m_Stopwords.put(weka.LocalString.get("particularly"), dummy);
      m_Stopwords.put(weka.LocalString.get("per"), dummy);
      m_Stopwords.put(weka.LocalString.get("perhaps"), dummy);
      m_Stopwords.put(weka.LocalString.get("placed"), dummy);
      m_Stopwords.put(weka.LocalString.get("please"), dummy);
      m_Stopwords.put(weka.LocalString.get("plus"), dummy);
      m_Stopwords.put(weka.LocalString.get("possible"), dummy);
      m_Stopwords.put(weka.LocalString.get("presumably"), dummy);
      m_Stopwords.put(weka.LocalString.get("probably"), dummy);
      m_Stopwords.put(weka.LocalString.get("provides"), dummy);
      m_Stopwords.put("q", dummy);
      m_Stopwords.put(weka.LocalString.get("que"), dummy);
      m_Stopwords.put(weka.LocalString.get("quite"), dummy);
      m_Stopwords.put("qv", dummy);
      m_Stopwords.put("r", dummy);
      m_Stopwords.put(weka.LocalString.get("rather"), dummy);
      m_Stopwords.put("rd", dummy);
      m_Stopwords.put("re", dummy);
      m_Stopwords.put(weka.LocalString.get("really"), dummy);
      m_Stopwords.put(weka.LocalString.get("reasonably"), dummy);
      m_Stopwords.put(weka.LocalString.get("regarding"), dummy);
      m_Stopwords.put(weka.LocalString.get("regardless"), dummy);
      m_Stopwords.put(weka.LocalString.get("regards"), dummy);
      m_Stopwords.put(weka.LocalString.get("relatively"), dummy);
      m_Stopwords.put(weka.LocalString.get("respectively"), dummy);
      m_Stopwords.put(weka.LocalString.get("right"), dummy);
      m_Stopwords.put("s", dummy);
      m_Stopwords.put(weka.LocalString.get("said"), dummy);
      m_Stopwords.put(weka.LocalString.get("same"), dummy);
      m_Stopwords.put(weka.LocalString.get("saw"), dummy);
      m_Stopwords.put(weka.LocalString.get("say"), dummy);
      m_Stopwords.put(weka.LocalString.get("saying"), dummy);
      m_Stopwords.put(weka.LocalString.get("says"), dummy);
      m_Stopwords.put(weka.LocalString.get("second"), dummy);
      m_Stopwords.put(weka.LocalString.get("secondly"), dummy);
      m_Stopwords.put(weka.LocalString.get("see"), dummy);
      m_Stopwords.put(weka.LocalString.get("seeing"), dummy);
      m_Stopwords.put(weka.LocalString.get("seem"), dummy);
      m_Stopwords.put(weka.LocalString.get("seemed"), dummy);
      m_Stopwords.put(weka.LocalString.get("seeming"), dummy);
      m_Stopwords.put(weka.LocalString.get("seems"), dummy);
      m_Stopwords.put(weka.LocalString.get("seen"), dummy);
      m_Stopwords.put(weka.LocalString.get("self"), dummy);
      m_Stopwords.put(weka.LocalString.get("selves"), dummy);
      m_Stopwords.put(weka.LocalString.get("sensible"), dummy);
      m_Stopwords.put(weka.LocalString.get("sent"), dummy);
      m_Stopwords.put(weka.LocalString.get("serious"), dummy);
      m_Stopwords.put(weka.LocalString.get("seriously"), dummy);
      m_Stopwords.put(weka.LocalString.get("seven"), dummy);
      m_Stopwords.put(weka.LocalString.get("several"), dummy);
      m_Stopwords.put(weka.LocalString.get("shall"), dummy);
      m_Stopwords.put(weka.LocalString.get("she"), dummy);
      m_Stopwords.put(weka.LocalString.get("should"), dummy);
      m_Stopwords.put(weka.LocalString.get("since"), dummy);
      m_Stopwords.put(weka.LocalString.get("six"), dummy);
      m_Stopwords.put("so", dummy);
      m_Stopwords.put(weka.LocalString.get("some"), dummy);
      m_Stopwords.put(weka.LocalString.get("somebody"), dummy);
      m_Stopwords.put(weka.LocalString.get("somehow"), dummy);
      m_Stopwords.put(weka.LocalString.get("someone"), dummy);
      m_Stopwords.put(weka.LocalString.get("something"), dummy);
      m_Stopwords.put(weka.LocalString.get("sometime"), dummy);
      m_Stopwords.put(weka.LocalString.get("sometimes"), dummy);
      m_Stopwords.put(weka.LocalString.get("somewhat"), dummy);
      m_Stopwords.put(weka.LocalString.get("somewhere"), dummy);
      m_Stopwords.put(weka.LocalString.get("soon"), dummy);
      m_Stopwords.put(weka.LocalString.get("sorry"), dummy);
      m_Stopwords.put(weka.LocalString.get("specified"), dummy);
      m_Stopwords.put(weka.LocalString.get("specify"), dummy);
      m_Stopwords.put(weka.LocalString.get("specifying"), dummy);
      m_Stopwords.put(weka.LocalString.get("still"), dummy);
      m_Stopwords.put(weka.LocalString.get("sub"), dummy);
      m_Stopwords.put(weka.LocalString.get("such"), dummy);
      m_Stopwords.put(weka.LocalString.get("sup"), dummy);
      m_Stopwords.put(weka.LocalString.get("sure"), dummy);
      m_Stopwords.put("t", dummy);
      m_Stopwords.put(weka.LocalString.get("take"), dummy);
      m_Stopwords.put(weka.LocalString.get("taken"), dummy);
      m_Stopwords.put(weka.LocalString.get("tell"), dummy);
      m_Stopwords.put(weka.LocalString.get("tends"), dummy);
      m_Stopwords.put("th", dummy);
      m_Stopwords.put(weka.LocalString.get("than"), dummy);
      m_Stopwords.put(weka.LocalString.get("thank"), dummy);
      m_Stopwords.put(weka.LocalString.get("thanks"), dummy);
      m_Stopwords.put(weka.LocalString.get("thanx"), dummy);
      m_Stopwords.put(weka.LocalString.get("that"), dummy);
      m_Stopwords.put(weka.LocalString.get("thats"), dummy);
      m_Stopwords.put(weka.LocalString.get("the"), dummy);
      m_Stopwords.put(weka.LocalString.get("their"), dummy);
      m_Stopwords.put(weka.LocalString.get("theirs"), dummy);
      m_Stopwords.put(weka.LocalString.get("them"), dummy);
      m_Stopwords.put(weka.LocalString.get("themselves"), dummy);
      m_Stopwords.put(weka.LocalString.get("then"), dummy);
      m_Stopwords.put(weka.LocalString.get("thence"), dummy);
      m_Stopwords.put(weka.LocalString.get("there"), dummy);
      m_Stopwords.put(weka.LocalString.get("thereafter"), dummy);
      m_Stopwords.put(weka.LocalString.get("thereby"), dummy);
      m_Stopwords.put(weka.LocalString.get("therefore"), dummy);
      m_Stopwords.put(weka.LocalString.get("therein"), dummy);
      m_Stopwords.put(weka.LocalString.get("theres"), dummy);
      m_Stopwords.put(weka.LocalString.get("thereupon"), dummy);
      m_Stopwords.put(weka.LocalString.get("these"), dummy);
      m_Stopwords.put(weka.LocalString.get("they"), dummy);
      m_Stopwords.put(weka.LocalString.get("think"), dummy);
      m_Stopwords.put(weka.LocalString.get("third"), dummy);
      m_Stopwords.put(weka.LocalString.get("this"), dummy);
      m_Stopwords.put(weka.LocalString.get("thorough"), dummy);
      m_Stopwords.put(weka.LocalString.get("thoroughly"), dummy);
      m_Stopwords.put(weka.LocalString.get("those"), dummy);
      m_Stopwords.put(weka.LocalString.get("though"), dummy);
      m_Stopwords.put(weka.LocalString.get("three"), dummy);
      m_Stopwords.put(weka.LocalString.get("through"), dummy);
      m_Stopwords.put(weka.LocalString.get("throughout"), dummy);
      m_Stopwords.put(weka.LocalString.get("thru"), dummy);
      m_Stopwords.put(weka.LocalString.get("thus"), dummy);
      m_Stopwords.put("to", dummy);
      m_Stopwords.put(weka.LocalString.get("together"), dummy);
      m_Stopwords.put(weka.LocalString.get("too"), dummy);
      m_Stopwords.put(weka.LocalString.get("took"), dummy);
      m_Stopwords.put(weka.LocalString.get("toward"), dummy);
      m_Stopwords.put(weka.LocalString.get("towards"), dummy);
      m_Stopwords.put(weka.LocalString.get("tried"), dummy);
      m_Stopwords.put(weka.LocalString.get("tries"), dummy);
      m_Stopwords.put(weka.LocalString.get("truly"), dummy);
      m_Stopwords.put(weka.LocalString.get("try"), dummy);
      m_Stopwords.put(weka.LocalString.get("trying"), dummy);
      m_Stopwords.put(weka.LocalString.get("twice"), dummy);
      m_Stopwords.put(weka.LocalString.get("two"), dummy);
      m_Stopwords.put("u", dummy);
      m_Stopwords.put("un", dummy);
      m_Stopwords.put(weka.LocalString.get("under"), dummy);
      m_Stopwords.put(weka.LocalString.get("unfortunately"), dummy);
      m_Stopwords.put(weka.LocalString.get("unless"), dummy);
      m_Stopwords.put(weka.LocalString.get("unlikely"), dummy);
      m_Stopwords.put(weka.LocalString.get("until"), dummy);
      m_Stopwords.put(weka.LocalString.get("unto"), dummy);
      m_Stopwords.put("up", dummy);
      m_Stopwords.put(weka.LocalString.get("upon"), dummy);
      m_Stopwords.put("us", dummy);
      m_Stopwords.put(weka.LocalString.get("use"), dummy);
      m_Stopwords.put(weka.LocalString.get("used"), dummy);
      m_Stopwords.put(weka.LocalString.get("useful"), dummy);
      m_Stopwords.put(weka.LocalString.get("uses"), dummy);
      m_Stopwords.put(weka.LocalString.get("using"), dummy);
      m_Stopwords.put(weka.LocalString.get("usually"), dummy);
      m_Stopwords.put(weka.LocalString.get("uucp"), dummy);
      m_Stopwords.put("v", dummy);
      m_Stopwords.put(weka.LocalString.get("value"), dummy);
      m_Stopwords.put(weka.LocalString.get("various"), dummy);
      m_Stopwords.put("ve", dummy); //added to avoid words like I've,you've etc.
      m_Stopwords.put(weka.LocalString.get("very"), dummy);
      m_Stopwords.put(weka.LocalString.get("via"), dummy);
      m_Stopwords.put(weka.LocalString.get("viz"), dummy);
      m_Stopwords.put("vs", dummy);
      m_Stopwords.put("w", dummy);
      m_Stopwords.put(weka.LocalString.get("want"), dummy);
      m_Stopwords.put(weka.LocalString.get("wants"), dummy);
      m_Stopwords.put(weka.LocalString.get("was"), dummy);
      m_Stopwords.put(weka.LocalString.get("way"), dummy);
      m_Stopwords.put("we", dummy);
      m_Stopwords.put(weka.LocalString.get("welcome"), dummy);
      m_Stopwords.put(weka.LocalString.get("well"), dummy);
      m_Stopwords.put(weka.LocalString.get("went"), dummy);
      m_Stopwords.put(weka.LocalString.get("were"), dummy);
      m_Stopwords.put(weka.LocalString.get("what"), dummy);
      m_Stopwords.put(weka.LocalString.get("whatever"), dummy);
      m_Stopwords.put(weka.LocalString.get("when"), dummy);
      m_Stopwords.put(weka.LocalString.get("whence"), dummy);
      m_Stopwords.put(weka.LocalString.get("whenever"), dummy);
      m_Stopwords.put(weka.LocalString.get("where"), dummy);
      m_Stopwords.put(weka.LocalString.get("whereafter"), dummy);
      m_Stopwords.put(weka.LocalString.get("whereas"), dummy);
      m_Stopwords.put(weka.LocalString.get("whereby"), dummy);
      m_Stopwords.put(weka.LocalString.get("wherein"), dummy);
      m_Stopwords.put(weka.LocalString.get("whereupon"), dummy);
      m_Stopwords.put(weka.LocalString.get("wherever"), dummy);
      m_Stopwords.put(weka.LocalString.get("whether"), dummy);
      m_Stopwords.put(weka.LocalString.get("which"), dummy);
      m_Stopwords.put(weka.LocalString.get("while"), dummy);
      m_Stopwords.put(weka.LocalString.get("whither"), dummy);
      m_Stopwords.put(weka.LocalString.get("who"), dummy);
      m_Stopwords.put(weka.LocalString.get("whoever"), dummy);
      m_Stopwords.put(weka.LocalString.get("whole"), dummy);
      m_Stopwords.put(weka.LocalString.get("whom"), dummy);
      m_Stopwords.put(weka.LocalString.get("whose"), dummy);
      m_Stopwords.put(weka.LocalString.get("why"), dummy);
      m_Stopwords.put(weka.LocalString.get("will"), dummy);
      m_Stopwords.put(weka.LocalString.get("willing"), dummy);
      m_Stopwords.put(weka.LocalString.get("wish"), dummy);
      m_Stopwords.put(weka.LocalString.get("with"), dummy);
      m_Stopwords.put(weka.LocalString.get("within"), dummy);
      m_Stopwords.put(weka.LocalString.get("without"), dummy);
      m_Stopwords.put(weka.LocalString.get("wonder"), dummy);
      m_Stopwords.put(weka.LocalString.get("would"), dummy);
      m_Stopwords.put(weka.LocalString.get("would"), dummy);
      m_Stopwords.put("x", dummy);
      m_Stopwords.put("y", dummy);
      m_Stopwords.put(weka.LocalString.get("yes"), dummy);
      m_Stopwords.put(weka.LocalString.get("yet"), dummy);
      m_Stopwords.put(weka.LocalString.get("you"), dummy);
      m_Stopwords.put(weka.LocalString.get("your"), dummy);
      m_Stopwords.put(weka.LocalString.get("yours"), dummy);
      m_Stopwords.put(weka.LocalString.get("yourself"), dummy);
      m_Stopwords.put(weka.LocalString.get("yourselves"), dummy);
      m_Stopwords.put("z", dummy);
      m_Stopwords.put(weka.LocalString.get("zero"), dummy);

    }
  }
  
  /** 
   * Returns true if the given string is a stop word.
   */
  public static boolean isStopword(String str) {

    return m_Stopwords.containsKey(str.toLowerCase());
  }
}


