/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class NumericToBinary
extends PotentialClassIgnorer
implements UnsupervisedFilter,
StreamableFilter {
    public String globalInfo() {
        return LocalString.get("Converts all numeric attributes into binary attributes (apart from ") + LocalString.get("the class attribute, if set): if the value of the numeric attribute is ") + LocalString.get("exactly zero, the value of the new attribute will be zero. If the ") + LocalString.get("value of the numeric attribute is missing, the value of the new ") + LocalString.get("attribute will be missing. Otherwise, the value of the new ") + LocalString.get("attribute will be one. The new attributes will nominal.");
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    private void setOutputFormat() {
        int n = this.getInputFormat().classIndex();
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i == n || !attribute.isNumeric()) {
                fastVector.addElement(attribute.copy());
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(attribute.name() + LocalString.get("_binarized"));
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement("0");
            fastVector2.addElement("1");
            fastVector.addElement(new Attribute(stringBuffer.toString(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    private void convertInstance(Instance instance) {
        Instance instance2 = null;
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numValues()];
            int[] nArray = new int[instance.numValues()];
            for (int i = 0; i < instance.numValues(); ++i) {
                Attribute attribute = this.getInputFormat().attribute(instance.index(i));
                dArray[i] = !attribute.isNumeric() || instance.index(i) == this.getInputFormat().classIndex() ? instance.valueSparse(i) : (instance.isMissingSparse(i) ? instance.valueSparse(i) : 1.0);
                nArray[i] = instance.index(i);
            }
            instance2 = new SparseInstance(instance.weight(), dArray, nArray, this.outputFormatPeek().numAttributes());
        } else {
            double[] dArray = new double[this.outputFormatPeek().numAttributes()];
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                Attribute attribute = this.getInputFormat().attribute(i);
                dArray[i] = !attribute.isNumeric() || i == this.getInputFormat().classIndex() ? instance.value(i) : (instance.isMissing(i) || instance.value(i) == 0.0 ? instance.value(i) : 1.0);
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NumericToBinary(), stringArray);
            } else {
                Filter.filterFile(new NumericToBinary(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

