/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class HillClimber
extends LocalScoreSearchAlgorithm {
    Cache m_Cache = null;
    boolean m_bUseArcReversal = false;

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.initCache(bayesNet, instances);
        Operation operation = this.getOptimalOperation(bayesNet, instances);
        while (operation != null && operation.m_fDeltaScore > 0.0) {
            this.performOperation(bayesNet, instances, operation);
            operation = this.getOptimalOperation(bayesNet, instances);
        }
        this.m_Cache = null;
    }

    void initCache(BayesNet bayesNet, Instances instances) throws Exception {
        int n;
        double[] dArray = new double[instances.numAttributes()];
        int n2 = instances.numAttributes();
        this.m_Cache = new Cache(n2);
        for (n = 0; n < n2; ++n) {
            this.updateCache(n, n2, bayesNet.getParentSet(n));
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.calcNodeScore(n);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (n == i) continue;
                Operation operation = new Operation(i, n, 0);
                this.m_Cache.put(operation, this.calcScoreWithExtraParent(n, i) - dArray[n]);
            }
        }
    }

    boolean isNotTabu(Operation operation) {
        return true;
    }

    Operation getOptimalOperation(BayesNet bayesNet, Instances instances) throws Exception {
        Operation operation = new Operation();
        operation = this.findBestArcToAdd(bayesNet, instances, operation);
        operation = this.findBestArcToDelete(bayesNet, instances, operation);
        if (this.getUseArcReversal()) {
            operation = this.findBestArcToReverse(bayesNet, instances, operation);
        }
        if (operation.m_fDeltaScore == -1.0E100) {
            return null;
        }
        return operation;
    }

    void performOperation(BayesNet bayesNet, Instances instances, Operation operation) throws Exception {
        switch (operation.m_nOperation) {
            case 0: {
                this.applyArcAddition(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print(LocalString.get("Add ") + operation.m_nHead + " -> " + operation.m_nTail);
                break;
            }
            case 1: {
                this.applyArcDeletion(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print(LocalString.get("Del ") + operation.m_nHead + " -> " + operation.m_nTail);
                break;
            }
            case 2: {
                this.applyArcDeletion(bayesNet, operation.m_nHead, operation.m_nTail, instances);
                this.applyArcAddition(bayesNet, operation.m_nTail, operation.m_nHead, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print(LocalString.get("Rev ") + operation.m_nHead + " -> " + operation.m_nTail);
            }
        }
    }

    void applyArcAddition(BayesNet bayesNet, int n, int n2, Instances instances) {
        ParentSet parentSet = bayesNet.getParentSet(n);
        parentSet.addParent(n2, instances);
        this.updateCache(n, instances.numAttributes(), parentSet);
    }

    void applyArcDeletion(BayesNet bayesNet, int n, int n2, Instances instances) {
        ParentSet parentSet = bayesNet.getParentSet(n);
        parentSet.deleteParent(n2, instances);
        this.updateCache(n, instances.numAttributes(), parentSet);
    }

    Operation findBestArcToAdd(BayesNet bayesNet, Instances instances, Operation operation) {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            if (bayesNet.getParentSet(i).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
            for (int j = 0; j < n; ++j) {
                Operation operation2;
                if (!this.addArcMakesSense(bayesNet, instances, i, j) || !(this.m_Cache.get(operation2 = new Operation(j, i, 0)) > operation.m_fDeltaScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fDeltaScore = this.m_Cache.get(operation2);
            }
        }
        return operation;
    }

    Operation findBestArcToDelete(BayesNet bayesNet, Instances instances, Operation operation) {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            ParentSet parentSet = bayesNet.getParentSet(i);
            for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                Operation operation2 = new Operation(parentSet.getParent(j), i, 1);
                if (!(this.m_Cache.get(operation2) > operation.m_fDeltaScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fDeltaScore = this.m_Cache.get(operation2);
            }
        }
        return operation;
    }

    Operation findBestArcToReverse(BayesNet bayesNet, Instances instances, Operation operation) {
        int n = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            ParentSet parentSet = bayesNet.getParentSet(i);
            for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                Operation operation2;
                int n2 = parentSet.getParent(j);
                if (!this.reverseArcMakesSense(bayesNet, instances, i, n2) || bayesNet.getParentSet(n2).getNrOfParents() >= this.m_nMaxNrOfParents || !(this.m_Cache.get(operation2 = new Operation(parentSet.getParent(j), i, 2)) > operation.m_fDeltaScore) || !this.isNotTabu(operation2)) continue;
                operation = operation2;
                operation.m_fDeltaScore = this.m_Cache.get(operation2);
            }
        }
        return operation;
    }

    void updateCache(int n, int n2, ParentSet parentSet) {
        double d = this.calcNodeScore(n);
        int n3 = parentSet.getNrOfParents();
        for (int i = 0; i < n2; ++i) {
            Operation operation;
            if (i == n) continue;
            if (!parentSet.contains(i)) {
                if (n3 >= this.m_nMaxNrOfParents) continue;
                operation = new Operation(i, n, 0);
                this.m_Cache.put(operation, this.calcScoreWithExtraParent(n, i) - d);
                continue;
            }
            operation = new Operation(i, n, 1);
            this.m_Cache.put(operation, this.calcScoreWithMissingParent(n, i) - d);
        }
    }

    public void setMaxNrOfParents(int n) {
        this.m_nMaxNrOfParents = n;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tMaximum number of parents\n"), "P", 1, LocalString.get("-P <nr of parents>")));
        vector.addElement(new Option(LocalString.get("\tUse arc reversal operation.\n\t(default false)"), "R", 0, "-R"));
        vector.addElement(new Option(LocalString.get("\tInitial structure is empty (instead of Naive Bayes)\n"), "N", 0, "-N"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setUseArcReversal(Utils.getFlag('R', stringArray));
        this.setInitAsNaiveBayes(!Utils.getFlag('N', stringArray));
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(string));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        if (this.getUseArcReversal()) {
            stringArray2[n++] = "-R";
        }
        if (!this.getInitAsNaiveBayes()) {
            stringArray2[n++] = "-N";
        }
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.m_nMaxNrOfParents;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setInitAsNaiveBayes(boolean bl) {
        this.m_bInitAsNaiveBayes = bl;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public boolean getUseArcReversal() {
        return this.m_bUseArcReversal;
    }

    public void setUseArcReversal(boolean bl) {
        this.m_bUseArcReversal = bl;
    }

    public String globalInfo() {
        return LocalString.get("This Bayes Network learning algorithm uses a hill climbing algorithm ") + LocalString.get("adding, deleting and reversing arcs. The search is not restricted by an order ") + LocalString.get("on the variables (unlike K2). The difference with B and B2 is that this hill ") + LocalString.get("climber also considers arrows part of the naive Bayes structure for deletion.");
    }

    public String useArcReversalTipText() {
        return LocalString.get("When set to true, the arc reversal operation is used in the search.");
    }

    class Cache {
        double[][] m_fDeltaScoreAdd;
        double[][] m_fDeltaScoreDel;

        Cache(int n) {
            this.m_fDeltaScoreAdd = new double[n][n];
            this.m_fDeltaScoreDel = new double[n][n];
        }

        public void put(Operation operation, double d) {
            if (operation.m_nOperation == 0) {
                this.m_fDeltaScoreAdd[operation.m_nTail][operation.m_nHead] = d;
            } else {
                this.m_fDeltaScoreDel[operation.m_nTail][operation.m_nHead] = d;
            }
        }

        public double get(Operation operation) {
            switch (operation.m_nOperation) {
                case 0: {
                    return this.m_fDeltaScoreAdd[operation.m_nTail][operation.m_nHead];
                }
                case 1: {
                    return this.m_fDeltaScoreDel[operation.m_nTail][operation.m_nHead];
                }
                case 2: {
                    return this.m_fDeltaScoreDel[operation.m_nTail][operation.m_nHead] + this.m_fDeltaScoreAdd[operation.m_nHead][operation.m_nTail];
                }
            }
            return 0.0;
        }
    }

    class Operation
    implements Serializable {
        static final int OPERATION_ADD = 0;
        static final int OPERATION_DEL = 1;
        static final int OPERATION_REVERSE = 2;
        public int m_nTail;
        public int m_nHead;
        public int m_nOperation;
        public double m_fDeltaScore = -1.0E100;

        public Operation() {
        }

        public Operation(int n, int n2, int n3) {
            this.m_nHead = n2;
            this.m_nTail = n;
            this.m_nOperation = n3;
        }

        public boolean equals(Operation operation) {
            if (operation == null) {
                return false;
            }
            return this.m_nOperation == operation.m_nOperation && this.m_nHead == operation.m_nHead && this.m_nTail == operation.m_nTail;
        }
    }
}

