/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.IteratedSingleClassifierEnhancer;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class RandomizableIteratedSingleClassifierEnhancer
extends IteratedSingleClassifierEnhancer
implements Randomizable {
    protected int m_Seed = 1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tRandom number seed.\n") + LocalString.get("\t(default 1)"), "S", 1, LocalString.get("-S <num>")));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        int n = 0;
        stringArray2[n++] = "-S";
        stringArray2[n++] = "" + this.getSeed();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String seedTipText() {
        return LocalString.get("The random number seed to be used.");
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }
}

