/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *    ClassifierBeanInfo.java
 *    Copyright (C) 2002 Mark Hall
 *
 */

package weka.gui.beans;

import java.beans.*;

/**
 * BeanInfo class for the Classifier wrapper bean
 *
 * @author <a href="mailto:mhall@cs.waikato.ac.nz">Mark Hall</a>
 * @version $Revision: 1.1 $
 */
public class ClassifierBeanInfo extends SimpleBeanInfo {
 
  public EventSetDescriptor [] getEventSetDescriptors() {
    try {
      EventSetDescriptor [] esds = { 
	new EventSetDescriptor(Classifier.class, 
			       weka.LocalString.get("batchClassifier"), 
			       BatchClassifierListener.class, 
			       weka.LocalString.get("acceptClassifier")),
	new EventSetDescriptor(Classifier.class,
			       weka.LocalString.get("graph"),
			       GraphListener.class,
			       weka.LocalString.get("acceptGraph")),
	new EventSetDescriptor(Classifier.class,
			       weka.LocalString.get("text"),
			       TextListener.class,
			       weka.LocalString.get("acceptText")),
	new EventSetDescriptor(Classifier.class,
			       weka.LocalString.get("incrementalClassifier"),
			       IncrementalClassifierListener.class,
			       weka.LocalString.get("acceptClassifier"))
	};
      return esds;
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    return null;
  }

  /**
   * Get the bean descriptor for this bean
   *
   * @return a <code>BeanDescriptor</code> value
   */
  public BeanDescriptor getBeanDescriptor() {
    return new BeanDescriptor(weka.gui.beans.Classifier.class, 
			      ClassifierCustomizer.class);
  }
}

