/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.Saver;

public abstract class AbstractSaver
implements Saver {
    protected static final int WRITE = 0;
    protected static final int WAIT = 1;
    protected static final int CANCEL = 2;
    protected static final int STRUCTURE_READY = 3;
    private Instances m_instances;
    protected int m_retrieval;
    private int m_writeMode;

    public void resetOptions() {
        this.m_instances = null;
        this.m_writeMode = 1;
    }

    public void resetStructure() {
        this.m_instances = null;
        this.m_writeMode = 1;
    }

    public void setRetrieval(int n) {
        this.m_retrieval = n;
    }

    protected int getRetrieval() {
        return this.m_retrieval;
    }

    protected void setWriteMode(int n) {
        this.m_writeMode = n;
    }

    public int getWriteMode() {
        return this.m_writeMode;
    }

    public void setInstances(Instances instances) {
        if (this.m_retrieval == 2) {
            if (this.setStructure(instances) == 2) {
                this.cancel();
            }
        } else {
            this.m_instances = instances;
        }
    }

    public Instances getInstances() {
        return this.m_instances;
    }

    public void setDestination(File file) throws IOException {
        throw new IOException(LocalString.get("Writing to a file not supported"));
    }

    public void setDestination(OutputStream outputStream) throws IOException {
        throw new IOException(LocalString.get("Writing to an outputstream not supported"));
    }

    public int setStructure(Instances instances) {
        if (this.m_writeMode == 1 && instances != null) {
            this.m_instances = instances;
            this.m_writeMode = 3;
        } else if (instances == null || this.m_writeMode != 3 || !instances.equalHeaders(this.m_instances)) {
            this.m_instances = null;
            if (this.m_writeMode != 1) {
                System.err.println(LocalString.get("A structure cannot be set up during an active incremental saving process."));
            }
            this.m_writeMode = 2;
        }
        return this.m_writeMode;
    }

    public void cancel() {
        if (this.m_writeMode == 2) {
            this.resetOptions();
        }
    }

    public void writeIncremental(Instance instance) throws IOException {
        throw new IOException(LocalString.get("No Incremental saving possible."));
    }

    public abstract void writeBatch() throws IOException;

    public String getFileExtension() throws Exception {
        throw new Exception(LocalString.get("Saving in a file not supported."));
    }

    public void setFile(File file) throws IOException {
        throw new IOException(LocalString.get("Saving in a file not supported."));
    }

    public void setFilePrefix(String string) throws Exception {
        throw new Exception(LocalString.get("Saving in a file not supported."));
    }

    public String filePrefix() throws Exception {
        throw new Exception(LocalString.get("Saving in a file not supported."));
    }

    public void setDir(String string) throws IOException {
        throw new IOException(LocalString.get("Saving in a file not supported."));
    }

    public void setDirAndPrefix(String string, String string2) throws IOException {
        throw new IOException(LocalString.get("Saving in a file not supported."));
    }

    public String retrieveDir() throws IOException {
        throw new IOException(LocalString.get("Saving in a file not supported."));
    }
}

