/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.lazy.IBk;
import weka.core.AdditionalMeasureProducer;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.Remove;

public class DecisionTable
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
AdditionalMeasureProducer {
    private Hashtable m_entries;
    private int[] m_decisionFeatures;
    private Filter m_disTransform;
    private Remove m_delTransform;
    private IBk m_ibk;
    private Instances m_theInstances;
    private int m_numAttributes;
    private int m_numInstances;
    private boolean m_classIsNominal;
    private boolean m_debug;
    private boolean m_useIBk;
    private boolean m_displayRules;
    private int m_maxStale;
    private int m_CVFolds;
    private Random m_rr;
    private double m_majority;

    public String globalInfo() {
        return LocalString.get("Class for building and using a simple decision table majority ") + LocalString.get("classifier. For more information see: \n\n") + LocalString.get("Kohavi R. (1995). \"The Power of Decision Tables.\" In Proc ") + LocalString.get("European Conference on Machine Learning.");
    }

    private void insertIntoTable(Instance instance, double[] dArray) throws Exception {
        hashKey hashKey2 = dArray != null ? new hashKey(dArray) : new hashKey(instance, instance.numAttributes(), false);
        double[] dArray2 = (double[])this.m_entries.get(hashKey2);
        if (dArray2 == null) {
            if (this.m_classIsNominal) {
                double[] dArray3 = new double[this.m_theInstances.classAttribute().numValues()];
                dArray3[(int)instance.classValue()] = instance.weight();
                this.m_entries.put(hashKey2, dArray3);
            } else {
                double[] dArray4 = new double[]{instance.classValue() * instance.weight(), instance.weight()};
                this.m_entries.put(hashKey2, dArray4);
            }
        } else if (this.m_classIsNominal) {
            int n = (int)instance.classValue();
            dArray2[n] = dArray2[n] + instance.weight();
            this.m_entries.put(hashKey2, dArray2);
        } else {
            dArray2[0] = dArray2[0] + instance.classValue() * instance.weight();
            dArray2[1] = dArray2[1] + instance.weight();
            this.m_entries.put(hashKey2, dArray2);
        }
    }

    double classifyInstanceLeaveOneOut(Instance instance, double[] dArray) throws Exception {
        hashKey hashKey2 = new hashKey(dArray);
        if (this.m_classIsNominal) {
            double[] dArray2 = (double[])this.m_entries.get(hashKey2);
            if (dArray2 == null) {
                throw new Error(LocalString.get("This should never happen!"));
            }
            double[] dArray3 = new double[dArray2.length];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            int n = (int)instance.classValue();
            dArray3[n] = dArray3[n] - instance.weight();
            boolean bl = false;
            for (int i = 0; i < dArray3.length; ++i) {
                if (Utils.eq(dArray3[i], 0.0)) continue;
                bl = true;
                break;
            }
            if (bl) {
                Utils.normalize(dArray3);
                return Utils.maxIndex(dArray3);
            }
            return this.m_majority;
        }
        double[] dArray4 = (double[])this.m_entries.get(hashKey2);
        if (dArray4 != null) {
            double[] dArray5 = new double[dArray4.length];
            System.arraycopy(dArray4, 0, dArray5, 0, dArray4.length);
            dArray5[0] = dArray5[0] - instance.classValue() * instance.weight();
            dArray5[1] = dArray5[1] - instance.weight();
            if (Utils.eq(dArray5[1], 0.0)) {
                return this.m_majority;
            }
            return dArray5[0] / dArray5[1];
        }
        throw new Error(LocalString.get("This should never happen!"));
    }

    double classifyFoldCV(Instances instances, int[] nArray) throws Exception {
        Instance instance;
        int n;
        int n2 = 0;
        int n3 = instances.numInstances();
        int n4 = this.m_theInstances.classAttribute().numValues();
        double[][] dArray = new double[n3][n4];
        double[] dArray2 = new double[nArray.length];
        double d = 0.0;
        int n5 = this.m_theInstances.classIndex();
        double[] dArray3 = this.m_classIsNominal ? new double[n4] : new double[2];
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            for (int i = 0; i < nArray.length; ++i) {
                dArray2[i] = nArray[i] == n5 ? Double.MAX_VALUE : (instance.isMissing(nArray[i]) ? Double.MAX_VALUE : instance.value(nArray[i]));
            }
            hashKey hashKey2 = new hashKey(dArray2);
            dArray[n] = (double[])this.m_entries.get(hashKey2);
            if (dArray[n] == null) {
                throw new Error(LocalString.get("This should never happen!"));
            }
            if (this.m_classIsNominal) {
                double[] dArray4 = dArray[n];
                int n6 = (int)instance.classValue();
                dArray4[n6] = dArray4[n6] - instance.weight();
            } else {
                double[] dArray5 = dArray[n];
                dArray5[0] = dArray5[0] - instance.classValue() * instance.weight();
                double[] dArray6 = dArray[n];
                dArray6[1] = dArray6[1] - instance.weight();
            }
            ++n2;
        }
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            System.arraycopy(dArray[n], 0, dArray3, 0, dArray3.length);
            if (this.m_classIsNominal) {
                boolean bl = false;
                for (int i = 0; i < dArray3.length; ++i) {
                    if (Utils.eq(dArray3[i], 0.0)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Utils.normalize(dArray3);
                    if ((double)Utils.maxIndex(dArray3) != instance.classValue()) continue;
                    d += instance.weight();
                    continue;
                }
                if (instance.classValue() != this.m_majority) continue;
                d += instance.weight();
                continue;
            }
            if (Utils.eq(dArray3[1], 0.0)) {
                d += instance.weight() * (this.m_majority - instance.classValue()) * (instance.weight() * (this.m_majority - instance.classValue()));
                continue;
            }
            double d2 = dArray3[0] / dArray3[1];
            d += instance.weight() * (d2 - instance.classValue()) * (instance.weight() * (d2 - instance.classValue()));
        }
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            if (this.m_classIsNominal) {
                double[] dArray7 = dArray[n];
                int n7 = (int)instance.classValue();
                dArray7[n7] = dArray7[n7] + instance.weight();
                continue;
            }
            double[] dArray8 = dArray[n];
            dArray8[0] = dArray8[0] + instance.classValue() * instance.weight();
            double[] dArray9 = dArray[n];
            dArray9[1] = dArray9[1] + instance.weight();
        }
        return d;
    }

    private double estimateAccuracy(BitSet bitSet, int n) throws Exception {
        Serializable serializable;
        int n2;
        int[] nArray = new int[n];
        double d = 0.0;
        double[] dArray = new double[n];
        int n3 = this.m_theInstances.classIndex();
        int n4 = 0;
        for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
            if (!bitSet.get(n2)) continue;
            nArray[n4++] = n2;
        }
        this.m_entries = new Hashtable((int)((double)this.m_theInstances.numInstances() * 1.5));
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            serializable = this.m_theInstances.instance(n2);
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = nArray[i] == n3 ? Double.MAX_VALUE : (((Instance)serializable).isMissing(nArray[i]) ? Double.MAX_VALUE : ((Instance)serializable).value(nArray[i]));
            }
            this.insertIntoTable((Instance)serializable, dArray);
        }
        if (this.m_CVFolds == 1) {
            for (n2 = 0; n2 < this.m_numInstances; ++n2) {
                serializable = this.m_theInstances.instance(n2);
                for (int i = 0; i < nArray.length; ++i) {
                    dArray[i] = nArray[i] == n3 ? Double.MAX_VALUE : (((Instance)serializable).isMissing(nArray[i]) ? Double.MAX_VALUE : ((Instance)serializable).value(nArray[i]));
                }
                double d2 = this.classifyInstanceLeaveOneOut((Instance)serializable, dArray);
                if (this.m_classIsNominal) {
                    if (d2 != ((Instance)serializable).classValue()) continue;
                    d += ((Instance)serializable).weight();
                    continue;
                }
                d += ((Instance)serializable).weight() * (d2 - ((Instance)serializable).classValue()) * (((Instance)serializable).weight() * (d2 - ((Instance)serializable).classValue()));
            }
        } else {
            this.m_theInstances.randomize(this.m_rr);
            this.m_theInstances.stratify(this.m_CVFolds);
            for (n2 = 0; n2 < this.m_CVFolds; ++n2) {
                serializable = this.m_theInstances.testCV(this.m_CVFolds, n2);
                d += this.classifyFoldCV((Instances)serializable, nArray);
            }
        }
        if (this.m_classIsNominal) {
            return d / this.m_theInstances.sumOfWeights();
        }
        return -Math.sqrt(d / this.m_theInstances.sumOfWeights());
    }

    private String printSub(BitSet bitSet) {
        String string = "";
        for (int i = 0; i < this.m_numAttributes; ++i) {
            if (!bitSet.get(i)) continue;
            string = string + " " + (i + 1);
        }
        return string;
    }

    private void best_first() throws Exception {
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Hashtable<BitSet, String> hashtable = new Hashtable<BitSet, String>((int)(200.0 * (double)this.m_numAttributes * 1.5));
        LinkedList linkedList = new LinkedList();
        double[] dArray = new double[]{0.0};
        int[] nArray = new int[]{0};
        BitSet bitSet = new BitSet(this.m_numAttributes);
        int n3 = this.m_theInstances.classIndex();
        bitSet.set(n3);
        dArray[0] = this.estimateAccuracy(bitSet, 1);
        if (this.m_debug) {
            System.out.println(LocalString.get("Accuracy of initial subset: ") + dArray[0]);
        }
        linkedList.addToList(bitSet, dArray[0]);
        hashtable.put(bitSet, "");
        while (nArray[0] < this.m_maxStale) {
            boolean bl3 = false;
            if (linkedList.size() == 0) {
                nArray[0] = this.m_maxStale;
                break;
            }
            Link link = linkedList.getLinkAt(0);
            BitSet bitSet2 = (BitSet)link.getGroup().clone();
            linkedList.removeLinkAt(0);
            for (n = 0; n < this.m_numAttributes; ++n) {
                boolean bl4;
                boolean bl5 = bl4 = n != n3 && !bitSet2.get(n);
                if (!bl4) continue;
                bitSet2.set(n);
                BitSet bitSet3 = (BitSet)bitSet2.clone();
                if (!hashtable.containsKey(bitSet3)) {
                    int n4 = 0;
                    for (int i = 0; i < this.m_numAttributes; ++i) {
                        if (!bitSet3.get(i)) continue;
                        ++n4;
                    }
                    double d = this.estimateAccuracy(bitSet3, n4);
                    if (this.m_debug) {
                        System.out.println(LocalString.get("evaluating: ") + this.printSub(bitSet3) + " " + d);
                    }
                    boolean bl6 = bl4 = d - dArray[0] > 1.0E-5;
                    if (bl4) {
                        if (this.m_debug) {
                            System.out.println(LocalString.get("new best feature set: ") + this.printSub(bitSet3) + " " + d);
                        }
                        bl3 = true;
                        nArray[0] = 0;
                        dArray[0] = d;
                        bitSet = (BitSet)bitSet2.clone();
                    }
                    linkedList.addToList(bitSet3, d);
                    hashtable.put(bitSet3, "");
                    ++n2;
                }
                bitSet2.clear(n);
            }
            if (bl3) continue;
            nArray[0] = nArray[0] + 1;
        }
        int n5 = 0;
        for (n = 0; n < this.m_numAttributes; ++n) {
            if (!bitSet.get(n)) continue;
            ++n5;
        }
        this.m_decisionFeatures = new int[n5];
        n5 = 0;
        for (n = 0; n < this.m_numAttributes; ++n) {
            if (!bitSet.get(n)) continue;
            this.m_decisionFeatures[n5++] = n;
        }
    }

    protected void resetOptions() {
        this.m_entries = null;
        this.m_decisionFeatures = null;
        this.m_debug = false;
        this.m_useIBk = false;
        this.m_CVFolds = 1;
        this.m_maxStale = 5;
        this.m_displayRules = false;
    }

    public DecisionTable() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option(LocalString.get("\tNumber of fully expanded non improving subsets to consider\n") + LocalString.get("\tbefore terminating a best first search.\n") + LocalString.get("\tUse in conjunction with -B. (Default = 5)"), "S", 1, LocalString.get("-S <number of non improving nodes>")));
        vector.addElement(new Option(LocalString.get("\tUse cross validation to evaluate features.\n") + LocalString.get("\tUse number of folds = 1 for leave one out CV.\n") + LocalString.get("\t(Default = leave one out CV)"), "X", 1, LocalString.get("-X <number of folds>")));
        vector.addElement(new Option(LocalString.get("\tUse nearest neighbour instead of global table majority.\n"), "I", 0, "-I"));
        vector.addElement(new Option(LocalString.get("\tDisplay decision table rules.\n"), "R", 0, "-R"));
        return vector.elements();
    }

    public String crossValTipText() {
        return LocalString.get("Sets the number of folds for cross validation (1 = leave one out).");
    }

    public void setCrossVal(int n) {
        this.m_CVFolds = n;
    }

    public int getCrossVal() {
        return this.m_CVFolds;
    }

    public String maxStaleTipText() {
        return LocalString.get("Sets the number of non improving decision tables to consider ") + LocalString.get("before abandoning the search.");
    }

    public void setMaxStale(int n) {
        this.m_maxStale = n;
    }

    public int getMaxStale() {
        return this.m_maxStale;
    }

    public String useIBkTipText() {
        return LocalString.get("Sets whether IBk should be used instead of the majority class.");
    }

    public void setUseIBk(boolean bl) {
        this.m_useIBk = bl;
    }

    public boolean getUseIBk() {
        return this.m_useIBk;
    }

    public String displayRulesTipText() {
        return LocalString.get("Sets whether rules are to be printed.");
    }

    public void setDisplayRules(boolean bl) {
        this.m_displayRules = bl;
    }

    public boolean getDisplayRules() {
        return this.m_displayRules;
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.m_CVFolds = Integer.parseInt(string);
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.m_maxStale = Integer.parseInt(string);
        }
        this.m_useIBk = Utils.getFlag('I', stringArray);
        this.m_displayRules = Utils.getFlag('R', stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-X";
        stringArray[n++] = "" + this.m_CVFolds;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_maxStale;
        if (this.m_useIBk) {
            stringArray[n++] = "-I";
        }
        if (this.m_displayRules) {
            stringArray[n++] = "-R";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        this.m_rr = new Random(1L);
        this.m_theInstances = new Instances(instances);
        this.m_theInstances.deleteWithMissingClass();
        if (this.m_theInstances.numInstances() == 0) {
            throw new Exception(LocalString.get("No training instances without missing class!"));
        }
        if (this.m_theInstances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        if (this.m_theInstances.classAttribute().isNumeric()) {
            this.m_disTransform = new Discretize();
            this.m_classIsNominal = false;
            ((Discretize)this.m_disTransform).setBins(10);
            ((Discretize)this.m_disTransform).setInvertSelection(true);
            object = "";
            object = (String)object + (this.m_theInstances.classIndex() + 1);
            ((Discretize)this.m_disTransform).setAttributeIndices((String)object);
        } else {
            this.m_disTransform = new weka.filters.supervised.attribute.Discretize();
            ((weka.filters.supervised.attribute.Discretize)this.m_disTransform).setUseBetterEncoding(true);
            this.m_classIsNominal = true;
        }
        this.m_disTransform.setInputFormat(this.m_theInstances);
        this.m_theInstances = Filter.useFilter(this.m_theInstances, this.m_disTransform);
        this.m_numAttributes = this.m_theInstances.numAttributes();
        this.m_numInstances = this.m_theInstances.numInstances();
        this.m_majority = this.m_theInstances.meanOrMode(this.m_theInstances.classAttribute());
        this.best_first();
        this.m_delTransform = new Remove();
        this.m_delTransform.setInvertSelection(true);
        this.m_delTransform.setAttributeIndicesArray(this.m_decisionFeatures);
        this.m_delTransform.setInputFormat(this.m_theInstances);
        this.m_theInstances = Filter.useFilter(this.m_theInstances, this.m_delTransform);
        this.m_numAttributes = this.m_theInstances.numAttributes();
        this.m_entries = new Hashtable((int)((double)this.m_theInstances.numInstances() * 1.5));
        for (int i = 0; i < this.m_numInstances; ++i) {
            object = this.m_theInstances.instance(i);
            this.insertIntoTable((Instance)object, null);
        }
        if (this.m_useIBk) {
            this.m_ibk = new IBk();
            this.m_ibk.buildClassifier(this.m_theInstances);
        }
        this.m_theInstances = new Instances(this.m_theInstances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_disTransform.input(instance);
        this.m_disTransform.batchFinished();
        instance = this.m_disTransform.output();
        this.m_delTransform.input(instance);
        this.m_delTransform.batchFinished();
        instance = this.m_delTransform.output();
        hashKey hashKey2 = new hashKey(instance, instance.numAttributes(), false);
        double[] dArray = (double[])this.m_entries.get(hashKey2);
        if (dArray == null) {
            if (this.m_useIBk) {
                dArray = this.m_ibk.distributionForInstance(instance);
            } else if (!this.m_classIsNominal) {
                dArray = new double[]{this.m_majority};
            } else {
                dArray = new double[this.m_theInstances.classAttribute().numValues()];
                dArray[(int)this.m_majority] = 1.0;
            }
        } else if (!this.m_classIsNominal) {
            double[] dArray2 = new double[]{dArray[0] / dArray[1]};
            dArray = dArray2;
        } else {
            double[] dArray3 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            Utils.normalize(dArray3);
            dArray = dArray3;
        }
        return dArray;
    }

    public String printFeatures() {
        String string = "";
        for (int i = 0; i < this.m_decisionFeatures.length; ++i) {
            string = i == 0 ? "" + (this.m_decisionFeatures[i] + 1) : string + "," + (this.m_decisionFeatures[i] + 1);
        }
        return string;
    }

    public double measureNumRules() {
        return this.m_entries.size();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(LocalString.get("measureNumRules"));
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureNumRules")) == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (DecisionTable)"));
    }

    public String toString() {
        if (this.m_entries == null) {
            return LocalString.get("Decision Table: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("Decision Table:") + LocalString.get("\n\nNumber of training instances: ") + this.m_numInstances + LocalString.get("\nNumber of Rules : ") + this.m_entries.size() + "\n");
        if (this.m_useIBk) {
            stringBuffer.append(LocalString.get("Non matches covered by IB1.\n"));
        } else {
            stringBuffer.append(LocalString.get("Non matches covered by Majority class.\n"));
        }
        stringBuffer.append(LocalString.get("Best first search for feature set,\nterminated after ") + this.m_maxStale + LocalString.get(" non improving subsets.\n"));
        stringBuffer.append(LocalString.get("Evaluation (for feature selection): CV "));
        if (this.m_CVFolds > 1) {
            stringBuffer.append("(" + this.m_CVFolds + LocalString.get(" fold) "));
        } else {
            stringBuffer.append(LocalString.get("(leave one out) "));
        }
        stringBuffer.append(LocalString.get("\nFeature set: ") + this.printFeatures());
        if (this.m_displayRules) {
            int n;
            int n2 = 0;
            for (int i = 0; i < this.m_theInstances.numAttributes(); ++i) {
                if (this.m_theInstances.attribute(i).name().length() > n2) {
                    n2 = this.m_theInstances.attribute(i).name().length();
                }
                if (!this.m_classIsNominal && i == this.m_theInstances.classIndex()) continue;
                Enumeration enumeration = this.m_theInstances.attribute(i).enumerateValues();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.length() <= n2) continue;
                    n2 = string.length();
                }
            }
            stringBuffer.append("\n\nRules:\n");
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = 0; n < this.m_theInstances.numAttributes(); ++n) {
                if (this.m_theInstances.classIndex() == n) continue;
                int n3 = n2 - this.m_theInstances.attribute(n).name().length();
                stringBuffer2.append(this.m_theInstances.attribute(n).name());
                for (int i = 0; i < n3 + 1; ++i) {
                    stringBuffer2.append(" ");
                }
            }
            stringBuffer2.append(this.m_theInstances.attribute(this.m_theInstances.classIndex()).name() + "  ");
            for (n = 0; n < stringBuffer2.length() + 10; ++n) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("\n");
            for (n = 0; n < stringBuffer2.length() + 10; ++n) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            Enumeration enumeration = this.m_entries.keys();
            while (enumeration.hasMoreElements()) {
                hashKey hashKey2 = (hashKey)enumeration.nextElement();
                stringBuffer.append(hashKey2.toString(this.m_theInstances, n2));
                double[] dArray = (double[])this.m_entries.get(hashKey2);
                if (this.m_classIsNominal) {
                    int n4 = Utils.maxIndex(dArray);
                    try {
                        stringBuffer.append(this.m_theInstances.classAttribute().value(n4) + "\n");
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                    continue;
                }
                stringBuffer.append(dArray[0] / dArray[1] + "\n");
            }
            for (int i = 0; i < stringBuffer2.length() + 10; ++i) {
                stringBuffer.append("=");
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            DecisionTable decisionTable = new DecisionTable();
            System.out.println(Evaluation.evaluateModel(decisionTable, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }

    public static class hashKey
    implements Serializable {
        private double[] attributes;
        private boolean[] missing;
        private String[] values;
        private int key;

        public hashKey(Instance instance, int n, boolean bl) throws Exception {
            int n2 = instance.classIndex();
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (i == n2 && !bl) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = instance.isMissing(i);
                if (this.missing[i]) continue;
                this.attributes[i] = instance.value(i);
            }
        }

        public String toString(Instances instances, int n) {
            int n2 = instances.classIndex();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i == n2) continue;
                if (this.missing[i]) {
                    stringBuffer.append("?");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append(" ");
                    }
                    continue;
                }
                String string = instances.attribute(i).value((int)this.attributes[i]);
                StringBuffer stringBuffer2 = new StringBuffer(string);
                for (int j = 0; j < n - string.length() + 1; ++j) {
                    stringBuffer2.append(" ");
                }
                stringBuffer.append(stringBuffer2);
            }
            return stringBuffer.toString();
        }

        public hashKey(double[] dArray) {
            int n = dArray.length;
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (dArray[i] == Double.MAX_VALUE) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = false;
                this.attributes[i] = dArray[i];
            }
        }

        public int hashCode() {
            int n = 0;
            if (this.key != -999) {
                return this.key;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                if (this.missing[i]) {
                    n += i * 13;
                    continue;
                }
                n = (int)((double)n + (double)(i * 5) * (this.attributes[i] + 1.0));
            }
            if (this.key == -999) {
                this.key = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            boolean bl = true;
            if (object instanceof hashKey) {
                hashKey hashKey2 = (hashKey)object;
                for (int i = 0; i < this.attributes.length; ++i) {
                    boolean bl2 = hashKey2.missing[i];
                    if (this.missing[i] || bl2) {
                        if ((!this.missing[i] || bl2) && (this.missing[i] || !bl2)) continue;
                        bl = false;
                    } else {
                        if (this.attributes[i] == hashKey2.attributes[i]) continue;
                        bl = false;
                    }
                    break;
                }
            } else {
                return false;
            }
            return bl;
        }

        public void print_hash_code() {
            System.out.println(LocalString.get("Hash val: ") + this.hashCode());
        }
    }

    public class LinkedList
    extends FastVector {
        public void removeLinkAt(int n) throws Exception {
            if (n < 0 || n >= this.size()) {
                throw new Exception(LocalString.get("index out of range (removeLinkAt)"));
            }
            this.removeElementAt(n);
        }

        public Link getLinkAt(int n) throws Exception {
            if (this.size() == 0) {
                throw new Exception(LocalString.get("List is empty (getLinkAt)"));
            }
            if (n >= 0 && n < this.size()) {
                return (Link)this.elementAt(n);
            }
            throw new Exception(LocalString.get("index out of range (getLinkAt)"));
        }

        public void addToList(BitSet bitSet, double d) {
            Link link = new Link(bitSet, d);
            if (this.size() == 0) {
                this.addElement(link);
            } else if (d > ((Link)this.firstElement()).getMerit()) {
                this.insertElementAt(link, 0);
            } else {
                int n = 0;
                int n2 = this.size();
                boolean bl = false;
                while (!bl && n < n2) {
                    if (d > ((Link)this.elementAt(n)).getMerit()) {
                        this.insertElementAt(link, n);
                        bl = true;
                        continue;
                    }
                    if (n == n2 - 1) {
                        this.addElement(link);
                        bl = true;
                        continue;
                    }
                    ++n;
                }
            }
        }
    }

    public class Link {
        BitSet m_group;
        double m_merit;

        public Link(BitSet bitSet, double d) {
            this.m_group = (BitSet)bitSet.clone();
            this.m_merit = d;
        }

        public BitSet getGroup() {
            return this.m_group;
        }

        public double getMerit() {
            return this.m_merit;
        }

        public String toString() {
            return LocalString.get("Node: ") + this.m_group.toString() + "  " + this.m_merit;
        }
    }
}

