/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.LocalString;
import weka.classifiers.functions.pace.ExponentialFormat;
import weka.classifiers.functions.pace.FloatingPointFormat;

public class FlexibleDecimalFormat
extends DecimalFormat {
    private DecimalFormat nf = null;
    private int digits = 7;
    private boolean exp = false;
    private int intDigits = 1;
    private int decimalDigits = 0;
    private int expIntDigits = 1;
    private int expDecimalDigits = 0;
    private int power = 2;
    private boolean trailing = false;
    private boolean grouping = false;
    private boolean sign = false;

    public FlexibleDecimalFormat() {
        this(5);
    }

    public FlexibleDecimalFormat(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(LocalString.get("digits < 1"));
        }
        this.digits = n;
        this.intDigits = 1;
    }

    public FlexibleDecimalFormat(int n, boolean bl) {
        this(n);
        this.trailing = bl;
    }

    public FlexibleDecimalFormat(int n, boolean bl, boolean bl2, boolean bl3) {
        this.trailing = bl2;
        this.exp = bl;
        this.digits = n;
        this.grouping = bl3;
        if (bl) {
            this.intDigits = 1;
            this.decimalDigits = n - this.intDigits;
        } else {
            this.decimalDigits = this.decimalDigits;
            this.intDigits = Math.max(1, n - this.decimalDigits);
        }
    }

    public FlexibleDecimalFormat(double d) {
        this.newFormat(d);
    }

    private void newFormat(double d) {
        if (this.needExponentialFormat(d)) {
            this.exp = true;
            this.intDigits = 1;
            this.expDecimalDigits = this.decimalDigits(d, true);
            this.sign = d < 0.0;
        } else {
            this.exp = false;
            this.intDigits = Math.max(1, FlexibleDecimalFormat.intDigits(d));
            this.decimalDigits = this.decimalDigits(d, false);
            this.sign = d < 0.0;
        }
    }

    public void update(double d) {
        if (Math.abs(FlexibleDecimalFormat.intDigits(d) - 1) > 99) {
            this.power = 3;
        }
        this.expIntDigits = 1;
        this.expDecimalDigits = Math.max(this.expDecimalDigits, this.decimalDigits(d, true));
        if (d < 0.0) {
            this.sign = true;
        }
        if (this.needExponentialFormat(d) || this.exp) {
            this.exp = true;
        } else {
            this.intDigits = Math.max(this.intDigits, FlexibleDecimalFormat.intDigits(d));
            this.decimalDigits = Math.max(this.decimalDigits, this.decimalDigits(d, false));
            if (d < 0.0) {
                this.sign = true;
            }
        }
    }

    private static int intDigits(double d) {
        return (int)Math.floor(Math.log(Math.abs(d * 1.00000000000001)) / Math.log(10.0)) + 1;
    }

    private int decimalDigits(double d, boolean bl) {
        int n;
        if (d == 0.0) {
            return 0;
        }
        d = Math.abs(d);
        int n2 = FlexibleDecimalFormat.intDigits(d);
        if (bl) {
            d /= Math.pow(10.0, n2 - 1);
            n2 = 1;
        }
        if (n2 >= this.digits) {
            return 0;
        }
        int n3 = Math.max(1, n2);
        if (!this.trailing && n > 0) {
            FloatingPointFormat floatingPointFormat = new FloatingPointFormat(n3 + 1 + n, n, true);
            String string = floatingPointFormat.format(d);
            for (n = this.digits - n2; n > 0 && string.charAt(n3 + 1 + n - 1) == '0'; --n) {
            }
        }
        return n;
    }

    public boolean needExponentialFormat(double d) {
        if (d == 0.0) {
            return false;
        }
        int n = FlexibleDecimalFormat.intDigits(d);
        return n > this.digits + 5 || n < -3;
    }

    public void grouping(boolean bl) {
        this.grouping = bl;
    }

    private static void println(Object object) {
        System.out.println(object);
    }

    private void setFormat() {
        int n = 1;
        if (this.decimalDigits == 0) {
            n = 0;
        }
        if (this.exp) {
            this.nf = new ExponentialFormat(1 + this.expDecimalDigits, this.power, this.sign, this.grouping || this.trailing);
        } else {
            int n2 = this.sign ? 1 : 0;
            this.nf = new FloatingPointFormat(n2 + this.intDigits + n + this.decimalDigits, this.decimalDigits, this.grouping || this.trailing);
        }
    }

    private void setFormat(double d) {
        this.newFormat(d);
        this.setFormat();
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.grouping) {
            if (this.nf == null) {
                this.setFormat();
            }
        } else {
            this.setFormat(d);
        }
        return stringBuffer.append(this.nf.format(d));
    }

    public int width() {
        if (!this.trailing && !this.grouping) {
            throw new RuntimeException(LocalString.get("flexible width"));
        }
        return this.format(0.0).length();
    }

    public StringBuffer formatString(String string) {
        int n;
        int n2 = this.width();
        int n3 = (n2 - string.length()) / 2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n3; ++n) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        for (n = 0; n < n2 - n3 - string.length(); ++n) {
            stringBuffer.append(' ');
        }
        return stringBuffer;
    }
}

