/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import weka.LocalString;
import weka.classifiers.evaluation.ConfusionMatrix;

public class TwoClassStats {
    private static final String[] CATEGORY_NAMES = new String[]{LocalString.get("negative"), LocalString.get("positive")};
    private double m_TruePos;
    private double m_FalsePos;
    private double m_TrueNeg;
    private double m_FalseNeg;

    public TwoClassStats(double d, double d2, double d3, double d4) {
        this.setTruePositive(d);
        this.setFalsePositive(d2);
        this.setTrueNegative(d3);
        this.setFalseNegative(d4);
    }

    public void setTruePositive(double d) {
        this.m_TruePos = d;
    }

    public void setFalsePositive(double d) {
        this.m_FalsePos = d;
    }

    public void setTrueNegative(double d) {
        this.m_TrueNeg = d;
    }

    public void setFalseNegative(double d) {
        this.m_FalseNeg = d;
    }

    public double getTruePositive() {
        return this.m_TruePos;
    }

    public double getFalsePositive() {
        return this.m_FalsePos;
    }

    public double getTrueNegative() {
        return this.m_TrueNeg;
    }

    public double getFalseNegative() {
        return this.m_FalseNeg;
    }

    public double getTruePositiveRate() {
        if (0.0 == this.m_TruePos + this.m_FalseNeg) {
            return 0.0;
        }
        return this.m_TruePos / (this.m_TruePos + this.m_FalseNeg);
    }

    public double getFalsePositiveRate() {
        if (0.0 == this.m_FalsePos + this.m_TrueNeg) {
            return 0.0;
        }
        return this.m_FalsePos / (this.m_FalsePos + this.m_TrueNeg);
    }

    public double getPrecision() {
        if (0.0 == this.m_TruePos + this.m_FalsePos) {
            return 0.0;
        }
        return this.m_TruePos / (this.m_TruePos + this.m_FalsePos);
    }

    public double getRecall() {
        return this.getTruePositiveRate();
    }

    public double getFMeasure() {
        double d;
        double d2 = this.getPrecision();
        if (d2 + (d = this.getRecall()) == 0.0) {
            return 0.0;
        }
        return 2.0 * d2 * d / (d2 + d);
    }

    public double getFallout() {
        if (0.0 == this.m_TruePos + this.m_FalsePos) {
            return 0.0;
        }
        return this.m_FalsePos / (this.m_TruePos + this.m_FalsePos);
    }

    public ConfusionMatrix getConfusionMatrix() {
        ConfusionMatrix confusionMatrix = new ConfusionMatrix(CATEGORY_NAMES);
        confusionMatrix.setElement(0, 0, this.m_TrueNeg);
        confusionMatrix.setElement(0, 1, this.m_FalsePos);
        confusionMatrix.setElement(1, 0, this.m_FalseNeg);
        confusionMatrix.setElement(1, 1, this.m_TruePos);
        return confusionMatrix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTruePositive()).append(' ');
        stringBuffer.append(this.getFalseNegative()).append(' ');
        stringBuffer.append(this.getTrueNegative()).append(' ');
        stringBuffer.append(this.getFalsePositive()).append(' ');
        stringBuffer.append(this.getFalsePositiveRate()).append(' ');
        stringBuffer.append(this.getTruePositiveRate()).append(' ');
        stringBuffer.append(this.getPrecision()).append(' ');
        stringBuffer.append(this.getRecall()).append(' ');
        stringBuffer.append(this.getFMeasure()).append(' ');
        stringBuffer.append(this.getFallout()).append(' ');
        return stringBuffer.toString();
    }
}

