require 'test/unit'
require 'fileutils'
require 'webpub/publisher_registory'
require 'webpub/eclipse_workspace'

class DistByCSVTest < Test::Unit::TestCase
	
	def prepare_test_project(&block)
		web_project = nil
		org_publish_folder = nil
		org_current_dir = Dir.pwd
		
		begin
			Webpub::PublisherRegistory.instance.collect_plugins
			proj_path = File.expand_path(File.dirname(__FILE__) + '/../..')
			
			workspace = Webpub::EclipseWorkspace.instance
			workspace.path = proj_path + '/..'
			workspace.web_projects.each { |wp|
				web_project = wp if wp.path == proj_path
			}
			
			org_publish_folder = web_project[:publish_folder]
			web_project[:publish_folder] = '.tmp_public_html'
			$: << web_project[:scripts_dir]
			
			Dir.chdir(proj_path)
			
			yield web_project
			
		ensure
			# delete test publish files
			FileUtils.rm_r(web_project[:publish_folder]) if File.exist?(web_project[:publish_folder])
			
			Dir.chdir(org_current_dir)
			if web_project
				web_project[:publish_folder] = org_publish_folder
				$:.delete(web_project[:scripts_dir])
			end
		end
	end

	def test_dist
		prepare_test_project() { |web_project|
			
			# load test target script
			require 'dist_by_csv'
			
			tmp_root_path = '.tmp'
			csvfile_path = tmp_root_path + '/test_items.csv'
			web_project[:items_csv] = csvfile_path
			web_project[:foundation_toc_path] = 'scripts/lib/tests/test_foundation.toc'
			web_project[:toc_pathes] = tmp_root_path + '/main.toc'
			
			begin
				# prepare
				FileUtils.mkdir_p(tmp_root_path)
				FileUtils.cp(web_project[:scripts_dir] + '/lib/tests/test_items.csv', csvfile_path)
				
				# chack copy successful
				assert File.exist?(csvfile_path)
				
				# publish
				desc = Webpub::PublishDescription.new('delegate', web_project)
				desc.publish_from = csvfile_path
				
				DistByCSV.new.publish(desc)
				
				# tmp root directory check
				files =  Dir.glob(tmp_root_path + '/**/*')
				assert files.any? { |f| /csv\.old$/ === f }
				assert_equal( 3, files.size)
				
				# publish check, first full publish
				files = Dir.glob(web_project[:publish_dir] + '/**/*.html').sort
				assert_equal(1, files.select { |f| /a\/index\d?.html$/ === f }.size)
				assert_equal(1, files.select { |f| /b\/index\d?.html$/ === f }.size)
				assert_equal(1, files.select { |f| /c\/index\d?.html$/ === f }.size)
				assert_equal(2, files.select { |f| /d\/index\d?.html$/ === f }.size)
				assert_equal(2, files.select { |f| /e\/index\d?.html$/ === f }.size)
				assert_equal(3, files.select { |f| /f\/index\d?.html$/ === f }.size)
				
				assert_equal(1, files.select { |f| /a_\d{2}\.html$/ === f }.size)
				assert_equal(2, files.select { |f| /b_\d{2}\.html$/ === f }.size)
				assert_equal(5, files.select { |f| /c_\d{2}\.html$/ === f }.size)
				assert_equal(6, files.select { |f| /d_\d{2}\.html$/ === f }.size)
				assert_equal(10, files.select { |f| /e_\d{2}\.html$/ === f }.size)
				assert_equal(11, files.select { |f| /f_\d{2}\.html$/ === f }.size)
				
				mtimes = Hash[ *files.map { |f| [f, File.mtime(f)] }.flatten ]
				FileUtils.cp(web_project[:scripts_dir] + '/lib/tests/test_items1.csv', csvfile_path)
				
				ItemStore.instance(csvfile_path).refresh
				
				DistByCSV.new.publish(desc)
				files = Dir.glob(web_project[:publish_dir] + '/**/*.html').sort
				
				assert_equal 1, files.select { |f| /a\/index\d?.html$/ === f }.size
				assert_equal 1, files.select { |f| /b\/index\d?.html$/ === f }.size
				assert_equal 2, files.select { |f| /c\/index\d?.html$/ === f }.size
				assert_equal 1, files.select { |f| /d\/index\d?.html$/ === f }.size
				assert_equal 2, files.select { |f| /e\/index\d?.html$/ === f }.size
				assert_equal 3, files.select { |f| /f\/index\d?.html$/ === f }.size
				
				assert_equal 2, files.select { |f| /a_\d{2}\.html$/ === f }.size
				assert_equal 1, files.select { |f| /b_\d{2}\.html$/ === f }.size
				assert_equal 6, files.select { |f| /c_\d{2}\.html$/ === f }.size
				assert_equal 5, files.select { |f| /d_\d{2}\.html$/ === f }.size
				
				newfiles = files - mtimes.keys
				actual_newfiles = [
					'items/a/a_02.html',
					'items/c/c_06.html',
					'items/c/index2.html'
				].map { |f| File.join(web_project[:publish_dir], f) }
				assert_equal(actual_newfiles, newfiles.sort)
				
				removes = mtimes.keys - files
				actual_removefiles = [
					'items/b/b_01.html',
					'items/d/d_06.html',
					'items/d/index2.html',
				].map { |f| File.join(web_project[:publish_dir], f) }
				
				assert_equal(actual_removefiles, removes.sort)
				updates = files.select { |f| mtimes[f] and File.mtime(f) > mtimes[f] }
				
				actual_updates = [
					'items/a/index.html',
					'items/b/index.html',
					'items/c/index.html',
					'items/d/index.html',
					'items/e/e_01.html',
					'items/e/e_02.html',
					'items/e/e_03.html',
					'items/e/index.html',
					'items/e/index2.html',
				].map { |f| File.join(web_project[:publish_dir], f) }
				assert_equal( actual_updates, updates)
				
				assert /New Name/ === IO.read(web_project[:publish_dir] + '/items/e/e_01.html')
				assert /100/ === IO.read(web_project[:publish_dir] + '/items/e/e_02.html')
				assert /New Description/ === IO.read(web_project[:publish_dir] + '/items/e/e_03.html')
			ensure
				FileUtils.rm_r(tmp_root_path)
			end
		}
	end


end
