require 'rexml/document'
require 'lib/itemstore'

class TocUpdater

	def initialize(foundation_toc_path)
		open(foundation_toc_path) { |fh|
			@document = REXML::Document.new(fh)
		}
		unless @document.root
			raise ArgumentError, "specify toc file can't parse: #{foundation_toc_path}"
		end
	end
	
	def item_index_nodes
		nodes = {}
		doc = @document.dup
		doc.get_elements('toc/topic/topic').each { |e|
			if %r!items/(\w)/index.html! === e.attributes['href']
				nodes[$1] = e
			end
		}
		return doc, nodes
	end
	
	attr_reader :document
	
	def dist(store, dist_path)
		unless store.is_a?(ItemStore)
			store = ItemStore.new(store)
		end
		
		categories = store.categories
		
		doc, idx_nodes = item_index_nodes()
		if categories != idx_nodes.keys.sort
			raise "different category counts: #{categories}, #{@item_index_nodes.keys.sort}"
		end
		
		categories.each { |cate|
			count = store.page_count(cate)
			node = idx_nodes[cate]
			label = node.attributes['label']
			
			(1 .. count).to_a.reverse.each { |page_idx|
				# create item index node
				n = node
				if page_idx > 1
					n = REXML::Element.new('topic')
					node.parent.insert_after( node, n)
					
					attr = node.attributes
					n.attributes['href'] = attr['href'].sub('index.html', "index#{page_idx}.html")
				end
				n.attributes['label'] = label
				n.attributes['label'] += " (#{page_idx} / #{count})" unless count == 1
				
				# create item leaves
				store.items_as_page(cate, page_idx).each { |item_code|
					data = store.item_with_linkdata(item_code)
					e = REXML::Element.new('topic')
					n << e
					e.attributes['href'] = data[:href].sub(/^\/+/, '') if data[:href]
					e.attributes['label'] = data[:name]
				}
			}
		}
		
		open(dist_path, 'w') { |fh|
			doc.write(fh)
		}
	end


end
