require 'test/unit'
require 'time'

class ItemStoreTest < Test::Unit::TestCase
	
	def setup
		$: << File.dirname(__FILE__) + '/../..'
		require 'lib/itemstore'
		
		@test_cvsfile = File.join(File.dirname(__FILE__), 'test_items.csv')
		
		@store = ItemStore.instance(@test_cvsfile)
		@store.refresh
	end

	def test_categories
		assert_equal( %w!a b c d e f!, @store.categories)
	end

	def test_instance
		assert_equal @store.hash, ItemStore.instance(@test_cvsfile).hash
	end

	def test_refresh
		assert_nil @store.items['a_02']
		
		@store.refresh(File.dirname(__FILE__) + '/test_items1.csv')
		assert @store.items['a_02']
	end

	def test_page_count
		assert_equal 1, @store.page_count('a')
		assert_equal 1, @store.page_count('b')
		assert_equal 1, @store.page_count('c')
		assert_equal 2, @store.page_count('d')
		assert_equal 2, @store.page_count('e')
		assert_equal 3, @store.page_count('f')
	end
	
	def test_itemcodes_by_category
		store = ItemStore.instance(File.dirname(__FILE__) + '/test_items.csv')
		assert_equal( 1, store.itemcodes_by_category('a').size)
		assert_equal( 11, store.itemcodes_by_category('f').size)
	end

	def test_item_index_as_page
		bgn, ed = @store.item_index_as_page('a', 1)
		assert_equal( 0, bgn)
		assert_equal( 0, ed)
		
		assert_raise(ArgumentError) {
			@store.item_index_as_page('a', 2)
		}
		
		bgn, ed = @store.item_index_as_page('b', 1)
		assert_equal( 0, bgn)
		assert_equal( 1, ed)
		
		bgn, ed = @store.item_index_as_page('c', 1)
		assert_equal( 0, bgn)
		assert_equal( 4, ed)
		
		bgn, ed = @store.item_index_as_page('d', 1)
		assert_equal( 0, bgn)
		assert_equal( 4, ed)
		
		bgn, ed = @store.item_index_as_page('d', 2)
		assert_equal( 5, bgn)
		assert_equal( 5, ed)
		
		bgn, ed = @store.item_index_as_page('e', 1)
		assert_equal( 0, bgn)
		assert_equal( 4, ed)
		
		bgn, ed = @store.item_index_as_page('e', 2)
		assert_equal( 5, bgn)
		assert_equal( 9, ed)
		
		bgn, ed = @store.item_index_as_page('f', 3)
		assert_equal( 10, bgn)
		assert_equal( 10, ed)
	end
	
	def test_items_as_page
		items = @store.items_as_page('a', 1)
		assert_equal ['a_01'], items

		items = @store.items_as_page('b', 1)
		assert_equal %w[b_01 b_02], items

		items = @store.items_as_page('c', 1)
		assert_equal %w[c_01 c_02 c_03 c_04 c_05], items

		assert_raise(ArgumentError) {
			@store.items_as_page('c', 2)
		}
		
		items = @store.items_as_page('d', 2)
		assert_equal ['d_06'], items
		
		items = @store.items_as_page('e', 2)
		assert_equal %w[e_06 e_07 e_08 e_09 e_10], items
		
		items = @store.items_as_page('f', 3)
		assert_equal ['f_11'], items
	end

end
