require 'test/unit'

=begin

== test_items1.cvs

category a add 1 items a_02
category b remove 1 items item b_01
category c add 1 items c_06
category d remove 1 items d_06
category e change item name e_01, change price e_02, change description e_03
category f no change

=end

class ItemStoreDiffTest < Test::Unit::TestCase
	
	def setup
		@selfdir = File.dirname(__FILE__)
		$: << @selfdir + '/../..'
		require 'lib/itemstore_diff'
		
		@toc_updater = ItemStoreDiff.new(@selfdir + '/test_items.csv')
	end
	
	def test_argument_error
		assert_raise(ArgumentError) {
			ItemStoreDiff.new(nil)
		}
		assert_raise(ArgumentError) {
			@toc_updater.find_update_items(100)
		}
		assert_raise(Errno::ENOENT) {
			ItemStoreDiff.new('nofile')
		}
		assert_raise(Errno::ENOENT) {
			@toc_updater.find_update_items('nofile')
		}
	end
	
	def test_nochange
		result = @toc_updater.find_update_items(@selfdir + '/test_items.csv')
		assert_equal(3, result.size)
		result.each { |k, codes|
			assert codes.empty?
		}
	end
	
	def test_find_update_items
		test_csv = @selfdir + '/test_items1.csv'
	
		result = @toc_updater.find_update_items(test_csv)
		assert_equal( %w[a_02 c_06], result[:additions])
		assert_equal( %w[b_01 d_06], result[:removes])
		assert_equal( %w[e_01 e_02 e_03], result[:changes])
		
		assert( %w[a b c d e], @toc_updater.find_update_categories(test_csv) )
	end
	
end
