require 'lib/itemstore'

class ItemStoreDiff

	def initialize(before_itemstore_filename)
		@before_store = to_itemstore(before_itemstore_filename)
	end

	def to_itemstore(obj)
		if obj.is_a?(String)
			ItemStore.new(obj)
		elsif obj.is_a?(ItemStore)
			obj
		else
			raise ArgumentError, "must be specify item store or that represents file name: #{obj}"
		end
	end

	def find_update_items(new_store)
		new_store = to_itemstore(new_store)
		if @before_store.categories != new_store.categories
			raise "not supported category count changed: #{@before_store.categories}, #{new_store.categories}"
		end
		
		items_result = { :additions => [], :changes => [], :removes => [] }
		
		new_store.categories.each { |cate|
			before_codes = @before_store.itemcodes_by_category(cate)
			
			new_store.itemcodes_by_category(cate).each { |code|
				
				bcode = before_codes.delete(code)
				if !bcode
					items_result[:additions] << code
				elsif @before_store.items[bcode] != new_store.items[code]
					items_result[:changes] << code
				end
			}
			items_result[:removes] << before_codes
		}
		items_result[:removes].flatten!
		
		items_result
	end
	
	def find_update_categories(new_store)
		new_store = to_itemstore(new_store)
		
		results = []
		find_update_items(new_store).each { |k, codes|
			codes.each { |code|
				 cate = code[0,1]
				 results << cate unless results.include?(cate)
			}
		}
		results
	end

end
