require 'webpub/amrita_publisher'
require 'lib/itemstore'
require 'fileutils'

class ItemIndexDist < Webpub::Publisher

	def publish(desc)
		if %r!(\w)/index.html$! === desc.publish_to
			@category = $1
		else
			raise "illegal publish location: #{desc.publish_to}"
		end
		
		publisher = Webpub::AmritaPublisher.new
		
		csvfile = desc.web_project[:items_csv]
		unless csvfile
			raise "must be specify web project property vlaue items_csv"
		end
		
		unless File.exist?(csvfile)
			csvfile = File.join(desc.web_project.path, csvfile)
			unless File.exist?(csvfile)
				raise "specify csv file is not exist #{csvfile}"
			end
		end
		
		(1 .. ItemStore.instance(csvfile).page_count(@category)).each { |idx|
			d = desc.dup
			pub_to_file = "index#{idx == 1 ? '' : idx}.html"
			d.publish_to = desc.publish_to.sub(/index\.html$/, pub_to_file)
			
			d.arguments['script'] = 'item_index.rb'
			d.arguments['class'] = 'ItemIndex'
			
			publisher.publish(d)
		}
	end

end
