require 'webpub/amrita_publisher'
require 'lib/itemstore'

class ItemDist < Webpub::Publisher

	def initialize
		@publisher = Webpub::AmritaPublisher.new
	end

	def publish(desc)
		if %r!/(\w)/\w_.+?.html$! === desc.publish_to
			@category, code = $1
		else
			raise "illegal publish location: #{desc.publish_to}"
		end
		
		ItemStore.instance( desc.web_project[:items_csv] ).itemcodes_by_category(@category).each { |code|
			d = desc.dup
			pub_to_file = "#{code}.html"
			d.publish_to = File.join(File.dirname(desc.publish_to), pub_to_file)
			d.arguments['script'] = 'item.rb'
			d.arguments['class'] = 'Item'
			
			@publisher.publish(d)
		}
	end

end
