require 'base'
require 'lib/itemstore'

class Item < Base

	def initialize(desc)
		super(desc)
		
		if /(\w_\d\d)\.html$/ === desc.publish_to
			@code = $1
		elsif /(\w)_item_delegate\.html$/ === desc.publish_to
			@code = "#{$1}_01"
		else
			raise "illegal publish location: #{desc.publish_to}"
		end
		
		@store = ItemStore.instance(desc.web_project[:items_csv])
		@item = @store.item_with_linkdata(@code, 'big')
		
		self[:item_name] = @item[:name]
	end
	
	attr_reader :item

end
