require 'webpub/amrita_publisher'
require 'fileutils'
require 'lib/itemstore_diff'
require 'item_dist'
require 'lib/toc_updater'
require 'sitemapper/navigation'

class DistByCSV < Webpub::Publisher

	def initialize
	end

	def publish(desc)
		# check arguments
		unless File.extname(desc.publish_from) == '.csv'
			raise ArgumentError, "must be specify source is csv file: #{desc.publish_from}"
		end
		
		unless File.exist?(desc.publish_from)
			raise ArgumentError, "not exist: #{desc.publish_from}"
		end
		
		before_csv_path = desc.publish_from.sub(%r!/(.+?.csv)$!, '/\1.old')
		if before_csv_path == desc.publish_from
			$stderr << "specify file is not catalog file: #{desc.publish_from}"
			return
		end
		
		# update toc files
		foundation_toc_path = desc.web_project[:foundation_toc_path]
		dist_toc_path = desc.web_project[:toc_pathes].split(/\s+/)[0]
		TocUpdater.new(foundation_toc_path).dist(desc.publish_from, dist_toc_path)
		SiteMapper::NavigatorFactory.clear_cache
		
		# dist pages
		if File.exist?(before_csv_path)
			incremental_publish(desc, before_csv_path)
		else
			full_publish(desc)
		end
		
		FileUtils.cp(desc.publish_from, before_csv_path)
	end

	def incremental_publish(desc, before_csv_path)
		diff = ItemStoreDiff.new(before_csv_path)
		diff.find_update_categories(desc.publish_from).sort.each { |cate|
			dist_itemindex_pages(desc, cate)
		}
		update_items = diff.find_update_items(desc.publish_from)
		
		(update_items[:additions] + update_items[:changes]).each { |itemcode|
			dist_itempage(desc, itemcode)
		}
		update_items[:removes].each { |itemcode|
			to = item_pubto_path(desc, itemcode)
			FileUtils.rm_f(to)
		}
	end

	def full_publish(desc)
		# all_distribute
		store = ItemStore.instance(desc.publish_from)
		store.categories.each { |cate|
			dist_itemindex_pages(desc, cate)
		}
		store.items.keys.sort.each { |itemcode|
			dist_itempage(desc, itemcode)
		}
	end

	def item_pubfrom_path(desc, itemcode)
		cate = itemcode[0,1]
		File.join( desc.web_project[:htsources_dir], 'items', cate, "#{cate}_item_delegate.html")
	end

	def item_pubto_path(desc, itemcode)
		cate = itemcode[0,1]
		File.join(desc.web_project[:publish_dir], 'items', cate, "#{itemcode}.html")
	end

	def dist_itempage(desc, itemcode)
		d = Webpub::PublishDescription.new('amrita', desc.web_project)
		d.ht_filters << Webpub::AbsToRelFilter.new
		d.publish_from = item_pubfrom_path(desc, itemcode)
		d.publish_to = item_pubto_path(desc, itemcode)
		d.arguments['script'] = 'item.rb'
		d.arguments['class'] = 'Item'
		publisher = Webpub::PublisherRegistory.instance[d.by]
		publisher.publish(d)
	end
	
	def dist_itemindex_pages(desc, cate)
		csvfile = desc.publish_from
		source = desc.web_project[:htsources_dir] +  "/items/#{cate}/index.html"
		
		unless File.exist?(source)
			raise ArgumentError, "category index distribute seed page is not exist: #{source}"
		end
		
		d = desc.web_project.publish_description_factory.create(source)
		FileUtils.rm( Dir.glob(File.dirname(d.publish_to) + '/index*.html') )
		publisher = Webpub::PublisherRegistory.instance[d.by]
		publisher.publish(d)
	end

end
