#
# $Id: rd_publisher.rb,v 1.6 2004/06/06 22:38:21 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'rd/rd2html-lib'
require 'rd/rdfmt'
require 'webpub/publisher'

=begin

=end
module Webpub

class RDPublisher < Publisher

	@@argument_names = %w!css lang charset title html_link_rel output_rbl!

	def to_html(desc)
		visitor = $Visitor_Class.new
		
		args = desc.arguments.dup
		args['charset'] = desc.web_project[:encoding] || 'UTF-8'
		
		lines = IO.read(desc.publish_from)
		flags = 0
		lines.each { |l|
			if /^#(.+):(.+)/ === l
				n = $1.strip
				args[n] = $2.strip if @@argument_names.include?(n)
			end
			flags += 1 if /^=begin/ === l
			flags += 1 if /^=end/ === l
		}
		lines = "=begin\n" + lines + "\n=end" if flags != 2
		
		@@argument_names.each { |n|
			visitor.__send__(n + '=', args[n]) if args[n]
		}
		tree = RD::RDTree.new(lines, [], nil)
		tree.parse
		visitor.visit(tree)
	end

	def publish(desc)
		begin
			htlines = to_html(desc)
			open(desc.publish_to, 'w') { |fh|
				fh << htlines
			}
		rescue Exception
			if @error_distribute and desc.ht_type? and desc.publish_to
				open(desc.publish_to.gsub('*', '').gsub('?', ''), 'w') { |fh|
					fh << "<body><h4>#{CGI.escapeHTML($!.message)}</h4>"
					fh << %Q!<pre>#{CGI.escapeHTML($!.backtrace.join("\n"))}</pre>!
					fh << '</body>'
				}
			end
			raise $!.class, $!.message, $!.backtrace
		end
	end
end

end
