#
# $Id$
# Copyright Narushima Hironori. All rights reserved.
#

require 'singleton'
require 'rexml/document'
require 'webpub/publisher'

module Webpub

class PublisherRegistory

	include Singleton
	
	attr_accessor :error_output

	def initialize
		@plugins = {}
		@publishers = Hash.new { |hash, key|
			hash[key] = {}
		}
		@error_output = $stderr
	end

	def collect_plugins(plugins_location = File.expand_path(File.dirname(__FILE__) + '/../../../..') )
		registed_publisher_ids = []
		if File.directory?(plugins_location)
			Dir.glob(plugins_location + '/*/plugin.xml') { |xmlfile|
				registed_publisher_ids << regist_plugin(xmlfile)
			}
		elsif File.file?(plugins_location)
			regist_plugins_from_entry_file(plugins_location)
		else
			raise ArgumentError, "file not found, musb be specify plugins directory or plugins location cache file: #{plugins_location}"
		end
		
		registed_publisher_ids.flatten.compact
	end

	def regist_plugins_from_entry_file(entry_file)
		lines = IO.readlines(entry_file).map { |l| l.strip }.select { |l| !l.empty? }
		until lines.empty?
			regist(lines.shift, lines.shift, lines.shift)
		end
	end

	def regist_plugin(plugin_path)
		xmlfile = File.directory?(plugin_path) ? plugin_path + '/plugin.xml' : plugin_path
		
		doc = REXML::Document.new(IO.read(xmlfile))
		id = doc.elements['plugin'].attributes['id']
		
		registed_publisher_ids = []
		doc.each_element('*/extension') { |ext_elem|
			if ext_elem.attributes['point'] == 'com.narucy.webpub.core.publishers'
				
				dir = File.dirname(xmlfile)
				$: << dir unless $:.include?(dir)
				
				ext_elem.each_element('publisher') { |pub_elem|
					id = pub_elem.attributes['id']
					script_file = File.join(dir, pub_elem.attributes['script'])
					class_name = pub_elem.attributes['class']
					
					registed_publisher_ids << regist(id, script_file, class_name)
				}
			end
		}
		registed_publisher_ids.compact
	end
	
	def ids
		@publishers.map { |k, entry|
			entry[:instance] ? k : nil
		}.compact
	end
	
	def regist(id, script_file, class_name)
		begin
			require script_file
			instance = eval(class_name).new
			@publishers[id][:instance] = instance
			@publishers[id][:script_file] = File.expand_path(script_file)
			
			id
		rescue Exception => err
			@publishers[id][:error] = err
			@error_output << Webpub::to_fail_str(err)
			
			nil
		end
	end

	def unregist(id)
		@publishers.delete(id)
	end

	def clear
		@publishers.clear
	end

	def [](id)
		@publishers[id][:instance]
	end

	def regist_failed_publisher_ids
		@publishers.map { |id, entry| entry[:error] ? id : nil }.compact
	end

	def registed_error(id)
		@publishers[id][:error]
	end

	def store_publisher_entry_file(filepath)
		open(filepath, 'w') { |fh|
			ids().each { |id|
				fh.puts(id)
				fh.puts("\t" + @publishers[id][:script_file])
				fh.puts("\t" + @publishers[id][:instance].class.name)
				fh.puts
			}
		}
	end

end

end
