#
# $Id$
# Copyright Narushima Hironori. All rights reserved.
#

require 'rexml/document'
require 'webpub/publisher'

module Webpub

class PublishDescription

	def initialize(by, web_proj)
		raise ArgumentError, 'need to specify publish code' unless by
		
		@by = by
		@web_project = web_proj
		@publish_from = nil
		@publish_to = nil
		@arguments = {}
		
		@ht_filters = []
		# @io_filters = [] # for image publihing. (low priority feature)
	end
	
	attr_reader :by, :web_project, :arguments, :ht_filters
	attr_accessor :publish_from, :publish_to
	
	def publish_from=(from)
		unless /^#{@web_project.path}/i === from
			from = File.join(@web_project.path, from)
		end
		@publish_from = File.expand_path(from)
	end
	
	def ht_type?
		exts = @web_project[:ht_extensions] || 'html htm erb'
		exts.split.each { |ext|
			return true if @publish_to and File.extname(@publish_to) == '.' + ext
		}
		false
	end

end

end
